function [labelNoise]=simulatedNoiseRemoving(clusterCenters,MaskVector,M,N, num_mser)
%Remove the noise of simulated data
%If labelNoise is equal to zero, the corresponding component is noise
clusterNumber=size(clusterCenters,1);

for i=1:clusterNumber
    kk=1;
    for j=1:length(MaskVector)
        if MaskVector(j)~=0
            tempVector(j)=clusterCenters(i,kk);
            kk=kk+1;
        else
            tempVector(j)=0;
        end
    end
    
    tempMatrix=reshape(tempVector,M,N);
    [mserRegions,cc] = detectMSERFeatures(tempMatrix);
    NumObjects(i)=cc.NumObjects;
end

flag=[];
k=1;
for i=1:clusterNumber
     if NumObjects(i)>=num_mser
        flag(k)=i;
        k=k+1;
     end
end
labelNoise=zeros(size(clusterCenters,1),1);
labelNoise(flag)=1;
end

