function [labelNoise]=realNoiseRemoving(ICs,TCs,MaskVector,M,N,L,path)
%This function performs real data denoising based on Noisecould by using spatial features of ICs.
%If labelNoise is equal to one, the corresponding component is noise.

clusterNumber=size(ICs,1);
%parpool("threads");
for i=1:clusterNumber
    kk=1;
    for j=1:length(MaskVector)
        if MaskVector(j)~=0
            tempVector(j)=ICs(i,kk);
            kk=kk+1;
        else
            tempVector(j)=0;
        end
    end
    tempIC=reshape(tempVector,M,N,L);
    tempIC(find(abs(tempIC)<3))=0;
    tempTC=TCs(:,i);
    tempSpatialFeatures(i,:)=extractSpatialFeatures(tempIC);
    tempTemporalFeatures(i,:)=extractTemporalFeatures(tempTC);
end
save ([path,'\SpatialAndTemporalFeatures.mat'],'tempSpatialFeatures','tempTemporalFeatures');
%load ([path,'\SpatialAndTemporalFeatures.mat']);
%Set the range of each parameter to distinguish between noise and composition
%In this work, noise removal is carried out on the following features
feat_kurtosis1=tempSpatialFeatures(:,1);
fAAL2=tempSpatialFeatures(:,2:167);
feat_average_min_max3=tempSpatialFeatures(:,168:170);
featZScoreConnectNodes4=tempSpatialFeatures(:,171:172);
featSpatial5=tempSpatialFeatures(:,173);
featMirrored6=tempSpatialFeatures(:,174);
featSkewness7=tempSpatialFeatures(:,175);
featActivation8=tempSpatialFeatures(:,176:185);

features(:,1)=feat_kurtosis1;%A<thr1
thr1=graythresh(features(:,1));


for i=1:size(fAAL2,1)
    temp=fAAL2(i,:);
    %The first represents the number of voxels in the three largest brain regions,
    %and the remaining three represent the total number of active voxels
    maxValue(i,1)=sum(temp);
    [maxValue(i,2),pos1]=max(temp);
    temp(pos1)=0;
    [maxValue(i,3),pos2]=max(temp);
    temp(pos2)=0;
    [maxValue(i,4),pos3]=max(temp);
    temp(pos3)=0;
    [maxValue(i,5),pos4]=max(temp);
    temp(pos4)=0;
    [maxValue(i,6),pos5]=max(temp);
    clear temp pos1 pos2 pos3;
    features(i,2)=sum(maxValue(i,2:6))/maxValue(i,1);
end
thr2=graythresh(features(:,2));

thr3=0;
thr4=0;

features(:,5)=featSpatial5;
thr5=graythresh(features(i,5));

features(:,6)=featMirrored6;
thr6=graythresh(features(i,6));

features(:,7)=featSkewness7
thr7=graythresh(features(i,7));

thr8_1=0;

for i=1:size(features,2)
    featureZ(:,i)=(features(:,i)-min(features(:,i)))/(max(features(:,i))-min(features(:,i)));
end

for i=1:size(features,1)
    featureALL(i,1)=0.5*featureZ(i,1)-0.5*featureZ(i,2)+0.0*featureZ(i,5)-0*featureZ(i,6)+0.0*featureZ(i,7);
end

flag=[];
k=1;
for i=1:clusterNumber
    %if features(i,1)>3||features(i,2)<0.3||features(i,5)>1.5||features(i,6)<0.485||...
       %     features(i,7)>3
    if  featureALL(i,1)>0.05
        flag(k)=i;
        k=k+1;
    end
end
reliableICs=ICs;
reliableICs(flag,:)=[];
labelNoise=zeros(size(ICs,1),1);
labelNoise(flag)=1;
end