function realICShow(IC,path,Mask,v)
%Display simulated data components
M=length(Mask(:,1,1));
N=length(Mask(1,:,1));
L=length(Mask(1,1,:));
MaskVector=reshape(Mask,1,[]);
structFile=[fileparts(mfilename('fullpath')),'\three_view\ch2better_aligned2EPI.nii'];
for i=1:size(IC,1)
    k=1;
    for j=1:length(MaskVector)
        if MaskVector(j)~=0
            tempIC(j)=IC(i,k);
            k=k+1;
        else
            tempIC(j)=0;
        end
    end
    temp_3D_1=reshape(tempIC,M,N,L);
    
    v.fname = [path,'\temp_3D_1.nii'];
    cd (path);
    h=gcf;
    spm_write_vol(v, temp_3D_1);
    fnames = mci_interp2struct('temp_3D_1.nii', 1, structFile, path);
    [slices, FH] = mci_makeimage(fnames, structFile,1,'threshold_low',3);
    
    h=gcf;
    print (h,'-dtiff','-r500',[path,'\IC',num2str(i),'.tif']);
    close all;
end