function [newICls,newIC2s,newTCls,newTC2s,MatchedCorr]=matchOfICs(IC1s,IC2s,TC1s,TC2s)
%The two sets of ICs are matched
%ICs: n*m
%     n: the number of ICs, m: the number of features for each IC.
%TC: T*n
currCorr=corr(IC1s',IC2s');%The abscissa represents group1, and the ordinate represents group2.
for i=1:min([size(IC1s,1),size(IC2s,1)])
    MaxValue(i)=max(max(currCorr));
    [currRow(i),currCol(i)]=find(currCorr==MaxValue(i));
    currCorr(currRow(i),:)=0;
    currCorr(:,currCol(i))=0;
    newICls(currRow(i),:)=IC1s(currRow(i),:);
    newIC2s(currRow(i),:)=IC2s(currCol(i),:);
    newTCls(:,currRow(i))=TC1s(:,currRow(i));
    newTC2s(:,currRow(i))=TC2s(:,currCol(i));
    MatchedCorr(currRow(i))=MaxValue(i);
end
if size(IC1s,1)>size(IC2s,1)
    IC1s(currRow,:)=[];
    newICls=[newICls;IC1s];
    TC1s(:,currRow)=[];
    newTCls=[newTCls,TC1s];
end
if size(IC1s,1)<size(IC2s,1)
    IC2s(currCol,:)=[];
    newIC2s=[newIC2s;IC2s];
    TC2s(:,currCol)=[];
    newTC2s=[newTC2s,TC2s];
end
end