function [ICs,TCs,mark]=consolidationSimilarICs(ICs,TCs,reliableICs)
%The consolidation of networks of similar ICs,and keep the correspondence between the   
%components and the individual components
%mark==1 mark the label of unablle ICs and TCs.
mark=zeros(size(reliableICs,1),1);
while 1
    corrMat=triu(corr(ICs')-eye(size(ICs,1)));
    [row_1,col_1]=find(corrMat>0.5);
    [row_2,col_2]=find(corrMat<-0.5);
    row=[row_1;row_2];
    col=[col_1;col_2];
    if isempty(row)
        break;
    else
        for j=1:length(row)
            if corrMat(row(j),col(j))<-0.5
                ValueRow=sum(corrMat(row(j),:));
                ValueCol=sum(corrMat(:,col(j)));
                if (ValueRow>ValueCol)&ValueCol<1
                    tempIC=(ICs(row(j),:)+ICs(col(j),:)*-1)/2;
                    tempTC=(TCs(:,row(j))+TCs(:,col(j))*-1)/2;
                    if corr(reliableICs(row(j),:)',tempIC')>corr(reliableICs(col(j),:)',tempIC')
                        ICs(row(j),:)=tempIC;
                        TCs(:,row(j))=tempTC;
                        ICs(col(j),:)=zeros(1,size(ICs,2));
                        TCs(:,col(j))=zeros(size(TCs,1),1);
                        mark(col(j))=1;
                    else
                        ICs(col(j),:)=tempIC;
                        TCs(:,col(j))=tempTC;
                        ICs(row(j),:)=zeros(1,size(ICs,2));
                        TCs(:,row(j))=zeros(size(TCs,1),1);
                        mark(row(j))=1;
                    end
                end
            end
            if corrMat(row(j),col(j))>0.5
                tempIC=(ICs(row(j),:)+ICs(col(j),:))/2;
                tempTC=(TCs(:,row(j))+TCs(:,col(j)))/2;
                if corr(reliableICs(row(j),:)',tempIC')>corr(reliableICs(col(j),:)',tempIC')
                    ICs(row(j),:)=tempIC;
                    TCs(:,row(j))=tempTC;
                    ICs(col(j),:)=zeros(1,size(ICs,2));
                    TCs(:,col(j))=zeros(size(TCs,1),1);
                    mark(col(j))=1;
                else
                    ICs(col(j),:)=tempIC;
                    TCs(:,col(j))=tempTC;
                    ICs(row(j),:)=zeros(1,size(ICs,2));
                    TCs(:,row(j))=zeros(size(TCs,1),1);
                    mark(row(j))=1;
                end
            end
        end
    end
end
end