function [initialICs]=IndividualGroupPCAICA(data_path,numberOfComponents)
%This function completes PCA and ICA at the individual and group levels and
%returns initial group-level independent components
numberOfSubjects=length(dir([data_path,'\subject*.mat']));
initialICs=[];
for i=1:length(numberOfComponents)
    currentNumberOfComponents=numberOfComponents(i);
    
    
    %individual PCA
    individualICs=[];
    for j=1:numberOfSubjects
        tempData=importdata([data_path,'\subject',num2str(j),'.mat']);
        tempICs=GIG_CalPCA(tempData',currentNumberOfComponents);
        individualICs=[individualICs;tempICs'];
        clear tempICs tempData;
    end
    
    %group PCA
    groupICs=[];
    tempICs=GIG_CalPCA(individualICs',currentNumberOfComponents);
    groupICs=tempICs';
    clear tempICs;
    
    %group ICA
    disp('Start group level ICA for geting group components......................................');
    [A2, tempIninialICs] = useICASSO(groupICs, 'Infomax');
    close all;
    
    
    %The components are reversed according to kurtosis.
    for jj=1:size(A2,1)
        if kurtosis(tempIninialICs(jj,:))<0
            tempIninialICs(jj,:)=tempIninialICs(jj,:)*-1;
            A2(:,jj)=A2(:,jj)*-1;
        end
    end
    initialICs=[initialICs;tempIninialICs];
    clear tempIninialICs;
end
end