function noiseLabel=IdentifyNoise(ICs,TCs,Mask)
%IC, The numner of ICs * the number of voxel
%TC, The time points for each TC * the number of TCs
%noiseLabel, the number of ICs *1, 
%            if the noiseLabel is 1, represent the noise IC
%            if the noiseLabel is 0, represnt a signal IC
MaskVector=reshape(Mask,1,[]);
MaskLabel=find(MaskVector~=0);
M=size(Mask,1);
N=size(Mask,2);
L=size(Mask,3);
num=size(ICs,1);
noiseLabel=zeros(size(ICs,1),1);
tempICZeros=zeros(length(MaskVector),1);


%Calculation of features
for i=1:num
    tempIC=ICs(i,:);
    tempICZeros(MaskLabel)=tempIC;
    temp3D=reshape(tempICZeros,M,N,L);
    temp3D(find(abs(temp3D)<3))=0;
    tempSpatialFeatures(i,:)=extractSpatialFeatures(temp3D);
    
    tempTC=TCs(:,i);
    tempTemporalFeatures(i,:)=extractTemporalFeatures(tempTC);
    %1:Percentage of high frequency noise above specified index (1)
    %2:Calculations for minimum and maximum peak values, as well as amplitude（9)
    %3:We calculate the spectral power below 0.10 Hz over the power between 0.15 and 0.25 Hz(2)
    clear tempIC temp3D;
end
%save D:\Work\Project\ICA\journal\method9\result\real\lowAndHighModel\resultSummary\features.mat tempSpatialFeatures tempTemporalFeatures;
%The proportion of activated areas in gray matter minus the proportion of
%activated areas in the limbic area of brain.
thr2=graythresh(tempSpatialFeatures(:,2));
thr5=graythresh(tempSpatialFeatures(:,5));%

ICnoiseLabel1=find(tempSpatialFeatures(:,2)<thr2);
ICnoiseLabel2=find(tempSpatialFeatures(:,5)>thr5);

ThrQupon=prctile(tempTemporalFeatures,75);
TCnoiseLabel=find(tempTemporalFeatures>ThrQupon);

noiseLabel(unique([ICnoiseLabel1;ICnoiseLabel2;TCnoiseLabel]),1)=1;
end