%duyuhui2017,04,01
%For frontier paper, I will generate more sources as subject-unique
%sources.Also,I will try to increase the total number of sources.

% Directory to save simulation parameters and output
out_path = 'E:\aMRN\aProject\CompareIVAGIGICA\SimulationNew\MoreUniqueSources';

% Prefix for saving output
prefix = 'MoreUniqueSources';

%1````````````````````````````````````````````````
%***** Constants for setting up simulations *******
nC = 27;  % number of components            about a third of actual number of components (maybe)
nV = 148; % number of voxels                roughly proportional to number of components per voxels
nT = 150; % number of time points           5 minute scan, common for resting state
TR = 2;   % sampling rate of 0.5 Hz         common TR
M  = 10;  % number of subjects              common analysis size    %change ````````````
seed = sum(clock);  % Default RAND seed


%2`````````````````````````````````````````````````
% choose the sources; type pickSM() to launch a GUI
SM_source_ID = [3 6 8 22 23 16 17 12 4 5 9 10 18 25 26 19 20 27 2 7 11 13 14 15 21 24 25];  % the first 7 components is useful components, others are noise components
%3 6 8 22 23 16 17 are common sources
%12 4 5 9 10 18 25 26 19 20 are the first unique source for subject 1 to 10
%1 2 7 11 13 14 15 21 24 25

[junk, comps_of_interest] = intersect(SM_source_ID, 30);

%SM_present: [M x nC] matrix for component presence: 1 if component is included, 0 otherwise
% set each component to have 80% chance of appearing
SPusful=ones(M,7);
SM_present = [SPusful,diag(ones(1,M)),diag(ones(1,M))];     % They're all present for all subjects

%generate the variability randomly.
SM_translate_x = 3*randn(M,nC); %change ````````````
SM_translate_y = 3*randn(M,nC);%change ````````````
SM_theta = 1*randn(M,nC);%change ````````````
SM_spread = 1+0.03*randn(M,nC);%change ````````````


%3`````````````````````````````````````````````````````````
% choose the model for TC generation
TC_source_type = ones(1,nC);    % convolution with HRF for all components
% initialize the cells
TC_source_params = cell(M,nC);  % same HRF for all subjects and components to facilitate comparisons between subjects
% use identical HRF params for all components
P(1) = 5;    % delay of response (relative to onset)
P(2) = 13;   % delay of undershoot (relative to onset)
P(3) = 1;    % dispersion of response
P(4) = 1;    % dispersion of undershoot
P(5) = 5;    % ratio of response to undershoot
P(6) = 0;    % onset (seconds)
P(7) = 24;   % length of kernel (seconds)
[TC_source_params{:}] = deal(P);


% Use a HF noise TC for component 8
TC_source_type(8:nC) = 3;
P_hf(1) = 1;
P_hf(2) = 4;
P_hf(3) = .8;
P_hf(4) = .8;
P_hf(5) = 4;
P_hf(6) = 0;
P_hf(7) = 10;
[TC_source_params{:,8:nC}] = deal(P_hf);


TC_unique_FLAG = 1; % default has all TCs defined by unique events to be different for each subject/component
TC_unique_prob = 0.5*ones(1,nC);  % [1 x nC]  vector of probabilities that unique event occurs at each TR
TC_unique_amp  = ones(M,nC);      % [M x nC]  matrix of amplitude of unique events

% %*****Set FLAGS (1 for yes, 0 for no) and params for making TCs with block events
% TC_block_n = 2; % Number of blocks [set = 0 for no block design]
% TC_block_same_FLAG = 0;  % 1 = block structure same for all subjects
%                          % 0 = block order will be randomized
% TC_block_length = 20;    % length of each block (in samples)
% TC_block_ISI    = 15;    % length of OFF inter-stimulus-intervals (in samples)
% TC_block_amp    = zeros(nC, TC_block_n); % initialize [nC x TC_block_n] matrix
% TC_block_amp(6,1) = 3;   % Comp 3 is strongly modulated by condition 1
% TC_block_amp(6,2) = 1; % Comp 3 is weakly modulated by condition 2, % change```````
% TC_block_amp(7,1) = 1;  % Comp 4 is negatively modulated by condition 1 % change``````
% TC_block_amp(7,2) = 3; % Comp 4 is strongly modulated by condition 2
% %--------------


%4``````````````````````````````````````````````````````````````
% [1 x M] vector of baseline signal intensity for each subject
D_baseline = 800*ones(1,M);   % same baseline for all subjects
%D_baseline = 0*ones(1,M); 


% FLAG to include different tissue types (distinct baselines in the data)
D_tt_FLAG = 0;          % no distinct tissue types

% [M x nC] vector of peak-to peak percent signal changes for each subject/component
D_pSC = 3*ones(M,nC);   % all components have the same amplitude in percent signal change

% FLAG to add rician noise to the data
D_noise_FLAG = 1;      % include rician noise

% [1 x M] vector of contrast-to-noise ratio for each subject
D_CNR = 2*ones(1,M);    % typically between 0.5 and 3 for task-based fMRI experiments, ``````change


%5````````````````````````````````````````````````````````````
% FLAG to write data in NIFTI format rather than matlab
saveNII_FLAG = 1;

% Option to display output throughout the simulations
verbose_display =1;


