function [W, A, IC] = GIG_IcaAlgorithm(ica_algorithm, data)
%%  ICA for data using Infomax algorithm
%
% Inputs:
%
% No inputs gives all the algorithms available
% 1. ica_algorithm - Number or specify the algorithm name directly
% 2. data - 2D matrix whose dimensions are components number by voxel number
%
%
% Outputs:
%  W - Weights matrix (components by components)   Ϊ
%  A - inverse of Weights (components by components) ϾΪ
%  IC - Sources (components by voxel number) ԴźţsICsڵľ
%
% writeen by duyuhui CAS2011.


icaAlgo = str2mat('Infomax'); %ĿǰֻʹInfomax

if (nargin > 2)
    error('Max number of input variable allowed is 2.');
end
if (nargout > 3)
    error('Max number of output variable allowed is 3.');
end

% if there are more than one arguments
if (nargin > 0 && nargin <= 2)
    
    if ischar(ica_algorithm)
        selected_ica_algorithm = lower(deblank(ica_algorithm));
        matchIndex = strmatch(selected_ica_algorithm, lower(icaAlgo), 'exact');
        if isempty(matchIndex)
            disp('no this ICA algorithm here, Infomax was used.');
           
        end
    end
    
end

   
   %% Infomax
            
    [W, sphere, IC] = GIG_InfomaxIca(data);
     W = W*sphere;
     IC = W*data;
     A = pinv(W);
        
            
   
end
    
    
