function A = GIG_Cov(X)
%% Compute covariance matrix. If out of memory error occurs, covariance matrix is
% computed with least memory requirements.
%
% Inputs:
% 1. X - Data of size m by nÿһдһ

% Outputs:
%
% 1. A - Covariance matrix Э
%
%  duyuhui,CAS.
[m, n] = size(X);

try
    A = X'*X;
catch % tryɹ
    %% Use less memory for computing covariance matrix
    A = zeros(n, n);

    %% Loop over cols
    for i = 1:n
        currentVector = X(:, i);
        inds = (i:n);
        % Loop over nInd
        for nInd = inds
            temp = currentVector(:)'*X(:, nInd);
            %% Utilise the symmetric nature of the covariance matrix
            A(i, nInd) = temp;
            A(nInd, i) = temp;
        end
        % End loop over nInd
    end
    %% End loop over cols

end

%% Return the final result
if (m > 1)
    A = A ./ (m - 1);
else
    A = A ./ m;
end
