function [NewData,WhitenMatrix,DewhitenMatrix] = GIG_CalPCA(data, numpc,removeMean)
%% Calculates principal components
%
% Inputs:
% 1. data -  2D matrix whose dimensions are number of voxels (regions in the
%            mask) by time points.   ��СΪ������*ʱ�����Ҳ����˵ÿһ��Ϊһ������
% 2. numpc - number of principal components
% 3. removemean-value of 0 or 1, and 1 is recommended.
% Outputs:
% 1. NewData - Whitened signal,whose dimensions are number of voxels (regions in the
%            mask) by numpc.
% 2. WhitenMatrix- Matrix for whiteen data'

% written by duyuhui, CAS,China,2011

%% Pre-processing options
if nargin<3
    removeMean = 1; %Ĭ��ȥ��ֵ
end

if (removeMean == 1)

    data = GIG_RemoveMean(data); %ȥ��
    %
end





% PCA
[NewData,WhitenMatrix,DewhitenMatrix,Vsort, dsort] = GIG_Pca(data,numpc);

clear data;



