%duyuhui,2017,04,01
%use more subject-common sources to test
clc;
clear all;
close all;
date='CompareGIGIVA_170401';

CMdata = load('CM_coldhot_256');
CMAP = CMdata.CM;
ICnum=27;%real ICnum, not used here.
timepoints=150;
M=148;N=148;L=1;
sbnum=10;

DataParameter='MoreCommonSources';

mkdir(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date)));
binsPara=3;
CNR=1;
v0=spm_vol(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationNew\',num2str(DataParameter),'\',num2str(DataParameter),'_MASK.nii'));
MaskData=spm_read_vols(v0);
MaskData=round(MaskData);
VoxNum=size(find(MaskData==1),1);
MaskVec=reshape(MaskData,1,[]);
%%
%compute templates, and use the templates to match results from GIG-ICA(or
%IVA)and real sources
SumTemIC=zeros(ICnum,M*N);
for i=1:sbnum
    if i<10
        strzero='00';
    else if i>9&&i<100
            strzero='0';
        end
    end
    load (strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationNew\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_SIM.mat'));
    SumTemIC=SumTemIC+SM;
    
end
TemIC=SumTemIC/sbnum;
TemICInMask=zeros(ICnum,VoxNum);
h=1;
for k=1:M*N*L
    if MaskVec(k)==1
        TemICInMask(:,h)=TemIC(:,k);
        h=h+1;
    end
end

%%
%Use IVA to compute individual ICs/TCs
FirIndiIC=zeros(sbnum*ICnum,VoxNum);

FmriMatr=[];IVAAllsubPCAOut=[]; FmriMatMaskAllSub=[];
IVASubPC1num=27;
for i=1:sbnum
    if i<10
        strzero='00';
    else if i>9&&i<100
            strzero='0';
        end
    end
    v=spm_vol(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationNew\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_DATA.nii'));
    dat=spm_read_vols(v);
    for j=1:timepoints
        FmriVec=reshape(dat(:,:,:,j),1,[]);
        FmriMatr(j,:) = FmriVec;
    end
    %     figure;
    %     imshow(reshape(FmriMatr(1,:),M,N),[]);
    %1).implement individual ICA
    
    FmriMatMask=zeros(timepoints,VoxNum);
    h=1;
    for k=1:M*N*L
        if MaskVec(k)==1
            FmriMatMask(:,h)=FmriMatr(:,k);
            h=h+1;
        end
    end
    FmriMatMaskAllSub(:,:,i)=FmriMatMask;
    [IndiPCAOut,WhitenMatrix,DewhitenMatrix]=GIG_CalPCA(FmriMatMask',IVASubPC1num);
    
    IVAAllsubPCAOut(:,:,i)=IndiPCAOut';
    
end

W = icatb_iva_second_order(IVAAllsubPCAOut, 'whiten', false);
ICA_Options = {'maxIter', 1024, 'termThreshold', 1e-6, 'alpha0', 0.1, 'verbose', true,'whiten', false, 'initW', W};

disp('Weights from second order IVA are used as initial weights in laplacian IVA. Computing laplacian IVA ...');
W = icatb_iva_laplace(IVAAllsubPCAOut, ICA_Options{:}); % run iva-l, initialized with iva-g result

for n = 1:size(W, 3)
    S = squeeze(W(:, :, n)*IVAAllsubPCAOut(:, :, n))';
    sk = sign(icatb_skewness(S) + eps);
    W(:, :, n) = diag(sk)*W(:, :, n);
    clear S;
end

IVAICAllsubMat=zeros(size(IVAAllsubPCAOut));
for i=1:sbnum
    IVAICAllsubMat(:,:,i)=W(:,:,i)*IVAAllsubPCAOut(:,:,i);
end

%     for i=1:sbnum
%         IVAICMat=IVAICAllsubMat(:,:,i);
%         IVAIndiICPlMask=zeros(IVASubPC1num,M*N*L);
%         h=1;
%         for K=1:M*N*L
%             if MaskVec(K)==0
%                 IVAIndiICPlMask(:,K)=0;
%             else
%                 IVAIndiICPlMask(:,K)=IVAICMat(:,h);
%                 h=h+1;
%             end
%         end
%
%         %         h0=figure;
%         %         for k=1:IVASubPC1num
%         %             subplot(IVASubPC1num,1,k);
%         %             imshow(reshape(IVAIndiICPlMask(k,:),M,N),[]);
%         %
%         %         end
%
%     end

%%
%evaluate IVA's results
%compute the mean IC maps across subjects for matching with template
IVAICAllsubMatMean=mean(IVAICAllsubMat,3);

SimGICsN1Tem=corr(IVAICAllsubMatMean',TemICInMask');%
%following is matching mean ICs from IVA and templates
MatchV=[];
MatchH=[];
MatchL=[];
DirectioN1GB=[];
SimGICsN1TemG=SimGICsN1Tem;
for i=1:ICnum
    MaxValue=max(max(abs(SimGICsN1TemG)));
    MatchV=[MatchV,MaxValue];
    if size(find(SimGICsN1TemG==MaxValue),1)
        P=find(SimGICsN1TemG==MaxValue);
        DirectioN1GB(i)=1;
    else if size(find(SimGICsN1TemG==-MaxValue),1)
            P=find(SimGICsN1TemG==-MaxValue);
            DirectioN1GB(i)=-1;
        end
    end
    Lie=ceil(P/ICnum);
    Hang=mod(P,ICnum);
    if Hang==0
        Hang=ICnum;
    end
    MatchH=[MatchH,Hang];
    MatchL=[MatchL,Lie];
    SimGICsN1TemG(Hang,:)=0;
    SimGICsN1TemG(:,Lie)=0;
end

[a,b]=sort(MatchL);
Order1G=MatchH(b);


for i=1:sbnum
    %load GT IC and TC
    if i<10
        strzero='00';
    else if i>9&&i<100
            strzero='0';
        end
    end
    
    load (strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationNew\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_SIM.mat'));
    RealSouMat=SM;
    RealTCMat=TC;
    RealSouInMask=zeros(ICnum,VoxNum);
    h=1;
    for k=1:M*N*L
        if MaskVec(k)==1
            RealSouInMask(:,h)=RealSouMat(:,k);
            h=h+1;
        end
    end
    RealSouInMaskZ=[]; %z-score the value of GT IC in mask.
    for IC=1:ICnum
        RealSouInMaskZ(IC,:)=(RealSouInMask(IC,:)-mean(RealSouInMask(IC,:)))/std(RealSouInMask(IC,:));
    end
    RealTCMatZ=[];
    for tc=1:ICnum
        RealTCMatZ(:,tc)=(RealTCMat(:,tc)-mean(RealTCMat(:,tc)))/std(RealTCMat(:,tc));
    end
    
    %compute the independence between GT ICs
    for S=1:ICnum
        GTKurt(i,S)= kurtn(RealSouInMaskZ(S,:));
        GTNege(i,S)= nege(RealSouInMaskZ(S,:));
        for S1=1:ICnum
            [NMI,MI,MIxy,Entropyx,Entropyy,Entropyxy]=MIEtropy(RealSouInMaskZ(S,:),RealSouInMaskZ(S1,:),binsPara);
            GTMutuInfo(S,S1)=MI;
            GTNMutuInfo(S,S1)=NMI;
        end
    end
    
    GTMuIn=(sum(sum(triu(GTMutuInfo)))-sum(diag(triu(GTMutuInfo))))/((ICnum*ICnum-ICnum)/2);
    GTNMuIn=(sum(sum(triu(GTNMutuInfo)))-sum(diag(triu(GTNMutuInfo))))/((ICnum*ICnum-ICnum)/2);
    
    SumGTKurt(i)=sum(GTKurt(i,:),2);
    SumGTNege(i)=sum(GTNege(i,:),2);
    GTMI(i)=GTMuIn;
    GTNMI(i)=GTNMuIn;
    
    %%
    %get individual ICs/TCs from IVA, and then z score them
    IVAICMat=IVAICAllsubMat(:,:,i);
    IVATCMat=FmriMatMaskAllSub(:,:,i)*pinv(IVAICMat);
    
    IVAICMatZ=[];
    for icorder=1:size(IVAICMat,1)
        IVAICMatZ(icorder,:)=(IVAICMat(icorder,:)-mean(IVAICMat(icorder,:)))/std(IVAICMat(icorder,:));
    end
    IVATCMatZ=[];
    for tcorder=1:size(IVATCMat,2)
        IVATCMatZ(:,tcorder)=(IVATCMat(:,tcorder)-mean(IVATCMat(:,tcorder)))/std(IVATCMat(:,tcorder));
    end
    
    %change the order of IVA ICs/TCs to match GT source/TCs
    IVATCMatCO=zeros(timepoints,ICnum);
    IVAICMatCO=zeros(ICnum,VoxNum);
    for ICorder=1:ICnum
        IVAICMatCO(ICorder,:)=IVAICMat(Order1G(ICorder),:);
        IVATCMatCO(:,ICorder)= IVATCMat(:,Order1G(ICorder));
    end
    
    %change the order of z-scored IVA TC result
    IVATCMatCOZ=zeros(timepoints,ICnum);
    IVAICMatCOZ=zeros(ICnum,VoxNum);
    for ICorder=1:ICnum
        IVAICMatCOZ(ICorder,:)=IVAICMatZ(Order1G(ICorder),:);
        IVATCMatCOZ(:,ICorder)=IVATCMatZ(:,Order1G(ICorder));
    end
    
    
    %compute the accuracy of estimated ICs/TCs using correlation
    [IndiIC1RealSMSim,IndiIC1ReSm]=SMSim(IVAICMatCO,RealSouInMask);
    [IndiTC1RealTCSim,IndiTC1ReTc]=TCSim(IVATCMatCO,RealTCMat);
    
    [IndiIC1RealSMSimZ,IndiIC1ReSmZ]=SMSim(IVAICMatCOZ,RealSouInMaskZ);
    [IndiTC1RealTCSimZ,IndiTC1ReTcZ]=TCSim(IVATCMatCOZ,RealTCMatZ);
    
    SMS1(i,:)=IndiIC1ReSm';
    TCS1(i,:)=IndiTC1ReTc';
    MeanSMSG1(i)=mean(IndiIC1ReSm);
    MeanTCSG1(i)=mean(IndiTC1ReTc);
    
    
    %compute the independence between estimated ICs from IVA
    for S=1:ICnum
        IVAKurt(i,S)= kurtn(IVAICMatCOZ(S,:));
        IVANege(i,S)= nege(IVAICMatCOZ(S,:));
        for S1=1:ICnum
            [NMI,MI,MIxy,Entropyx,Entropyy,Entropyxy]=MIEtropy(IVAICMatCOZ(S,:),IVAICMatCOZ(S1,:),binsPara);
            IVAMutuInfo(S,S1)=MI;
            IVANMutuInfo(S,S1)=NMI;
        end
    end
    
    IVAMuIn=(sum(sum(triu(IVAMutuInfo)))-sum(diag(triu(IVAMutuInfo))))/((ICnum*ICnum-ICnum)/2);
    IVANMuIn=(sum(sum(triu(IVANMutuInfo)))-sum(diag(triu(IVANMutuInfo))))/((ICnum*ICnum-ICnum)/2);
    
    SumIVAKurt(i)=sum(IVAKurt(i,:),2);
    SumIVANege(i)=sum(IVANege(i,:),2);
    IVAMI(i)=IVAMuIn;
    IVANMI(i)=IVANMuIn;
    
    IVAICMatPlMask=zeros(size(IVAICMat,1),M*N*L);
    RealSouMatZ=zeros(size(IVAICMat,1),M*N*L);%z scored GT IC plus mask.
    h=1;
    for K=1:M*N*L
        if MaskVec(K)==0
            IVAICMatPlMask(:,K)=0;
            RealSouMatZ(:,K)=0;
        else
            IVAICMatPlMask(:,K)=IVAICMatZ(:,h);
            RealSouMatZ(:,K)=RealSouInMaskZ(:,h);
            h=h+1;
        end
    end
    
    %show the figure
    %if i==1||i==3||i==7;
    h00=figure;
    for k=1:IVASubPC1num
        subplot(IVASubPC1num,5,5*k-3);
        imshow(reshape(IVAICMatPlMask(Order1G(k),:),M,N),[]);
        tmp = sprintf('%.2f', IndiIC1ReSm(k));
        title(['\bf {IVA IC} ',int2str(k),' ',tmp,')'],'fontsize',8);
        
        
        subplot(IVASubPC1num,5,5*k-2);
        plot(IVATCMatZ(:,Order1G(k)));
        tmp = sprintf('%.2f', IndiTC1ReTc(k));
        title(['\bf {IVA TC} ',int2str(k),' (',tmp,')'],'fontsize',8);
        xlim([0 timepoints]);
        ylim([-4 4]);
        
        subplot(IVASubPC1num,5,5*k-1);
        imshow(reshape(RealSouMatZ(k,:),M,N),[]);
        title(['\bf {GT IC} ',int2str(k)],'fontSize',8);
        subplot(IVASubPC1num,5,5*k);
        plot(RealTCMatZ(:,k));
        title(['\bf {GT TC} ',int2str(k)],'fontSize',8);
        xlim([0 timepoints]);
        ylim([-4 4]);
    end
    %save individual ICs for later reliability evaluation
    IVAICALL((i*ICnum-(ICnum-1)):(ICnum*i),:)=IVAICMatCOZ;
    GTICALL((i*ICnum-(ICnum-1)):(ICnum*i),:)=RealSouInMaskZ;
    
    %save individual TCs for later reliability evaluation
    IVATCALL(:,(i*ICnum-(ICnum-1)):(ICnum*i))=IVATCMatCOZ;
    GTTCALL(:,(i*ICnum-(ICnum-1)):(ICnum*i))=RealTCMatZ;
end

MeanSMSG1DifSNR(:,difdata)=MeanSMSG1';
MeanTCSG1DifSNR(:,difdata)=MeanTCSG1';

IVAKurtDifSNR(:,difdata)=SumIVAKurt;
IVANegeDifSNR(:,difdata)=SumIVANege;
IVAMIDifSNR(:,difdata)=IVAMI;
IVANMIDifSNR(:,difdata)=IVANMI;

GTKurtDifSNR(:,difdata)=SumGTKurt;
GTNegeDifSNR(:,difdata)=SumGTNege;
GTMIDifSNR(:,difdata)=GTMI;
GTNMIDifSNR(:,difdata)=GTNMI;

%boxplot the results of spatial and temporal accuracy of all subjects

%boxplot spatial accuracy
h1=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(SMS1,1,['*'],1,1,'r',2,1,true,[1 4],1.3,0,'ks');
set(gcf,'color','white')
xmax=IVASubPC1num+0.5;
axis([0.5 xmax 0 1])
set(gca,'ygrid','on');
set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',16);
xlabel('ICs','Fontsize',20,'Fontweight','Bold','Fontsize',20);
ylabel('Spatial accuracy','Fontsize',20,'Fontweight','Bold','Fontsize',20);
title('IVA spatial accuracy','Fontsize',20,'Fontweight','Bold');
% hold on;
% for i=1:7
%     %X=[xaixs(i)+0.5,xaixs(i)+0.5];
%     X=[i+0.5,i+0.5];
%     Y=[0,1];
%     plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
% end

%boxplot temporal accuracy
h2=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(TCS1,1,['*'],1,1,'r',2,1,true,[1 4],1.3,0,'ks');
set(gcf,'color','white')
xmax=IVASubPC1num+0.5;
axis([0.5 xmax 0 1])
set(gca,'ygrid','on');
set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',16);
xlabel('ICs','Fontsize',20,'Fontweight','Bold','Fontsize',20);
ylabel('Temporal accuracy','Fontsize',20,'Fontweight','Bold','Fontsize',20);
title('IVA temporal accuracy','Fontsize',20,'Fontweight','Bold');
% hold on;
% for i=1:7
%     %X=[xaixs(i)+0.5,xaixs(i)+0.5];
%     X=[i+0.5,i+0.5];
%     Y=[0,1];
%     plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
% end
mkdir(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\IVA'));

cd(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\IVA'));
saveas(h1,strcat('IVASpaAcc.fig'));
saveas(h1,strcat('IVASpaAcc.png'));
saveas(h2,strcat('IVATemAcc.fig'));
saveas(h2,strcat('IVATemAcc.png'));

fprintf(strcat('Mean spatial accuracy of IVA method is'));
MeanSpaAccIVA=mean(MeanSMSG1)
fprintf(strcat('Mean temporal accuracy of IVA method is'));
MeanTemAccIVA=mean(MeanTCSG1)
save('MeanSpaAccIVA','MeanSpaAccIVA');
save('MeanTemAccIVA','MeanTemAccIVA');
xlswrite('MeanSpaAccIVA',MeanSpaAccIVA);
xlswrite('MeanTemAccIVA',MeanTemAccIVA);
save('Order1G','Order1G');

cd('E:\aMRN\aProject\CompareIVAGIGICA\SimulationCode');

%%
%plot the independence of ICs from IVA and GT
h3=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
bar([IVANMI',GTNMI'],'group');
set(gcf,'color','white')

GTICALLs=[];
for k=1:sbnum
    for l=1:ICnum
        GTICALLs(sbnum*(l-1)+k,:)=GTICALL(ICnum*(k-1)+l,:);
    end
end
GTSimMatALLs=[];
for j=1:sbnum*ICnum
    for k=1:sbnum*ICnum
        GTSimMatALLs(j,k)=abs(corr(GTICALLs(j,:)',GTICALLs(k,:)'));
    end
end
GTSimMatALLsG=GTSimMatALLs;
for ICorder=1:ICnum
    for i=1+((ICorder-1)*sbnum):sbnum+((ICorder-1)*sbnum)
        for j=sbnum+1+((ICorder-1)*sbnum):sbnum*ICnum
            GTSimMatALLsG(i,j)=NaN;
        end
    end
end

figure;
[X,Y]=meshgrid(1:1:sbnum*ICnum, 1:1:sbnum*ICnum);
h=pcolor(X,Y,GTSimMatALLsG);
caxis([0,1]);
%colorbar('horiz');
colormap(jet(64));
grid off;
axis ij
axis square
set(h,'LineStyle','none')
set(gca,'FontName','Times New Roman','Fontsize',26,'Fontweight','Bold')
title(['\bf {GT}' ],'Fontsize',26,'Fontweight','Bold');

%axis([0.5 124.5 0.5 124.5])
set(gca,'XTick',[sbnum/2:sbnum:sbnum*ICnum],'Fontweight','Bold','Fontsize',20);
set(gca,'YTick',[sbnum/2:sbnum:sbnum*ICnum],'Fontweight','Bold','Fontsize',20);
set(gca,'box','off')
set(gcf,'paperunits','centimeters');
set(gcf,'papersize',[3 3]);
set(gca,'XTickLabel',{'1','2','3','4','5','6','7','8'},'Fontweight','Bold','Fontsize',26);
set(gca,'YTickLabel',{'1','2','3','4','5','6','7','8'},'Fontweight','Bold','Fontsize',26);

mkdir(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\Reliability'));
cd(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\Reliability'));
saveas(h,strcat('GTCorrMatrix.fig'));
print('-dtiff','-r500',strcat('GTCorrMatrix.tif'));

GTMat=[];
GTVecSubSimAllIC=[];
%boxplot the similarity
for k=1:ICnum
    GTSubSimMat=GTSimMatALLs(sbnum*(k-1)+1:sbnum*k,sbnum*(k-1)+1:sbnum*k);
    GTTriSub=triu(GTSubSimMat,1);
    GTVecSubSim=reshape(GTTriSub,1,sbnum*sbnum);
    % MeanSimIC2(k)=mean(VecSubSim2);
    % StdSimIC2(k)=std(VecSubSim2);
    GTMat(:,k)=GTVecSubSim';
    GTVecSubSimAllIC=[GTVecSubSimAllIC,GTVecSubSim];
end
GTVecSubSimAllICDifSNR(:,difdata)=GTVecSubSimAllIC';

for i=1:size(GTVecSubSimAllICDifSNR,1)
    for j=1:size(GTVecSubSimAllICDifSNR,2)
        if GTVecSubSimAllICDifSNR(i,j)==0
            GTVecSubSimAllICDifSNR(i,j)=NaN;
        end
        if GTVecSubSimAllICDifSNR(i,j)==1
            GTVecSubSimAllICDifSNR(i,j)=NaN;
        end
    end
end

GTMatG=GTMat;
GTMatGG=GTMat;
for i=1:sbnum*sbnum
    for j=1:ICnum
        if GTMat(i,j)==1
            GTMatG(i,j)=NaN;
            GTMatGG(i,j)=0;
        end
        if GTMat(i,j)==0
            GTMatG(i,j)=NaN;
        end;
    end
end
GTEachICMeanCorr=zeros(1,ICnum);
for j=1:ICnum
    GTEachICMeanCorr(1,j)=sum(GTMatGG(:,j))/size(find(GTMatGG(:,j)~=0),1);
end


cd('E:\aMRN\aProject\CompareIVAGIGICA\SimulationCode');
hp=figure;
%set (gcf,'Position',[0,0,400,1200], 'color','w')
set (gcf,'Position',[0,0,1200,400], 'color','w')
b_1=boxplotCsub(GTMatG,1,['*'],1,1,'b',2,2,true,[1 1],1.3,0,'ks');
Hla=cell(1,ICnum);
for i=1:size(Hla,2)
    Hla{i}=i;
end
set(gcf,'color','white')
a=ICnum+0.5;
axis([0.5 a 0 1])
set(gca,'ygrid','on');
set(gca,'YTick',[0:0.2:2],'Fontweight','Bold','Fontsize',20);
xlabel('IC ID','Fontweight','Bold','Fontsize',20);
ylabel('Absolute value of correlation','Fontweight','Bold','Fontsize',20);
set(gca,'XTickLabel',Hla,'Fontweight','Bold','Fontsize',20);%,
title('GT','Fontsize',20,'Fontweight','Bold');

hold on;
for i=1:ICnum-1
    %X=[xaixs(i)+0.5,xaixs(i)+0.5];
    X=[i+0.5,i+0.5];
    Y=[0,1];
    plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
end
% az = -90;
% el = 90;
% view(az, el);

mkdir(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\Reliability'));
cd(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\Reliability'));
saveas(hp,'GTEachICReliability.png');
saveas(hp,'GTEachICReliability.fig');

addpath('/export/mialab/users/ydu/Tools/Simple_tSNE');
a=1:ICnum;
Label=[];
for i=1:sbnum
    Label=[Label,a];
end
figure;
GTAllFea2D = tsne(GTICALL, Label);
hP=gcf;
mkdir(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\Reliability'));
cd(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\Reliability'));

saveas(hP,'GTProjectionOfAllsubAllIC.tif');
saveas(hP,'GTProjectionOfAllsubAllIC.fig');
save('GTAllFea2D','GTAllFea2D');
save('GTICALL','GTICALL');

GTAllFea2DG=zeros(size(GTAllFea2D));
for k=1:sbnum
    for l=1:ICnum
        GTAllFea2DG(sbnum*(l-1)+k,:)=GTAllFea2D(ICnum*(k-1)+l,:);
    end
end
hPSpaG=figure;
for i=1:size(GTAllFea2DG,1)
    if i<sbnum+1
        scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'r','filled');
        hold on;
    else if i<sbnum*2+1
            scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'b','filled');
            hold on;
        else if i<sbnum*3+1
                scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'c','filled');
                hold on;
            else if i<sbnum*4+1
                    scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'g','filled');
                    hold on;
                else if i<sbnum*5+1
                        scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'k','filled');
                        hold on;
                    else if i<sbnum*6+1
                            scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'y','filled');
                            hold on;
                        else if i<sbnum*7+1
                                scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'m','filled');
                                hold on;
                            else if i<sbnum*8+1
                                    scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,[0.5 0.3 1],'filled');
                                    hold on;
                                end
                            end
                        end
                    end
                end
            end
        end
    end
end
title('t-SNE projection');
mkdir(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\Reliability'));
cd(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\Reliability'));
saveas(hPSpaG,'GTProjectionOfAllsubAllICOwn.tif');
saveas(hPSpaG,'GTProjectionOfAllsubAllICOwn.fig');

close all;

IVAICALLs=[];
for k=1:sbnum
    for l=1:ICnum
        IVAICALLs(sbnum*(l-1)+k,:)=IVAICALL(ICnum*(k-1)+l,:);
    end
end
IVASimMatALLs=[];
for j=1:sbnum*ICnum
    for k=1:sbnum*ICnum
        IVASimMatALLs(j,k)=abs(corr(IVAICALLs(j,:)',IVAICALLs(k,:)'));
    end
end
IVASimMatALLsG=IVASimMatALLs;
for ICorder=1:ICnum
    for i=1+((ICorder-1)*sbnum):sbnum+((ICorder-1)*sbnum)
        for j=sbnum+1+((ICorder-1)*sbnum):sbnum*ICnum
            IVASimMatALLsG(i,j)=NaN;
        end
    end
end

figure;
[X,Y]=meshgrid(1:1:sbnum*ICnum, 1:1:sbnum*ICnum);
h=pcolor(X,Y,IVASimMatALLsG);
caxis([0,1]);
%colorbar('horiz');
colormap(jet(64));
grid off;
axis ij
axis square
set(h,'LineStyle','none')
set(gca,'FontName','Times New Roman','Fontsize',26,'Fontweight','Bold')
title(['\bf {IVA }' ],'Fontsize',26,'Fontweight','Bold');

%axis([0.5 124.5 0.5 124.5])
set(gca,'XTick',[sbnum/2:sbnum:sbnum*ICnum],'Fontweight','Bold','Fontsize',20);
set(gca,'YTick',[sbnum/2:sbnum:sbnum*ICnum],'Fontweight','Bold','Fontsize',20);
set(gca,'box','off')
set(gcf,'paperunits','centimeters');
set(gcf,'papersize',[3 3]);
set(gca,'XTickLabel',{'1','2','3','4','5','6','7','8'},'Fontweight','Bold','Fontsize',26);
set(gca,'YTickLabel',{'1','2','3','4','5','6','7','8'},'Fontweight','Bold','Fontsize',26);

mkdir(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\Reliability'));
cd(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\Reliability'));
saveas(h,strcat('IVACorrMatrix.fig'));
print('-dtiff','-r500',strcat('IVACorrMatrix.tif'));

IVAMat=[];
IVAVecSubSimAllIC=[];
%boxplot the similarity
for k=1:ICnum
    IVASubSimMat=IVASimMatALLs(sbnum*(k-1)+1:sbnum*k,sbnum*(k-1)+1:sbnum*k);
    IVATriSub=triu(IVASubSimMat,1);
    IVAVecSubSim=reshape(IVATriSub,1,sbnum*sbnum);
    % MeanSimIC2(k)=mean(VecSubSim2);
    % StdSimIC2(k)=std(VecSubSim2);
    IVAMat(:,k)=IVAVecSubSim';
    IVAVecSubSimAllIC=[IVAVecSubSimAllIC,IVAVecSubSim];
end
IVAVecSubSimAllICDifSNR(:,difdata)=IVAVecSubSimAllIC';

for i=1:size(IVAVecSubSimAllICDifSNR,1)
    for j=1:size(IVAVecSubSimAllICDifSNR,2)
        if IVAVecSubSimAllICDifSNR(i,j)==0
            IVAVecSubSimAllICDifSNR(i,j)=NaN;
        end
        if IVAVecSubSimAllICDifSNR(i,j)==1
            IVAVecSubSimAllICDifSNR(i,j)=NaN;
        end
    end
end

IVAMatG=IVAMat;
IVAMatGG=IVAMat;
for i=1:sbnum*sbnum
    for j=1:ICnum
        if IVAMat(i,j)==1
            IVAMatG(i,j)=NaN;
            IVAMatGG(i,j)=0;
        end
        if IVAMat(i,j)==0
            IVAMatG(i,j)=NaN;
        end;
    end
end
IVAEachICMeanCorr=zeros(1,ICnum);
for j=1:ICnum
    IVAEachICMeanCorr(1,j)=sum(IVAMatGG(:,j))/size(find(IVAMatGG(:,j)~=0),1);
end


cd('E:\aMRN\aProject\CompareIVAGIGICA\SimulationCode');
hp=figure;
%set (gcf,'Position',[0,0,400,1200], 'color','w')
set (gcf,'Position',[0,0,1200,400], 'color','w')
b_1=boxplotCsub(IVAMatG,1,['*'],1,1,'b',2,2,true,[1 1],1.3,0,'ks');
Hla=cell(1,ICnum);
for i=1:size(Hla,2)
    Hla{i}=i;
end
set(gcf,'color','white')
a=ICnum+0.5;
axis([0.5 a 0 1])
set(gca,'ygrid','on');
set(gca,'YTick',[0:0.2:2],'Fontweight','Bold','Fontsize',20);
xlabel('IC ID','Fontweight','Bold','Fontsize',20);
ylabel('Absolute value of correlation','Fontweight','Bold','Fontsize',20);
set(gca,'XTickLabel',Hla,'Fontweight','Bold','Fontsize',20);%,
title('IVA-ICA','Fontsize',20,'Fontweight','Bold');

hold on;
for i=1:ICnum-1
    %X=[xaixs(i)+0.5,xaixs(i)+0.5];
    X=[i+0.5,i+0.5];
    Y=[0,1];
    plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
end
% az = -90;
% el = 90;
% view(az, el);

mkdir(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\Reliability'));
cd(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\Reliability'));
saveas(hp,'IVAEachICReliability.png');
saveas(hp,'IVAEachICReliability.fig');

addpath('/export/mialab/users/ydu/Tools/Simple_tSNE');
a=1:ICnum;
Label=[];
for i=1:sbnum
    Label=[Label,a];
end
figure;
IVAAllFea2D = tsne(IVAICALL, Label);
hP=gcf;
mkdir(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\Reliability'));
cd(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\Reliability'));

saveas(hP,'IVAProjectionOfAllsubAllIC.tif');
saveas(hP,'IVAProjectionOfAllsubAllIC.fig');
save('IVAAllFea2D','IVAAllFea2D');
save('IVAICALL','IVAICALL');

IVAAllFea2DG=zeros(size(IVAAllFea2D));
for k=1:sbnum
    for l=1:ICnum
        IVAAllFea2DG(sbnum*(l-1)+k,:)=IVAAllFea2D(ICnum*(k-1)+l,:);
    end
end
hPSpaG=figure;
for i=1:size(IVAAllFea2DG,1)
    if i<sbnum+1
        scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'r','filled');
        hold on;
    else if i<sbnum*2+1
            scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'b','filled');
            hold on;
        else if i<sbnum*3+1
                scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'c','filled');
                hold on;
            else if i<sbnum*4+1
                    scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'g','filled');
                    hold on;
                else if i<sbnum*5+1
                        scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'k','filled');
                        hold on;
                    else if i<sbnum*6+1
                            scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'y','filled');
                            hold on;
                        else if i<sbnum*7+1
                                scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'m','filled');
                                hold on;
                            else if i<sbnum*8+1
                                    scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,[0.5 0.3 1],'filled');
                                    hold on;
                                end
                            end
                        end
                    end
                end
            end
        end
    end
end
title('t-SNE projection');

mkdir(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\Reliability'));
cd(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\Reliability'));

saveas(hPSpaG,'IVAProjectionOfAllsubAllICOwn.tif');
saveas(hPSpaG,'IVAProjectionOfAllsubAllICOwn.fig');


GTReliaDifSNR(:,difdata)=mean(GTEachICMeanCorr);
IVAReliaDifSNR(:,difdata)=mean(IVAEachICMeanCorr);
close all;
cd('E:\aMRN\aProject\CompareIVAGIGICA\SimulationCode');
close all;
%%
%GIG-ICA

%1.set some parameters
GIGSubPCnum=27;
GIGGroupPCnum=27;

%2.read data, and implement subject PCA.
for i=1:sbnum
    if i<10
        strzero='00';
    else if i>9&&i<100
            strzero='0';
        end
    end
    
    v=spm_vol(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationNew\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_DATA.nii'));
    dat=spm_read_vols(v);
    for j=1:timepoints
        FmriVec=reshape(dat(:,:,:,j),1,[]);
        FmriMatr(j,:) = FmriVec;
    end
    
    FmriMatMask=zeros(timepoints,VoxNum);
    h=1;
    for k=1:M*N*L
        if MaskVec(k)==1
            FmriMatMask(:,h)=FmriMatr(:,k);
            h=h+1;
        end
    end
    
    IndiPCAData= GIG_CalPCA( FmriMatMask',GIGSubPCnum); %subject level PCA
    SubPCAOut(:,GIGSubPCnum*(i-1)+1:GIGSubPCnum*i)=IndiPCAData;%
end

GroupPCAOut = GIG_CalPCA(SubPCAOut,GIGGroupPCnum); %

disp('Start group level ICA for geting group components......................................');
%group ICA
algorithmName='Infomax';
%use the ICASSO
%[A, GICs] = useICASSO(GroupPCAOut', algorithmName);
[W2, A2, GICs2] = GIG_IcaAlgorithm(algorithmName, GroupPCAOut');
clear SubPCAOut;
clear GroupPCAOut;
GICsN2=zeros(GIGGroupPCnum,VoxNum);
%normalize the GICs for output or for the consequent average
GICsC2=GICs2-repmat(mean(GICs2,2),[1,VoxNum]);
for i=1:size(GICs2,1)
    GICsN2(i,:)=GICsC2(i,:)/std(GICsC2(i,:));
end

%evaluate the results
%match GIG-ICA and real sources
SimGICsN2Tem=corr(GICsN2',TemICInMask');%
%following is another matching method
MatchV=[];
MatchH=[];
MatchL=[];
Direction2GB=[];
SimGICsN2TemG=SimGICsN2Tem;
for i=1:ICnum
    MaxValue=max(max(abs(SimGICsN2TemG)));
    MatchV=[MatchV,MaxValue];
    if size(find(SimGICsN2TemG==MaxValue),1)
        P=find(SimGICsN2TemG==MaxValue);
        Direction2GB(i)=1;
    else if size(find(SimGICsN2TemG==-MaxValue),1)
            P=find(SimGICsN2TemG==-MaxValue);
            Direction2GB(i)=-1;
        end
    end
    
    Lie=ceil(P/ICnum);
    Hang=mod(P,ICnum);
    if Hang==0
        Hang=ICnum;
    end
    MatchH=[MatchH,Hang];
    MatchL=[MatchL,Lie];
    SimGICsN2TemG(Hang,:)=0;
    SimGICsN2TemG(:,Lie)=0;
end

[a,b]=sort(MatchL);
Order2G=MatchH(b);

for i=1:sbnum
    if i<10
        strzero='00';
    else if i>9&&i<100
            strzero='0';
        end
    end
    v=spm_vol(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationNew\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_DATA.nii'));
    dat=spm_read_vols(v);
    for j=1:timepoints
        FmriVec=reshape(dat(:,:,:,j),1,[]);
        FmriMatr(j,:) = FmriVec;
    end
    
    FmriMatMask=zeros(timepoints,VoxNum);
    h=1;
    for k=1:M*N*L
        if MaskVec(k)==1
            FmriMatMask(:,h)=FmriMatr(:,k);
            h=h+1;
        end
    end
    
    nemda=0;
    a=0.5;
    [GIGICMat,UnmixMat,GIGTCMatB,ObFunc,C,IterMat]=GIGICAArReInCISGamaArmiTGWRSF(FmriMatMask,GIGGroupPCnum,GICsN2,a,nemda);
    GIGTCMat=FmriMatMask*pinv(GIGICMat);
    %GIGTCMat=GIGTCMatB;
    
    %         GIGICMatPlMask=zeros(size(GIGICMat,1),M*N*L);
    %         h=1;
    %         for K=1:M*N*L
    %             if MaskVec(K)==0
    %                 GIGICMatPlMask(:,K)=0;
    %             else
    %                 GIGICMatPlMask(:,K)=GIGICMat(:,h);
    %                 h=h+1;
    %             end
    %         end
    %         h00=figure;
    %         for k=1:8
    %             subplot(8,1,k);
    %             imshow(reshape(GIGICMatPlMask(k,:),M,N),[]);
    %             %title(['\bf {GIG-ICA IC} ',int2str(k),'
    %             %(',num2str(vpa(IndiIC2ReSm(k)),4),')'],'fontsize',8);
    %             %tmp = sprintf('%.2f', IndiIC2ReSm(k));
    %             %title(['\bf {GIG-ICA IC} ',int2str(k),' (',tmp,')'],'fontsize',8);
    %         end
    
    
    %change the order of GIG result
    GIGTCMatCO=zeros(timepoints,size(GICsN2,1));
    GIGICMatCO=zeros(size(GICsN2,1),VoxNum);
    for ICorder=1:size(GICsN2,1)
        GIGICMatCO(ICorder,:)=GIGICMat(Order2G(ICorder),:);
        GIGTCMatCO(:,ICorder)= GIGTCMat(:,Order2G(ICorder));
    end
    GIGTCMatZ=[];
    for tc=1:size(GIGTCMat,2)
        GIGTCMatZ(:,tc)=(GIGTCMat(:,tc)-mean(GIGTCMat(:,tc)))/std(GIGTCMat(:,tc));
    end
    %change the order of z-scored GIG TC result
    GIGTCMatCOZ=zeros(timepoints,size(GICsN2,1));
    for ICorder=1:size(GICsN2,1)
        GIGTCMatCOZ(:,ICorder)=GIGTCMatZ(:,Order2G(ICorder));
    end
    %%
    %load GT IC and TC
    if i<10
        strzero='00';
    else if i>9&&i<100
            strzero='0';
        end
    end
    
    load (strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationNew\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_SIM.mat'));
    RealSouMat=SM;
    RealTCMat=TC;
    RealSouInMask=zeros(ICnum,VoxNum);
    h=1;
    for k=1:M*N*L
        if MaskVec(k)==1
            RealSouInMask(:,h)=RealSouMat(:,k);
            h=h+1;
        end
    end
    RealSouInMaskZ=[]; %z-score the value of GT IC in mask.
    for IC=1:ICnum
        RealSouInMaskZ(IC,:)=(RealSouInMask(IC,:)-mean(RealSouInMask(IC,:)))/std(RealSouInMask(IC,:));
    end
    RealTCMatZ=[];
    for tc=1:ICnum
        RealTCMatZ(:,tc)=(RealTCMat(:,tc)-mean(RealTCMat(:,tc)))/std(RealTCMat(:,tc));
    end
    
    %%
    [IndiIC2RealSMSim,IndiIC2ReSm]=SMSim(GIGICMatCO,RealSouInMask);
    [IndiTC2RealTCSim,IndiTC2ReTc]=TCSim(GIGTCMatCO,RealTCMat);
    
    [IndiIC2RealSMSimZ,IndiIC2ReSmZ]=SMSim(GIGICMatCO,RealSouInMaskZ);
    [IndiTC2RealTCSimZ,IndiTC2ReTcZ]=TCSim(GIGTCMatCOZ,RealTCMatZ);
    
    SMS2(i,:)=IndiIC2ReSm';
    TCS2(i,:)=IndiTC2ReTc';
    MeanSMSG2(i)=mean(IndiIC2ReSm);
    MeanTCSG2(i)=mean(IndiTC2ReTc);
    
    binsPara=3;
    %compute the independence between estimated ICs from IVA
    for S=1:ICnum
        GIGKurt(i,S)= kurtn(GIGICMatCO(S,:));
        GIGNege(i,S)= nege(GIGICMatCO(S,:));
        for S1=1:ICnum
            [NMI,MI,MIxy,Entropyx,Entropyy,Entropyxy]=MIEtropy(GIGICMatCO(S,:),GIGICMatCO(S1,:),binsPara);
            GIGMutuInfo(S,S1)=MI;
            GIGNMutuInfo(S,S1)=NMI;
        end
    end
    
    GIGMuIn=(sum(sum(triu(GIGMutuInfo)))-sum(diag(triu(GIGMutuInfo))))/((ICnum*ICnum-ICnum)/2);
    GIGNMuIn=(sum(sum(triu(GIGNMutuInfo)))-sum(diag(triu(GIGNMutuInfo))))/((ICnum*ICnum-ICnum)/2);
    
    SumGIGKurt(i)=sum(GIGKurt(i,:),2);
    SumGIGNege(i)=sum(GIGNege(i,:),2);
    GIGMI(i)=GIGMuIn;
    GIGNMI(i)=GIGNMuIn;
    
    GIGICMatPlMask=zeros(size(GIGICMat,1),M*N*L);
    RealSouMatZ=zeros(size(GIGICMat,1),M*N*L);%z scored GT IC plus mask.
    h=1;
    for K=1:M*N*L
        if MaskVec(K)==0
            GIGICMatPlMask(:,K)=0;
            RealSouMatZ(:,K)=0;
        else
            GIGICMatPlMask(:,K)=GIGICMat(:,h);
            RealSouMatZ(:,K)=RealSouInMaskZ(:,h);
            h=h+1;
        end
    end
    
    
    %if i==1||i==3||i==7;
    h00=figure;
    for k=1:size(GICsN2,1)
        subplot(size(GICsN2,1),5,5*k-3);
        imshow(reshape(GIGICMatPlMask(Order2G(k),:),M,N),[]);
        tmp = sprintf('%.2f', IndiIC2ReSm(k));
        title(['\bf {GIG-ICA IC} ',int2str(k),' (',tmp,')'],'fontsize',8);
        
        
        subplot(size(GICsN2,1),5,5*k-2);
        plot(GIGTCMatZ(:,Order2G(k)));
        tmp = sprintf('%.2f', IndiTC2ReTc(k));
        title(['\bf {GIG-ICA TC} ',int2str(k),' (',tmp,')'],'fontsize',8);
        xlim([0 timepoints]);
        ylim([-4 4]);
        
        subplot(size(GICsN2,1),5,5*k-1);
        imshow(reshape(RealSouMatZ(k,:),M,N),[]);
        title(['\bf {GT IC} ',int2str(k)],'fontSize',8);
        subplot(size(GICsN2,1),5,5*k);
        plot(RealTCMatZ(:,k));
        title(['\bf {GT TC} ',int2str(k)],'fontSize',8);
        xlim([0 timepoints]);
        ylim([-4 4]);
        
        
    end
    %%
    %save individual ICs for later reliability evaluation
    GIGICALL((i*ICnum-(ICnum-1)):(ICnum*i),:)=GIGICMatCO;
    GIGTCALL(:,(i*ICnum-(ICnum-1)):(ICnum*i))=GIGTCMatCOZ;
end

MeanSMSG2DifSNR(:,difdata)=MeanSMSG2';
MeanTCSG2DifSNR(:,difdata)=MeanTCSG2';

GIGKurtDifSNR(:,difdata)=SumGIGKurt;
GIGNegeDifSNR(:,difdata)=SumGIGNege;
GIGMIDifSNR(:,difdata)=GIGMI;
GIGNMIDifSNR(:,difdata)=GIGNMI;


set(gcf,'color','white')
h5=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(SMS2,1,['*'],1,1,'r',2,1,true,[1 4],1.3,0,'ks');
set(gcf,'color','white')
yrange=size(GICsN2,1)+0.5;
axis([0.5 yrange 0 1])
set(gca,'ygrid','on');
set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',16);
xlabel('ICs','Fontsize',20,'Fontweight','Bold','Fontsize',20);
ylabel('Spatial accuracy','Fontsize',20,'Fontweight','Bold','Fontsize',20);
title('GIG-ICA spatial accuracy','Fontsize',20,'Fontweight','Bold');
% hold on;
% for i=1:7ti
%     %X=[xaixs(i)+0.5,xaixs(i)+0.5];
%     X=[i+0.5,i+0.5];
%     Y=[0,1];
%     plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
% end


%boxplot temporal accuracy
h6=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(TCS2,1,['*'],1,1,'r',2,1,true,[1 4],1.3,0,'ks');
set(gcf,'color','white')
axis([0.5 yrange 0 1])
set(gca,'ygrid','on');
set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',16);
xlabel('ICs','Fontsize',20,'Fontweight','Bold','Fontsize',20);
ylabel('Temporal accuracy','Fontsize',20,'Fontweight','Bold','Fontsize',20);
title('GIG-ICA temporal accuracy','Fontsize',20,'Fontweight','Bold');
% hold on;
% for i=1:7
%     %X=[xaixs(i)+0.5,xaixs(i)+0.5];
%     X=[i+0.5,i+0.5];
%     Y=[0,1];
%     plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
% end


%plot the independence of ICs from IVA and GT
h3=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=bar([GIGNMI',GTNMI'],'group');


fprintf(strcat('Mean spatial accuracy of GIG method is'));
MeanSpaAccGIG=mean(MeanSMSG2)
fprintf(strcat('Mean temporal accuracy of GIG method is'));
MeanTemAccGIG=mean(MeanTCSG2)
mkdir(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\GIG'));

cd(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\GIG'));
saveas(h5,strcat('GIGSpaAcc.fig'));
saveas(h5,strcat('GIGSpaAcc.png'));
saveas(h6,strcat('GIGTemAcc.fig'));
saveas(h6,strcat('GIGTemAcc.png'));
save('MeanSpaAccGIG','MeanSpaAccGIG');
save('MeanTemAccGIG','MeanTemAccGIG');
xlswrite('MeanSpaAccGIG',MeanSpaAccGIG);
xlswrite('MeanTemAccGIG',MeanTemAccGIG);
save('Order2G','Order2G');

h7=figure;
set(gcf,'Position',[100,100,600,500], 'color','w')
bar([GTNMI',IVANMI',GIGNMI',],'group');

h8=figure;
set(gcf,'Position',[100,100,600,500], 'color','w')
bar([SumGTKurt', SumIVAKurt', SumGIGKurt',],'group');

h9=figure;
set(gcf,'Position',[100,100,600,500], 'color','w')
bar([SumGTNege', SumIVANege', SumGIGNege',],'group');

h10=figure;
set(gcf,'Position',[100,100,600,500], 'color','w')
bar([GTMI',IVAMI',GIGMI',],'group');

mkdir(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\Independence'));
cd(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\Independence'));
saveas(h7,strcat('NMI.fig'));
saveas(h7,strcat('NMI.png'));
saveas(h8,strcat('Kurt.fig'));
saveas(h8,strcat('Kurt.png'));
saveas(h9,strcat('Nege.fig'));
saveas(h9,strcat('Nege.png'));
saveas(h10,strcat('MI.fig'));
saveas(h10,strcat('MI.png'));


GIGICALLs=[];
for k=1:sbnum
    for l=1:ICnum
        GIGICALLs(sbnum*(l-1)+k,:)=GIGICALL(ICnum*(k-1)+l,:);
    end
end
GIGSimMatALLs=[];
for j=1:sbnum*ICnum
    for k=1:sbnum*ICnum
        GIGSimMatALLs(j,k)=abs(corr(GIGICALLs(j,:)',GIGICALLs(k,:)'));
    end
end
GIGSimMatALLsG=GIGSimMatALLs;
for ICorder=1:ICnum
    for i=1+((ICorder-1)*sbnum):sbnum+((ICorder-1)*sbnum)
        for j=sbnum+1+((ICorder-1)*sbnum):sbnum*ICnum
            GIGSimMatALLsG(i,j)=NaN;
        end
    end
end

figure;
[X,Y]=meshgrid(1:1:sbnum*ICnum, 1:1:sbnum*ICnum);
h=pcolor(X,Y,GIGSimMatALLsG);
caxis([0,1]);
%colorbar('horiz');
colormap(jet(64));
grid off;
axis ij
axis square
set(h,'LineStyle','none')
set(gca,'FontName','Times New Roman','Fontsize',26,'Fontweight','Bold')
title(['\bf {GIG-ICA }' ],'Fontsize',26,'Fontweight','Bold');

%axis([0.5 124.5 0.5 124.5])
set(gca,'XTick',[sbnum/2:sbnum:sbnum*ICnum],'Fontweight','Bold','Fontsize',20);
set(gca,'YTick',[sbnum/2:sbnum:sbnum*ICnum],'Fontweight','Bold','Fontsize',20);
set(gca,'box','off')
set(gcf,'paperunits','centimeters');
set(gcf,'papersize',[3 3]);
set(gca,'XTickLabel',{'1','2','3','4','5','6','7','8'},'Fontweight','Bold','Fontsize',26);
set(gca,'YTickLabel',{'1','2','3','4','5','6','7','8'},'Fontweight','Bold','Fontsize',26);

mkdir(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\Reliability'));
cd(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\Reliability'));
saveas(h,strcat('GIGCorrMatrix.fig'));
print('-dtiff','-r500',strcat('GIGCorrMatrix.tif'));

GIGMat=[];
GIGVecSubSimAllIC=[];
%boxplot the similarity
for k=1:ICnum
    GIGSubSimMat=GIGSimMatALLs(sbnum*(k-1)+1:sbnum*k,sbnum*(k-1)+1:sbnum*k);
    GIGTriSub=triu(GIGSubSimMat,1);
    GIGVecSubSim=reshape(GIGTriSub,1,sbnum*sbnum);
    % MeanSimIC2(k)=mean(VecSubSim2);
    % StdSimIC2(k)=std(VecSubSim2);
    GIGMat(:,k)=GIGVecSubSim';
    GIGVecSubSimAllIC=[GIGVecSubSimAllIC,GIGVecSubSim];
end
GIGVecSubSimAllICDifSNR(:,difdata)=GIGVecSubSimAllIC';

for i=1:size(GIGVecSubSimAllICDifSNR,1)
    for j=1:size(GIGVecSubSimAllICDifSNR,2)
        if GIGVecSubSimAllICDifSNR(i,j)==0
            GIGVecSubSimAllICDifSNR(i,j)=NaN;
        end
        if GIGVecSubSimAllICDifSNR(i,j)==1
            GIGVecSubSimAllICDifSNR(i,j)=NaN;
        end
    end
end
GIGMatG=GIGMat;
GIGMatGG=GIGMat;
for i=1:sbnum*sbnum
    for j=1:ICnum
        if GIGMat(i,j)==1
            GIGMatG(i,j)=NaN;
            GIGMatGG(i,j)=0;
        end
        if GIGMat(i,j)==0
            GIGMatG(i,j)=NaN;
        end;
    end
end
GIGEachICMeanCorr=zeros(1,ICnum);
for j=1:ICnum
    GIGEachICMeanCorr(1,j)=sum(GIGMatGG(:,j))/size(find(GIGMatGG(:,j)~=0),1);
end

cd('E:\aMRN\aProject\CompareIVAGIGICA\SimulationCode');
hp=figure;
%set (gcf,'Position',[0,0,400,1200], 'color','w')
set (gcf,'Position',[0,0,1200,400], 'color','w')
b_1=boxplotCsub(GIGMatG,1,['*'],1,1,'b',2,2,true,[1 1],1.3,0,'ks');
Hla=cell(1,ICnum);
for i=1:size(Hla,2)
    Hla{i}=i;
end
set(gcf,'color','white')
a=ICnum+0.5;
axis([0.5 a 0 1])
set(gca,'ygrid','on');
set(gca,'YTick',[0:0.2:2],'Fontweight','Bold','Fontsize',20);
xlabel('IC ID','Fontweight','Bold','Fontsize',20);
ylabel('Absolute value of correlation','Fontweight','Bold','Fontsize',20);
set(gca,'XTickLabel',Hla,'Fontweight','Bold','Fontsize',20);%,
title('GIG-ICA','Fontsize',20,'Fontweight','Bold');

hold on;
for i=1:ICnum-1
    %X=[xaixs(i)+0.5,xaixs(i)+0.5];
    X=[i+0.5,i+0.5];
    Y=[0,1];
    plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
end
% az = -90;
% el = 90;
% view(az, el);
GIGReliaDifSNR(:,difdata)=mean(GIGEachICMeanCorr);
mkdir(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\Reliability'));
cd(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\Reliability'));
saveas(hp,'GIGEachICReliability.png');
saveas(hp,'GIGEachICReliability.fig');

addpath('/export/mialab/users/ydu/Tools/Simple_tSNE');
a=1:ICnum;
Label=[];
for i=1:sbnum
    Label=[Label,a];
end
figure;
GIGAllFea2D = tsne(GIGICALL, Label);
hP=gcf;
mkdir(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\Reliability'));
cd(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\Reliability'));

saveas(hP,'GIGProjectionOfAllsubAllIC.tif');
saveas(hP,'GIGProjectionOfAllsubAllIC.fig');
save('GIGAllFea2D','GIGAllFea2D');
save('GIGICALL','GIGICALL');

GIGAllFea2DG=zeros(size(GIGAllFea2D));
for k=1:sbnum
    for l=1:ICnum
        GIGAllFea2DG(sbnum*(l-1)+k,:)=GIGAllFea2D(ICnum*(k-1)+l,:);
    end
end
hPSpaG=figure;
for i=1:size(GIGAllFea2DG,1)
    if i<sbnum+1
        scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'r','filled');
        hold on;
    else if i<sbnum*2+1
            scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'b','filled');
            hold on;
        else if i<sbnum*3+1
                scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'c','filled');
                hold on;
            else if i<sbnum*4+1
                    scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'g','filled');
                    hold on;
                else if i<sbnum*5+1
                        scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'k','filled');
                        hold on;
                    else if i<sbnum*6+1
                            scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'y','filled');
                            hold on;
                        else if i<sbnum*7+1
                                scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'m','filled');
                                hold on;
                            else if i<sbnum*8+1
                                    scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,[0.5 0.3 1],'filled');
                                    hold on;
                                end
                            end
                        end
                    end
                end
            end
        end
    end
end
title('t-SNE projection');

mkdir(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\Reliability'));
cd(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\Reliability'));

saveas(hPSpaG,'GIGProjectionOfAllsubAllICOwn.tif');
saveas(hPSpaG,'GIGProjectionOfAllsubAllICOwn.fig');
close all;
cd('E:\aMRN\aProject\CompareIVAGIGICA\SimulationCode');

%show the individual ICs from different methods
for i=1:sbnum
    
    IVAICMatch=IVAICALL((i*ICnum-(ICnum-1)):(ICnum*i),:);
    GIGICMatch=GIGICALL((i*ICnum-(ICnum-1)):(ICnum*i),:);
    RealSouMatch=GTICALL((i*ICnum-(ICnum-1)):(ICnum*i),:);
    
    IVAICMatchPlMask=zeros(size(IVAICMatch,1),M*N*L);
    GIGICMatchPlMask=zeros(size(GIGICMatch,1),M*N*L);
    RealSouMatchPlMask=zeros(size(RealSouMatch,1),M*N*L);%z scored GT IC plus mask.
    
    h=1;
    for K=1:M*N*L
        if MaskVec(K)==0
            IVAICMatchPlMask(:,K)=0;
            GIGICMatchPlMask(:,K)=0;
            RealSouMatchPlMask(:,K)=0;
        else
            IVAICMatchPlMask(:,K)=IVAICMatch(:,h);
            GIGICMatchPlMask(:,K)=GIGICMatch(:,h);
            RealSouMatchPlMask(:,K)=RealSouMatch(:,h);
            h=h+1;
        end
    end
    
    IVATCMatch=IVATCALL(:,(i*ICnum-(ICnum-1)):(ICnum*i));
    RealTCMatch=GTTCALL(:,(i*ICnum-(ICnum-1)):(ICnum*i));
    GIGTCMatch=GIGTCALL(:,(i*ICnum-(ICnum-1)):(ICnum*i));
    [IndiIC1RealSMSim,IndiIC1ReSm]=SMSim(IVAICMatch,RealSouMatch);
    [IndiTC1RealTCSim,IndiTC1ReTc]=TCSim(IVATCMatch,RealTCMatch);
    
    [IndiIC2RealSMSim,IndiIC2ReSm]=SMSim(GIGICMatch,RealSouMatch);
    [IndiTC2RealTCSim,IndiTC2ReTc]=TCSim(GIGTCMatch,RealTCMatch);
    h03=figure;
    for k=1:IVASubPC1num
        subplot(IVASubPC1num,6,6*k-5);
        imshow(reshape(IVAICMatchPlMask(k,:),M,N),[]);
        tmp = sprintf('%.2f', IndiIC1ReSm(k));
        title(['\bf {IVA IC} ',int2str(k),' (',tmp,')'],'fontsize',8);
        
        subplot(IVASubPC1num,6,6*k-4);
        plot(IVATCMatch(:,k));
        tmp = sprintf('%.2f', IndiTC1ReTc(k));
        title(['\bf {IVA TC} ',int2str(k),' (',tmp,')'],'fontsize',8);
        xlim([0 timepoints]);
        ylim([-4 4]);
        
        subplot(size(GICsN2,1),6,6*k-3);
        imshow(reshape(GIGICMatchPlMask(k,:),M,N),[]);
        tmp = sprintf('%.2f', IndiIC2ReSm(k));
        title(['\bf {GIG-ICA IC} ',int2str(k),' (',tmp,')'],'fontsize',8);
        
        subplot(size(GICsN2,1),6,6*k-2);
        plot(GIGTCMatch(:,k));
        tmp = sprintf('%.2f', IndiTC2ReTc(k));
        title(['\bf {GIG-ICA TC} ',int2str(k),' (',tmp,')'],'fontsize',8);
        xlim([0 timepoints]);
        ylim([-4 4]);
        
        subplot(IVASubPC1num,6,6*k-1);
        imshow(reshape(RealSouMatchPlMask(k,:),M,N),[]);
        title(['\bf {GT IC} ',int2str(k)],'fontSize',8);
        
        subplot(IVASubPC1num,6,6*k);
        plot(RealTCMatch(:,k));
        title(['\bf {GT TC} ',int2str(k)],'fontSize',8);
        xlim([0 timepoints]);
        ylim([-4 4]);
    end
    
    mkdir(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\IndividualICTwoMethods'));
    cd(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\IndividualICTwoMethods'));
    saveas(h03,strcat('Sub',num2str(i),'IndiResuTwoMethod.fig'));
    saveas(h03,strcat('Sub',num2str(i),'IndiResuTwoMethod.png'));
    
    h04=figure;
    for k=1:IVASubPC1num
        %             subplot(IVASubPC1num,6,6*k-5);
        %             imshow(reshape(IVAICMatchPlMask(k,:),M,N),[]);
        %             tmp = sprintf('%.2f', IndiIC1ReSm(k));
        %             title(['\bf {IVA IC} ',int2str(k),' (',tmp,')'],'fontsize',8);
        
        h11=subplot(IVASubPC1num,6,6*k-5);
        arg1 = linspace(-1,1,M);
        imagesc(arg1,arg1,reshape(IVAICMatchPlMask(k,:),M,N));
        axis xy; axis square; axis off;
        hold on
        BL = polar(h11, linspace(0,2*pi,256),ones(1,256));
        set(BL, 'Color', 'w', 'LineWidth', 1);
        amax = max(abs(reshape(IVAICMatchPlMask(k,:),1,[])));
        set(h11, 'CLIM', [-amax, amax])
        colormap(CMAP);
        title(['\bf {IVA Component} ',int2str(k)],'fontSize',8);
        
        subplot(IVASubPC1num,6,6*k-4);
        plot(IVATCMatch(:,k));
        tmp = sprintf('%.2f', IndiTC1ReTc(k));
        title(['\bf {IVA TC} ',int2str(k),' (',tmp,')'],'fontsize',8);
        xlim([0 timepoints]);
        ylim([-4 4]);
        
        %             subplot(size(GICsN2,1),6,6*k-3);
        %             imshow(reshape(GIGICMatchPlMask(k,:),M,N),[]);
        %             tmp = sprintf('%.2f', IndiIC2ReSm(k));
        %             title(['\bf {GIG-ICA IC} ',int2str(k),' (',tmp,')'],'fontsize',8);
        
        h12=subplot(size(GICsN2,1),6,6*k-3);
        arg1 = linspace(-1,1,M);
        imagesc(arg1,arg1,reshape(GIGICMatchPlMask(k,:),M,N));
        axis xy; axis square; axis off;
        hold on
        BL = polar(h12, linspace(0,2*pi,256),ones(1,256));
        set(BL, 'Color', 'w', 'LineWidth', 1);
        amax = max(abs(reshape(GIGICMatchPlMask(k,:),1,[])));
        set(h12, 'CLIM', [-amax, amax])
        colormap(CMAP);
        title(['\bf {GIG-ICA IC} ',int2str(k)],'fontSize',8);
        
        subplot(size(GICsN2,1),6,6*k-2);
        plot(GIGTCMatch(:,k));
        tmp = sprintf('%.2f', IndiTC2ReTc(k));
        title(['\bf {GIG-ICA TC} ',int2str(k),' (',tmp,')'],'fontsize',8);
        xlim([0 timepoints]);
        ylim([-4 4]);
        
        %             subplot(IVASubPC1num,6,6*k-1);
        %             imshow(reshape(RealSouMatchPlMask(k,:),M,N),[]);
        %             title(['\bf {GT IC} ',int2str(k)],'fontSize',8);
        
        h13=subplot(IVASubPC1num,6,6*k-1);
        arg1 = linspace(-1,1,M);
        imagesc(arg1,arg1,reshape(RealSouMatchPlMask(k,:),M,N));
        axis xy; axis square; axis off;
        hold on
        BL = polar(h13, linspace(0,2*pi,256),ones(1,256));
        set(BL, 'Color', 'w', 'LineWidth', 1);
        amax = max(abs(reshape(RealSouMatchPlMask(k,:),1,[])));
        set(h13, 'CLIM', [-amax, amax])
        colormap(CMAP);
        title(['\bf {GT IC} ',int2str(k)],'fontSize',8);
        
        
        
        subplot(IVASubPC1num,6,6*k);
        plot(RealTCMatch(:,k));
        title(['\bf {GT TC} ',int2str(k)],'fontSize',8);
        xlim([0 timepoints]);
        ylim([-4 4]);
    end
    
    cd(strcat('E:\aMRN\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\CNR',num2str(CNR),'\IndividualICTwoMethods'));
    saveas(h04,strcat('Sub',num2str(i),'IndiResuTwoMethodG.fig'));
    saveas(h04,strcat('Sub',num2str(i),'IndiResuTwoMethodG.png'));
    
    
    cd('E:\aMRN\aProject\CompareIVAGIGICA\SimulationCode');
end
