%duyuhui,2014,7.25
%compare GIG-ICA and IVA using biased estimated IC number
%Since the IVA result and GIG-ICA result are not necessarily corresponding,
%so I show their results respectively
clc;
clear all;
close all;
addpath('/export/mialab/users/ydu/Tools/Simple_tSNE');

date='CompareGIGIVA_BiasedICnum_ownTC_140729';

DataFolder='PreviousSimTBData\BaseTran5TheSpr3DifCNRUniHFTC_Exp12';
DataParameter='BaseTran5TheSpr3CNR10UniHFTC_Exp12';
%DataParameter='BaseTran6TheSpr4CNR2UniTC_Exp12';

binsPara=3;
CMdata = load('CM_coldhot_256');
CMAP = CMdata.CM;
timepoints=150;
M=148;N=148;L=1;
sbnum=10;
v0=spm_vol(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\',num2str(DataFolder),'\',num2str(DataParameter),'\',num2str(DataParameter),'_MASK.nii'));
MaskData=spm_read_vols(v0);
MaskData=round(MaskData);
VoxNum=size(find(MaskData==1),1);
MaskVec=reshape(MaskData,1,[]);

GTICnum=8;%real IC number
%compute templates, and use the templates to match results from GIG-ICA(or
%IVA)and real sources
SumTemIC=zeros(GTICnum,M*N);
for i=1:sbnum 
    if i<10
        strzero='00';
    else if i>9&&i<100
            strzero='0';
        end
    end
    
    load (strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\',num2str(DataFolder),'\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_SIM.mat'));
    SumTemIC=SumTemIC+SM;
    
end
TemIC=SumTemIC/sbnum;
TemICInMask=zeros(GTICnum,VoxNum);
h=1;
for k=1:M*N*L
    if MaskVec(k)==1
        TemICInMask(:,h)=TemIC(:,k);
        h=h+1;
    end
end
ICnumMat=[6,8,10];
GTVecSubSimAllICDifICNum=zeros(max(ICnumMat)*sbnum*sbnum,size(ICnumMat,1));
IVAVecSubSimAllICDifICNum=zeros(max(ICnumMat)*sbnum*sbnum,size(ICnumMat,1));

for EstiICNum=1:3
    %%
    ICnum=ICnumMat(EstiICNum);%IC number used in computation
        
    FirIndiIC=zeros(sbnum*ICnum,VoxNum);   
    FmriMatr=[];data=[]; FmriMatMaskAllSub=[];
    IVAAllsubPCAOut=[];
    IVASubPC1num=ICnum;
    for i=1:sbnum
        if i<10
            strzero='00';
        else if i>9&&i<100
                strzero='0';
            end
        end
        v=spm_vol(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\',num2str(DataFolder),'\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_DATA.nii'));
        dat=spm_read_vols(v);
        for j=1:timepoints
            FmriVec=reshape(dat(:,:,:,j),1,[]);
            FmriMatr(j,:) = FmriVec;
        end
        
        %1).implement individual PCA
        
        FmriMatMask=zeros(timepoints,VoxNum);
        h=1;
        for k=1:M*N*L
            if MaskVec(k)==1
                FmriMatMask(:,h)=FmriMatr(:,k);
                h=h+1;
            end
        end
        FmriMatMaskAllSub(:,:,i)=FmriMatMask;
        [IndiPCAOut,WhitenMatrix,DewhitenMatrix]=GIG_CalPCA(FmriMatMask',IVASubPC1num);
        
        IVAAllsubPCAOut(:,:,i)=IndiPCAOut';
        
    end
    
    W = icatb_iva_second_order(IVAAllsubPCAOut, 'whiten', false);
    ICA_Options = {'maxIter', 1024, 'termThreshold', 1e-6, 'alpha0', 0.1, 'verbose', true,'whiten', false, 'initW', W};
    
    disp('Weights from second order IVA are used as initial weights in laplacian IVA. Computing laplacian IVA ...');
    W = icatb_iva_laplace(IVAAllsubPCAOut, ICA_Options{:}); % run iva-l, initialized with iva-g result
    
    for n = 1:size(W, 3)
        S = squeeze(W(:, :, n)*IVAAllsubPCAOut(:, :, n))';
        sk = sign(icatb_skewness(S) + eps);
        W(:, :, n) = diag(sk)*W(:, :, n);
        clear S;
    end
    
    IVAICAllsubMat=zeros(size(IVAAllsubPCAOut));
    for i=1:sbnum
        IVAICAllsubMat(:,:,i)=W(:,:,i)*IVAAllsubPCAOut(:,:,i);
    end
    
%     for i=1:sbnum
%         IVAICMat=IVAICAllsubMat(:,:,i);
%         IVAIndiICPlMask=zeros(IVASubPC1num,M*N*L);
%         h=1;
%         for K=1:M*N*L
%             if MaskVec(K)==0
%                 IVAIndiICPlMask(:,K)=0;
%             else
%                 IVAIndiICPlMask(:,K)=IVAICMat(:,h);
%                 h=h+1;
%             end
%         end
%         
%         h0=figure;
%         for k=1:IVASubPC1num
%             subplot(IVASubPC1num,1,k);
%             imshow(reshape(IVAIndiICPlMask(k,:),M,N),[]);
%         end
%     end

    %evaluate IVA's results
    %compute the mean IC maps across subjects for matching with template
    IVAICAllsubMatMean=mean(IVAICAllsubMat,3);
    
    SimGICsN1Tem=corr(IVAICAllsubMatMean',TemICInMask');%
    %following is another matching method
    MatchV=[];
    MatchH=[];
    MatchL=[];
    DirectioN1GB=[];
    SimGICsN1TemG=SimGICsN1Tem;
    for i=1:min(size(SimGICsN1Tem,1),size(SimGICsN1Tem,2))
        MaxValue=max(max(abs(SimGICsN1TemG)));
        MatchV=[MatchV,MaxValue];
        if size(find(SimGICsN1TemG==MaxValue),1)
            P=find(SimGICsN1TemG==MaxValue);
            DirectioN1GB(i)=1;
        else if size(find(SimGICsN1TemG==-MaxValue),1)
                P=find(SimGICsN1TemG==-MaxValue);
                DirectioN1GB(i)=-1;
            end
        end
        
        Lie=ceil(P/size(SimGICsN1Tem,1));
        Hang=mod(P,size(SimGICsN1Tem,1));
        if Hang==0
            Hang=size(SimGICsN1Tem,1);
        end
        MatchH=[MatchH,Hang];
        MatchL=[MatchL,Lie];
        SimGICsN1TemG(Hang,:)=0;
        SimGICsN1TemG(:,Lie)=0;
    end
    
    % if GTICnum>ICnum
    % [a,b]=sort(MatchH);%different from other experiments
    % Order1G=MatchL(b);
    % else if GTICnum<ICnum||GTICnum==ICnum
    %         [a,b]=sort(MatchL);%different from other experiments
    %         Order1G=MatchH(b);
    %     end
    % end
    
    SMS1=[];
    TCS1=[];
    MeanSMSG1=[];
    MeanTCSG1=[];
    IVAICALL=[];
    GTICALL=[];
        
    IVATCALL=[];
    GTTCALL=[];
    for i=1:sbnum
        %load GT IC and TC
        if i<10
            strzero='00';
        else if i>9&&i<100
                strzero='0';
            end
        end
        
        load (strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\',num2str(DataFolder),'\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_SIM.mat'));
        RealSouMat=SM;
        RealTCMat=TC(1:timepoints,:);
        RealSouInMask=zeros(GTICnum,VoxNum);
        h=1;
        for k=1:M*N*L
            if MaskVec(k)==1
                RealSouInMask(:,h)=RealSouMat(:,k);
                h=h+1;
            end
        end
        
        RealSouInMaskZ=[]; %z-score the value of GT IC in mask.
        for IC=1:GTICnum
            RealSouInMaskZ(IC,:)=(RealSouInMask(IC,:)-mean(RealSouInMask(IC,:)))/std(RealSouInMask(IC,:));
        end
        
        RealTCMatZ=[];
        for tc=1:GTICnum
            RealTCMatZ(:,tc)=(RealTCMat(:,tc)-mean(RealTCMat(:,tc)))/std(RealTCMat(:,tc));
        end
        
        %change the order of RealSou and RealTC so that comparing with IVA
        %results
        RealSouInMaskCO=[];
        RealSouInMaskZCO=[];
        RealTCMatCO=[];
        RealTCMatZCO=[];
        if GTICnum>ICnum
            number=ICnum;
        else if GTICnum<ICnum
                number=GTICnum;
            else
                number=ICnum;
            end
        end
        for ICorder=1:number
            RealSouInMaskCO(ICorder,:)=RealSouInMask(MatchL(ICorder),:);
            RealSouInMaskZCO(ICorder,:)=RealSouInMaskZ(MatchL(ICorder),:);
            RealTCMatCO(:,ICorder)= RealTCMat(:,MatchL(ICorder));
            RealTCMatZCO(:,ICorder)=RealTCMatZ(:,MatchL(ICorder));
        end
        
        %compute the independence between GT ICs
        for S=1:number
            GTKurt(i,S)= kurtn(RealSouInMaskZCO(S,:));
            GTNege(i,S)= nege(RealSouInMaskZCO(S,:));
            for S1=1:number
                [NMI,MI,MIxy,Entropyx,Entropyy,Entropyxy]=MIEtropy(RealSouInMaskZCO(S,:),RealSouInMaskZCO(S1,:),binsPara);
                GTMutuInfo(S,S1)=MI;
                GTNMutuInfo(S,S1)=NMI;
            end
        end
        
        GTMuIn=(sum(sum(triu(GTMutuInfo)))-sum(diag(triu(GTMutuInfo))))/((number*number-number)/2);
        GTNMuIn=(sum(sum(triu(GTNMutuInfo)))-sum(diag(triu(GTNMutuInfo))))/((number*number-number)/2);
        
        SumGTKurt(i)=sum(GTKurt(i,:),2);
        SumGTNege(i)=sum(GTNege(i,:),2);
        GTMI(i)=GTMuIn;
        GTNMI(i)=GTNMuIn;
        
        
        
        %%
        IVAICMat=IVAICAllsubMat(:,:,i);
        IVATCMat=FmriMatMaskAllSub(:,:,i)*pinv(IVAICMat);
        
        IVAICMatZ=[];
        for icorder=1:size(IVAICMat,1)
            IVAICMatZ(icorder,:)=(IVAICMat(icorder,:)-mean(IVAICMat(icorder,:)))/std(IVAICMat(icorder,:));
        end
        IVATCMatZ=[];
        for tcorder=1:size(IVATCMat,2)
            IVATCMatZ(:,tcorder)=(IVATCMat(:,tcorder)-mean(IVATCMat(:,tcorder)))/std(IVATCMat(:,tcorder));
        end
        
        
        %change the order of IVA ICs/TCs to match GT source/TCs
        IVATCMatCO=zeros(timepoints,number);
        IVAICMatCO=zeros(number,VoxNum);
        for ICorder=1:number
            IVAICMatCO(ICorder,:)=IVAICMat(MatchH(ICorder),:);
            IVATCMatCO(:,ICorder)= IVATCMat(:,MatchH(ICorder));
        end
        
        %change the order of z-scored IVA TC result
        IVATCMatCOZ=zeros(timepoints,number);
        IVAICMatCOZ=zeros(number,VoxNum);
        for ICorder=1:number
            IVAICMatCOZ(ICorder,:)=IVAICMatZ(MatchH(ICorder),:);
            IVATCMatCOZ(:,ICorder)=IVATCMatZ(:,MatchH(ICorder));
        end
        
        
        cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');
        
        [IndiIC1RealSMSim,IndiIC1ReSm]=SMSim(IVAICMatCO,RealSouInMaskCO);
        [IndiTC1RealTCSim,IndiTC1ReTc]=TCSim(IVATCMatCO,RealTCMatCO);
        
        [IndiIC1RealSMSimZ,IndiIC1ReSmZ]=SMSim(IVAICMatCOZ,RealSouInMaskZCO);
        [IndiTC1RealTCSimZ,IndiTC1ReTcZ]=TCSim(IVATCMatCOZ,RealTCMatZCO);
        
        SMS1(i,:)=IndiIC1ReSm';
        TCS1(i,:)=IndiTC1ReTc';
        MeanSMSG1(i)=mean(IndiIC1ReSm);
        MeanTCSG1(i)=mean(IndiTC1ReTc);
        
        %compute the independence between estimated ICs from IVA
        for S=1:number
            IVAKurt(i,S)= kurtn(IVAICMatCOZ(S,:));
            IVANege(i,S)= nege(IVAICMatCOZ(S,:));
            for S1=1:number
                [NMI,MI,MIxy,Entropyx,Entropyy,Entropyxy]=MIEtropy(IVAICMatCOZ(S,:),IVAICMatCOZ(S1,:),binsPara);
                IVAMutuInfo(S,S1)=MI;
                IVANMutuInfo(S,S1)=NMI;
            end
        end
        
        IVAMuIn=(sum(sum(triu(IVAMutuInfo)))-sum(diag(triu(IVAMutuInfo))))/((number*number-number)/2);
        IVANMuIn=(sum(sum(triu(IVANMutuInfo)))-sum(diag(triu(IVANMutuInfo))))/((number*number-number)/2);
        
        SumIVAKurt(i)=sum(IVAKurt(i,:),2);
        SumIVANege(i)=sum(IVANege(i,:),2);
        IVAMI(i)=IVAMuIn;
        IVANMI(i)=IVANMuIn;
        
        IVAICMatCOZPlMask=zeros(size(IVAICMatCO,1),M*N*L);
        RealSouInMaskZCOPlMask=zeros(size(IVAICMatCO,1),M*N*L);%z scored GT IC (after reordering) plus mask.
        h=1;
        for K=1:M*N*L
            if MaskVec(K)==0
                IVAICMatCOZPlMask(:,K)=0;
                RealSouInMaskZCOPlMask(:,K)=0;
            else
                IVAICMatCOZPlMask(:,K)=IVAICMatCOZ(:,h);
                RealSouInMaskZCOPlMask(:,K)=RealSouInMaskZCO(:,h);
                h=h+1;
            end
        end
        %if i==1||i==3||i==7;
        h00=figure;
        for k=1:min(GTICnum,ICnum)
            subplot(min(GTICnum,ICnum),5,5*k-3);
            imshow(reshape(IVAICMatCOZPlMask(k,:),M,N),[]);
            tmp = sprintf('%.2f', IndiIC1ReSm(k));
            title(['\bf {IVA IC} ',int2str(k),' (',tmp,')'],'fontsize',8);
            
            
            subplot(min(GTICnum,ICnum),5,5*k-2);
            plot(IVATCMatCOZ(:,k));
            tmp = sprintf('%.2f', IndiTC1ReTc(k));
            title(['\bf {IVA TC} ',int2str(k),' (',tmp,')'],'fontsize',8);
            xlim([0 timepoints]);
            ylim([-4 4]);
            
            subplot(min(GTICnum,ICnum),5,5*k-1);
            imshow(reshape(RealSouInMaskZCOPlMask(k,:),M,N),[]);
            title(['\bf {GT IC} ',int2str(k)],'fontSize',8);
            subplot(min(GTICnum,ICnum),5,5*k);
            plot(RealTCMatZCO(:,k));
            title(['\bf {GT TC} ',int2str(k)],'fontSize',8);
            xlim([0 timepoints]);
            ylim([-4 4]);
        end
        
        mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ICnum',num2str(ICnum)));
        mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ICnum',num2str(ICnum),'\sb',num2str(i)));
        cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ICnum',num2str(ICnum),'\sb',num2str(i)));
        saveas(h00,'IVAICTC.fig');
        saveas(h00,'IVAICTC.png');
        save('IVAICMat','IVAICMat');%not z scored
        save('IVATCMat','IVATCMat');
        %save individual ICs for later reliability evaluation
        IVAICALL((i*number-(number-1)):(number*i),:)=IVAICMatCOZ;
        GTICALL((i*number-(number-1)):(number*i),:)=RealSouInMaskZCO;
        %save individual TCs for later reliability evaluation
        IVATCALL(:,(i*number-(number-1)):(number*i))=IVATCMatCOZ;
        GTTCALL(:,(i*number-(number-1)):(number*i))=RealTCMatZCO;
        cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');
    end
    
    cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');
    
    %%
    %save the results for IVA
    %save the accuracy
    %boxplot spatial accuracy
    h1=figure;
    set (gcf,'Position',[100,100,600,500], 'color','w')
    b_1=boxplotCsub(SMS1,1,['*'],1,1,'r',2,1,true,[1 4],1.3,0,'ks');
    set(gcf,'color','white')
    xmax=IVASubPC1num+0.5;
    axis([0.5 xmax 0 1])
    set(gca,'ygrid','on');
    set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',16);
    xlabel('ICs','Fontsize',20,'Fontweight','Bold','Fontsize',20);
    ylabel('Spatial accuracy','Fontsize',20,'Fontweight','Bold','Fontsize',20);
    title('IVA spatial accuracy','Fontsize',20,'Fontweight','Bold');
    % hold on;
    % for i=1:7
    %     %X=[xaixs(i)+0.5,xaixs(i)+0.5];
    %     X=[i+0.5,i+0.5];
    %     Y=[0,1];
    %     plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
    % end
    
    %boxplot temporal accuracy
    h2=figure;
    set (gcf,'Position',[100,100,600,500], 'color','w')
    b_1=boxplotCsub(TCS1,1,['*'],1,1,'r',2,1,true,[1 4],1.3,0,'ks');
    set(gcf,'color','white')
    xmax=IVASubPC1num+0.5;
    axis([0.5 xmax 0 1])
    set(gca,'ygrid','on');
    set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',16);
    xlabel('ICs','Fontsize',20,'Fontweight','Bold','Fontsize',20);
    ylabel('Temporal accuracy','Fontsize',20,'Fontweight','Bold','Fontsize',20);
    title('IVA temporal accuracy','Fontsize',20,'Fontweight','Bold');
    % hold on;
    % for i=1:7
    %     %X=[xaixs(i)+0.5,xaixs(i)+0.5];
    %     X=[i+0.5,i+0.5];
    %     Y=[0,1];
    %     plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
    % end
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ICnum',num2str(ICnum),'\Accuracy'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ICnum',num2str(ICnum),'\Accuracy'));
    saveas(h1,strcat('IVASpaAcc.fig'));
    saveas(h1,strcat('IVASpaAcc.png'));
    saveas(h2,strcat('IVATemAcc.fig'));
    saveas(h2,strcat('IVATemAcc.png'));
    
    fprintf(strcat('Mean spatial accuracy of IVA method is'));
    MeanSpaAccIVA=mean(MeanSMSG1)
    fprintf(strcat('Mean temporal accuracy of IVA method is'));
    MeanTemAccIVA=mean(MeanTCSG1)
    save('MeanSpaAccIVA','MeanSpaAccIVA');
    save('MeanTemAccIVA','MeanTemAccIVA');
    xlswrite('MeanSpaAccIVA',MeanSpaAccIVA);
    xlswrite('MeanTemAccIVA',MeanTemAccIVA);
    
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ICnum',num2str(ICnum)));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ICnum',num2str(ICnum)));
    save('IVAICALL','IVAICALL');
    save('IVATCALL','IVATCALL');
    save('GTICALL','GTICALL');
    save('GTTCALL','GTTCALL');
    
    MeanSMSG1DifICNum(:,EstiICNum)=MeanSMSG1';
    MeanTCSG1DifICNum(:,EstiICNum)=MeanTCSG1';
        
    IVAKurtDifICNum(:,EstiICNum)=SumIVAKurt;
    IVANegeDifICNum(:,EstiICNum)=SumIVANege;
    IVAMIDifICNum(:,EstiICNum)=IVAMI;
    IVANMIDifICNum(:,EstiICNum)=IVANMI;
    
    GTKurtDifICNum(:,EstiICNum)=SumGTKurt;
    GTNegeDifICNum(:,EstiICNum)=SumGTNege;
    GTMIDifICNum(:,EstiICNum)=GTMI;
    GTNMIDifICNum(:,EstiICNum)=GTNMI;
    
    cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');
    
    %save the reliability results
    %show the reliability of different methods
    GTICALLs=[];
    for k=1:sbnum
        for l=1:number
            GTICALLs(sbnum*(l-1)+k,:)=GTICALL(number*(k-1)+l,:);
        end
    end
    GTSimMatALLs=[];
    for j=1:sbnum*number
        for k=1:sbnum*number
            GTSimMatALLs(j,k)=abs(corr(GTICALLs(j,:)',GTICALLs(k,:)'));
        end
    end
    GTSimMatALLsG=GTSimMatALLs;
    for ICorder=1:number
        for i=1+((ICorder-1)*sbnum):sbnum+((ICorder-1)*sbnum)
            for j=sbnum+1+((ICorder-1)*sbnum):sbnum*number
                GTSimMatALLsG(i,j)=NaN;
            end
        end
    end
    
    figure;
    [X,Y]=meshgrid(1:1:sbnum*number, 1:1:sbnum*number);
    h=pcolor(X,Y,GTSimMatALLsG);
    caxis([0,1]);
    %colorbar('horiz');
    colormap(jet(64));
    grid off;
    axis ij
    axis square
    set(h,'LineStyle','none')
    set(gca,'FontName','Times New Roman','Fontsize',26,'Fontweight','Bold')
    title(['\bf {GT}' ],'Fontsize',26,'Fontweight','Bold');
    
    %axis([0.5 124.5 0.5 124.5])
    set(gca,'XTick',[sbnum/2:sbnum:sbnum*number],'Fontweight','Bold','Fontsize',20);
    set(gca,'YTick',[sbnum/2:sbnum:sbnum*number],'Fontweight','Bold','Fontsize',20);
    set(gca,'box','off')
    set(gcf,'paperunits','centimeters');
    set(gcf,'papersize',[3 3]);
    set(gca,'XTickLabel',{'1','2','3','4','5','6','7','8'},'Fontweight','Bold','Fontsize',26);
    set(gca,'YTickLabel',{'1','2','3','4','5','6','7','8'},'Fontweight','Bold','Fontsize',26);
    
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ICnum',num2str(ICnum),'\Reliability'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ICnum',num2str(ICnum),'\Reliability'));
    saveas(h,strcat('GTCorrMatrix.fig'));
    print('-dtiff','-r500',strcat('GTCorrMatrix.tif'));
    
    GTMat=[];
    GTVecSubSimAllIC=[];
    %boxplot the similarity
    for k=1:number
        GTSubSimMat=GTSimMatALLs(sbnum*(k-1)+1:sbnum*k,sbnum*(k-1)+1:sbnum*k);
        GTTriSub=triu(GTSubSimMat,1);
        GTVecSubSim=reshape(GTTriSub,1,sbnum*sbnum);
        % MeanSimIC2(k)=mean(VecSubSim2);
        % StdSimIC2(k)=std(VecSubSim2);
        GTMat(:,k)=GTVecSubSim';
        GTVecSubSimAllIC=[GTVecSubSimAllIC,GTVecSubSim];
    end
    [m,n]=size(GTVecSubSimAllIC);
    GTVecSubSimAllICg=[GTVecSubSimAllIC,zeros(1,max(ICnumMat)*sbnum*sbnum-n)];
    GTVecSubSimAllICDifICNum(:,EstiICNum)=GTVecSubSimAllICg';
    
    
    GTMatG=GTMat;
    GTMatGG=GTMat;
    for i=1:sbnum*sbnum
        for j=1:number
            if GTMat(i,j)==1
                GTMatG(i,j)=NaN;
                GTMatGG(i,j)=0;
            end
            if GTMat(i,j)==0
                GTMatG(i,j)=NaN;
            end;
        end
    end
    GTEachICMeanCorr=zeros(1,number);
    for j=1:number
        GTEachICMeanCorr(1,j)=sum(GTMatGG(:,j))/size(find(GTMatGG(:,j)~=0),1);
    end
    
    
    cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');
    hp=figure;
    %set (gcf,'Position',[0,0,400,1200], 'color','w')
    set (gcf,'Position',[0,0,1200,400], 'color','w')
    b_1=boxplotCsub(GTMatG,1,['*'],1,1,'b',2,2,true,[1 1],1.3,0,'ks');
    Hla=cell(1,number);
    for i=1:size(Hla,2)
        Hla{i}=i;
    end
    set(gcf,'color','white')
    a=number+0.5;
    axis([0.5 a 0 1])
    set(gca,'ygrid','on');
    set(gca,'YTick',[0:0.2:2],'Fontweight','Bold','Fontsize',20);
    xlabel('IC ID','Fontweight','Bold','Fontsize',20);
    ylabel('Absolute value of correlation','Fontweight','Bold','Fontsize',20);
    set(gca,'XTickLabel',Hla,'Fontweight','Bold','Fontsize',20);%,
    title('GT','Fontsize',20,'Fontweight','Bold');
    
    hold on;
    for i=1:number-1
        %X=[xaixs(i)+0.5,xaixs(i)+0.5];
        X=[i+0.5,i+0.5];
        Y=[0,1];
        plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
    end
    % az = -90;
    % el = 90;
    % view(az, el);
    
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ICnum',num2str(ICnum),'\Reliability'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ICnum',num2str(ICnum),'\Reliability'));
    saveas(hp,'GTEachICReliability.png');
    saveas(hp,'GTEachICReliability.fig');
    
    
    a=1:number;
    Label=[];
    for i=1:sbnum
        Label=[Label,a];
    end
    figure;
    GTAllFea2D = tsne(GTICALL, Label);
    hP=gcf;
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ICnum',num2str(ICnum),'\Reliability'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ICnum',num2str(ICnum),'\Reliability'));
    
    saveas(hP,'GTProjectionOfAllsubAllIC.tif');
    saveas(hP,'GTProjectionOfAllsubAllIC.fig');
    save('GTAllFea2D','GTAllFea2D');
    save('GTICALL','GTICALL');
    save('GTTCALL','GTTCALL');
    figure;
    GTAllFea2DG=zeros(size(GTAllFea2D));
    for k=1:sbnum
        for l=1:number
            GTAllFea2DG(sbnum*(l-1)+k,:)=GTAllFea2D(number*(k-1)+l,:);
        end
    end
    hPSpaG=figure;
    if number==7
        for i=1:size(GTAllFea2DG,1)
            if i<sbnum+1
                scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'r','filled');
                hold on;
            else if i<sbnum*2+1
                    scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'b','filled');
                    hold on;
                else if i<sbnum*3+1
                        scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'c','filled');
                        hold on;
                    else if i<sbnum*4+1
                            scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'g','filled');
                            hold on;
                        else if i<sbnum*5+1
                                scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'k','filled');
                                hold on;
                            else if i<sbnum*6+1
                                    scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'y','filled');
                                    hold on;
                                else if i<sbnum*7+1
                                        scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'m','filled');
                                        hold on;
                                        
                                    end
                                end
                            end
                        end
                    end
                end
            end
        end
        title('t-SNE projection');
        
    else if number==8
            for i=1:size(GTAllFea2DG,1)
                if i<sbnum+1
                    scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'r','filled');
                    hold on;
                else if i<sbnum*2+1
                        scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'b','filled');
                        hold on;
                    else if i<sbnum*3+1
                            scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'c','filled');
                            hold on;
                        else if i<sbnum*4+1
                                scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'g','filled');
                                hold on;
                            else if i<sbnum*5+1
                                    scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'k','filled');
                                    hold on;
                                else if i<sbnum*6+1
                                        scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'y','filled');
                                        hold on;
                                    else if i<sbnum*7+1
                                            scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'m','filled');
                                            hold on;
                                        else if i<sbnum*8+1
                                                scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,[0.5 0.3 1],'filled');
                                                hold on;
                                            end
                                        end
                                    end
                                end
                            end
                        end
                    end
                end
            end
            title('t-SNE projection');
        end
    end
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ICnum',num2str(ICnum),'\Reliability'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ICnum',num2str(ICnum),'\Reliability'));
    
    saveas(hPSpaG,'GTProjectionOfAllsubAllICOwn.tif');
    saveas(hPSpaG,'GTProjectionOfAllsubAllICOwn.fig');
    close all;
    IVAICALLs=[];
    for k=1:sbnum
        for l=1:number
            IVAICALLs(sbnum*(l-1)+k,:)=IVAICALL(number*(k-1)+l,:);
        end
    end
    IVASimMatALLs=[];
    for j=1:sbnum*number
        for k=1:sbnum*number
            IVASimMatALLs(j,k)=abs(corr(IVAICALLs(j,:)',IVAICALLs(k,:)'));
        end
    end
    IVASimMatALLsG=IVASimMatALLs;
    for ICorder=1:number
        for i=1+((ICorder-1)*sbnum):sbnum+((ICorder-1)*sbnum)
            for j=sbnum+1+((ICorder-1)*sbnum):sbnum*number
                IVASimMatALLsG(i,j)=NaN;
            end
        end
    end
    
    figure;
    [X,Y]=meshgrid(1:1:sbnum*number, 1:1:sbnum*number);
    h=pcolor(X,Y,IVASimMatALLsG);
    caxis([0,1]);
    %colorbar('horiz');
    colormap(jet(64));
    grid off;
    axis ij
    axis square
    set(h,'LineStyle','none')
    set(gca,'FontName','Times New Roman','Fontsize',26,'Fontweight','Bold')
    title(['\bf {IVA }' ],'Fontsize',26,'Fontweight','Bold');
    
    %axis([0.5 124.5 0.5 124.5])
    set(gca,'XTick',[sbnum/2:sbnum:sbnum*number],'Fontweight','Bold','Fontsize',20);
    set(gca,'YTick',[sbnum/2:sbnum:sbnum*number],'Fontweight','Bold','Fontsize',20);
    set(gca,'box','off')
    set(gcf,'paperunits','centimeters');
    set(gcf,'papersize',[3 3]);
    set(gca,'XTickLabel',{'1','2','3','4','5','6','7','8'},'Fontweight','Bold','Fontsize',26);
    set(gca,'YTickLabel',{'1','2','3','4','5','6','7','8'},'Fontweight','Bold','Fontsize',26);
    
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ICnum',num2str(ICnum),'\Reliability'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ICnum',num2str(ICnum),'\Reliability'));
    saveas(h,strcat('IVACorrMatrix.fig'));
    print('-dtiff','-r500',strcat('IVACorrMatrix.tif'));
    
    IVAMat=[];
    IVAVecSubSimAllIC=[];
    %boxplot the similarity
    for k=1:number
        IVASubSimMat=IVASimMatALLs(sbnum*(k-1)+1:sbnum*k,sbnum*(k-1)+1:sbnum*k);
        IVATriSub=triu(IVASubSimMat,1);
        IVAVecSubSim=reshape(IVATriSub,1,sbnum*sbnum);
        % MeanSimIC2(k)=mean(VecSubSim2);
        % StdSimIC2(k)=std(VecSubSim2);
        IVAMat(:,k)=IVAVecSubSim';
        IVAVecSubSimAllIC=[IVAVecSubSimAllIC,IVAVecSubSim];
    end
    [m,n]=size(IVAVecSubSimAllIC);
    IVAVecSubSimAllICg=[IVAVecSubSimAllIC,zeros(1,max(ICnumMat)*sbnum*sbnum-n)];
    IVAVecSubSimAllICDifICNum(:,EstiICNum)=IVAVecSubSimAllICg';
    
    IVAMatG=IVAMat;
    IVAMatGG=IVAMat;
    for i=1:sbnum*sbnum
        for j=1:number
            if IVAMat(i,j)==1
                IVAMatG(i,j)=NaN;
                IVAMatGG(i,j)=0;
            end
            if IVAMat(i,j)==0
                IVAMatG(i,j)=NaN;
            end;
        end
    end
    IVAEachICMeanCorr=zeros(1,number);
    for j=1:number
        IVAEachICMeanCorr(1,j)=sum(IVAMatGG(:,j))/size(find(IVAMatGG(:,j)~=0),1);
    end
    
    
    cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');
    hp=figure;
    %set (gcf,'Position',[0,0,400,1200], 'color','w')
    set (gcf,'Position',[0,0,1200,400], 'color','w')
    b_1=boxplotCsub(IVAMatG,1,['*'],1,1,'b',2,2,true,[1 1],1.3,0,'ks');
    Hla=cell(1,number);
    for i=1:size(Hla,2)
        Hla{i}=i;
    end
    set(gcf,'color','white')
    a=number+0.5;
    axis([0.5 a 0 1])
    set(gca,'ygrid','on');
    set(gca,'YTick',[0:0.2:2],'Fontweight','Bold','Fontsize',20);
    xlabel('IC ID','Fontweight','Bold','Fontsize',20);
    ylabel('Absolute value of correlation','Fontweight','Bold','Fontsize',20);
    set(gca,'XTickLabel',Hla,'Fontweight','Bold','Fontsize',20);%,
    title('IVA','Fontsize',20,'Fontweight','Bold');
    
    hold on;
    for i=1:number-1
        %X=[xaixs(i)+0.5,xaixs(i)+0.5];
        X=[i+0.5,i+0.5];
        Y=[0,1];
        plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
    end
    % az = -90;
    % el = 90;
    % view(az, el);
    
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ICnum',num2str(ICnum),'\Reliability'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ICnum',num2str(ICnum),'\Reliability'));
    saveas(hp,'IVAEachICReliability.png');
    saveas(hp,'IVAEachICReliability.fig');
    
    figure;
    IVAAllFea2D = tsne(IVAICALL, Label);
    hP=gcf;
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ICnum',num2str(ICnum),'\Reliability'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ICnum',num2str(ICnum),'\Reliability'));
    
    saveas(hP,'IVAProjectionOfAllsubAllIC.tif');
    saveas(hP,'IVAProjectionOfAllsubAllIC.fig');
    save('IVAAllFea2D','IVAAllFea2D');
     figure;
    IVAAllFea2DG=zeros(size(IVAAllFea2D));
    for k=1:sbnum
        for l=1:number
            IVAAllFea2DG(sbnum*(l-1)+k,:)=IVAAllFea2D(number*(k-1)+l,:);
        end
    end
    hPSpaG=figure;
    if number==7
        for i=1:size(IVAAllFea2DG,1)
            if i<sbnum+1
                scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'r','filled');
                hold on;
            else if i<sbnum*2+1
                    scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'b','filled');
                    hold on;
                else if i<sbnum*3+1
                        scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'c','filled');
                        hold on;
                    else if i<sbnum*4+1
                            scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'g','filled');
                            hold on;
                        else if i<sbnum*5+1
                                scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'k','filled');
                                hold on;
                            else if i<sbnum*6+1
                                    scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'y','filled');
                                    hold on;
                                else if i<sbnum*7+1
                                        scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'m','filled');
                                        hold on;
                                        
                                    end
                                end
                            end
                        end
                    end
                end
            end
        end
        title('t-SNE projection');
        
    else if number==8
            for i=1:size(IVAAllFea2DG,1)
                if i<sbnum+1
                    scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'r','filled');
                    hold on;
                else if i<sbnum*2+1
                        scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'b','filled');
                        hold on;
                    else if i<sbnum*3+1
                            scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'c','filled');
                            hold on;
                        else if i<sbnum*4+1
                                scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'g','filled');
                                hold on;
                            else if i<sbnum*5+1
                                    scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'k','filled');
                                    hold on;
                                else if i<sbnum*6+1
                                        scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'y','filled');
                                        hold on;
                                    else if i<sbnum*7+1
                                            scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'m','filled');
                                            hold on;
                                        else if i<sbnum*8+1
                                                scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,[0.5 0.3 1],'filled');
                                                hold on;
                                            end
                                        end
                                    end
                                end
                            end
                        end
                    end
                end
            end
            title('t-SNE projection');
        end
    end
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ICnum',num2str(ICnum),'\Reliability'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ICnum',num2str(ICnum),'\Reliability'));
    
    saveas(hPSpaG,'IVAProjectionOfAllsubAllICOwn.tif');
    saveas(hPSpaG,'IVAProjectionOfAllsubAllICOwn.fig');
    %show the independence of different methods
    h7=figure;
    set(gcf,'Position',[100,100,600,500], 'color','w')
    bar([GTNMI',IVANMI'],'group');
    
    h8=figure;
    set(gcf,'Position',[100,100,600,500], 'color','w')
    bar([SumGTKurt', SumIVAKurt'],'group');
    
    h9=figure;
    set(gcf,'Position',[100,100,600,500], 'color','w')
    bar([SumGTNege', SumIVANege'],'group');
    
    h10=figure;
    set(gcf,'Position',[100,100,600,500], 'color','w')
    bar([GTMI',IVAMI'],'group');
    
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ICnum',num2str(ICnum),'\Independence'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ICnum',num2str(ICnum),'\Independence'));
    
    saveas(h7,strcat('NMI.fig'));
    saveas(h7,strcat('NMI.png'));
    saveas(h8,strcat('Kurt.fig'));
    saveas(h8,strcat('Kurt.png'));
    saveas(h9,strcat('Nege.fig'));
    saveas(h9,strcat('Nege.png'));
    saveas(h10,strcat('MI.fig'));
    saveas(h10,strcat('MI.png'));
        
    GTReliaDifICNum(:,EstiICNum)=mean(GTEachICMeanCorr);
    IVAReliaDifICNum(:,EstiICNum)=mean(IVAEachICMeanCorr);
    close all;
    close all;
    cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');

end


%show the accuracy of IVA
h1=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(MeanSMSG1DifICNum,1,['*'],1,1,'b',2,1,true,[1 1],1.3,0,'ks');
set(gcf,'color','white')
axis([0.5 3.5 0.3 1])
set(gca,'ygrid','on');
set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',24);
xlabel('Number of ICs used in compuation','Fontsize',24,'Fontweight','Bold','Fontsize',24);
ylabel('Spatial accuracy','Fontsize',24,'Fontweight','Bold','Fontsize',24);
set(gca,'XTickLabel',{'6','8','10'},'Fontweight','Bold','Fontsize',24);%,
title('(A)','Fontsize',24,'Fontweight','Bold');
hold on;
for i=1:3
    X=[i+0.5,i+0.5];
    Y=[0,1];
    plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
end
legend([b_1(8,1)],{'IVA'},3)

%boxplot spatial accuracy under different GIGGroupPCnum
h2=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(MeanTCSG1DifICNum,1,['*'],1,1,'b',2,1,true,[1 1],1.3,0,'ks');
set(gcf,'color','white')
axis([0.5 3.5 0.3 1])
set(gca,'ygrid','on');
set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',24);
xlabel('Number of ICs used in compuation','Fontsize',24,'Fontweight','Bold','Fontsize',24);
ylabel('Temporal accuracy','Fontsize',24,'Fontweight','Bold','Fontsize',24);
set(gca,'XTickLabel',{'6','8','10'},'Fontweight','Bold','Fontsize',24);%,
title('(B)','Fontsize',24,'Fontweight','Bold');
hold on;
for i=1:3
    X=[i+0.5,i+0.5];
    Y=[0,1];
    plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
end
legend([b_1(8,1)],{'IVA'},3)

cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date)));

 mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ResultSum\Accuracy'));
cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ResultSum\Accuracy'));   
saveas(h1,'SpatialAccuracySummary.fig');
saveas(h1,'SpatialAccuracySummary.png');
saveas(h2,'TemporalAccuracySummary.fig');
saveas(h2,'TemporalAccuracySummary.png');
save('MeanSMSG1DifICNum','MeanSMSG1DifICNum');
save('MeanTCSG1DifICNum','MeanTCSG1DifICNum');

    
cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');

h3=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(GTKurtDifICNum,1,['*'],1,1,'m',2,1,true,[1 2],1.3,0,'ks');
b_2=boxplotCsub(IVAKurtDifICNum,1,['*'],1,1,'b',2,1,true,[2 2],1.3,0,'ks');

set(gcf,'color','white')
axis([0.5 3.5 0 100])
set(gca,'ygrid','on');
%set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',24);
xlabel('Number of ICs used in compuation','Fontsize',24,'Fontweight','Bold','Fontsize',24);
ylabel('Kurtosis','Fontsize',24,'Fontweight','Bold','Fontsize',24);
set(gca,'XTickLabel',{'6','8','10'},'Fontweight','Bold','Fontsize',24);%,

title('(A)','Fontsize',24,'Fontweight','Bold');
hold on;
for i=1:3
    X=[i+0.5,i+0.5];
    Y=[0,1];
    plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
end
legend([b_1(8,1) b_2(8,1)],{'GT','IVA'},3)

h4=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(GTNegeDifICNum,1,['*'],1,1,'m',2,1,true,[1 3],1.3,0,'ks');
b_2=boxplotCsub(IVANegeDifICNum,1,['*'],1,1,'b',2,1,true,[2 3],1.3,0,'ks');

set(gcf,'color','white')
axis([0.5 3.5 0 0.5])
set(gca,'ygrid','on');
%set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',24);
xlabel('Number of ICs used in compuation','Fontsize',24,'Fontweight','Bold','Fontsize',24);
ylabel('Negentropy','Fontsize',24,'Fontweight','Bold','Fontsize',24);
set(gca,'XTickLabel',{'6','8','10'},'Fontweight','Bold','Fontsize',24);%,

title('(B)','Fontsize',24,'Fontweight','Bold');
hold on;
for i=1:3
    X=[i+0.5,i+0.5];
    Y=[0,1];
    plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
end
legend([b_1(8,1) b_2(8,1)],{'GT','IVA'},3) 

h5=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(GTMIDifICNum,1,['*'],1,1,'m',2,1,true,[1 3],1.3,0,'ks');
b_2=boxplotCsub(IVAMIDifICNum,1,['*'],1,1,'b',2,1,true,[2 3],1.3,0,'ks');

set(gcf,'color','white')
axis([0.5 3.5 0 0.2])
set(gca,'ygrid','on');
%set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',24);
xlabel('Number of ICs used in compuation','Fontsize',24,'Fontweight','Bold','Fontsize',24);
ylabel('Mutual information','Fontsize',24,'Fontweight','Bold','Fontsize',24);
set(gca,'XTickLabel',{'6','8','10'},'Fontweight','Bold','Fontsize',24);%,
title('(C)','Fontsize',24,'Fontweight','Bold');

hold on;
for i=1:3
    X=[i+0.5,i+0.5];
    Y=[0,1];
    plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
end
legend([b_1(8,1) b_2(8,1)],{'GT','IVA'},3)

h6=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(GTNMIDifICNum,1,['*'],1,1,'m',2,1,true,[1 3],1.3,0,'ks');
b_2=boxplotCsub(IVANMIDifICNum,1,['*'],1,1,'b',2,1,true,[2 3],1.3,0,'ks');

set(gcf,'color','white')
axis([0.5 3.5 0 0.2])
set(gca,'ygrid','on');
%set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',24);
xlabel('Number of ICs used in compuation','Fontsize',24,'Fontweight','Bold','Fontsize',24);
ylabel('Normalized mutual information','Fontsize',24,'Fontweight','Bold','Fontsize',24);
set(gca,'XTickLabel',{'6','8','10'},'Fontweight','Bold','Fontsize',24);%,
title('(D)','Fontsize',24,'Fontweight','Bold');
hold on;
for i=1:3
    X=[i+0.5,i+0.5];
    Y=[0,1];
    plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
end
legend([b_1(8,1) b_2(8,1)],{'GT','IVA'},3)

mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ResultSum\Independence'));
cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ResultSum\Independence'));
saveas(h3,'KurtSummary.fig');
saveas(h3,'KurtSummary.png');
saveas(h4,'NegeSummary.fig');
saveas(h4,'NegeSummary.png');
saveas(h5,'MISummary.fig');
saveas(h5,'MISummary.png');
saveas(h6,'NMISummary.fig');
saveas(h6,'NMISummary.png');

save('GTKurtDifICNum','GTKurtDifICNum');
save('IVAKurtDifICNum','IVAKurtDifICNum');

save('GTNegeDifICNum','GTNegeDifICNum');
save('IVANegeDifICNum','IVANegeDifICNum');

save('GTMIDifICNum','GTMIDifICNum');
save('IVAMIDifICNum','IVAMIDifICNum');

save('GTNMIDifICNum','GTNMIDifICNum');
save('IVANMIDifICNum','IVANMIDifICNum');
cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');

%%
%show the reliability under Number of ICs used in compuation
for i=1:size(GTVecSubSimAllICDifICNum,1)
    for j=1:size(GTVecSubSimAllICDifICNum,2)
        if GTVecSubSimAllICDifICNum(i,j)==0
            GTVecSubSimAllICDifICNum(i,j)=NaN;
        end
        if GTVecSubSimAllICDifICNum(i,j)==1
            GTVecSubSimAllICDifICNum(i,j)=NaN;
        end
    end
end

for i=1:size(IVAVecSubSimAllICDifICNum,1)
    for j=1:size(IVAVecSubSimAllICDifICNum,2)
        if IVAVecSubSimAllICDifICNum(i,j)==0
            IVAVecSubSimAllICDifICNum(i,j)=NaN;
        end
        if IVAVecSubSimAllICDifICNum(i,j)==1
            IVAVecSubSimAllICDifICNum(i,j)=NaN;
        end
    end
end
h7=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(GTVecSubSimAllICDifICNum,1,['*'],1,1,'m',2,1,true,[1 2],1.3,0,'ks');
b_2=boxplotCsub(IVAVecSubSimAllICDifICNum,1,['*'],1,1,'b',2,1,true,[2 2],1.3,0,'ks');

set(gcf,'color','white')
axis([0.5 3.5 0.3 1])
set(gca,'ygrid','on');
set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',24);
xlabel('Number of ICs used in compuation','Fontsize',24,'Fontweight','Bold','Fontsize',24);
ylabel('Reliability','Fontsize',24,'Fontweight','Bold','Fontsize',24);
set(gca,'XTickLabel',{'6','8','10'},'Fontweight','Bold','Fontsize',24);%,

%title('(D)','Fontsize',24,'Fontweight','Bold');
hold on;
for i=1:3
    X=[i+0.5,i+0.5];
    Y=[0,1];
    plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
end
legend([b_1(8,1) b_2(8,1) ],{'GT','IVA'},3)


h8=figure;
bar([GTReliaDifICNum;IVAReliaDifICNum]','group');
mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ResultSum\Reliability'));
cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ResultSum\Reliability'));
saveas(h7,'ReliabilitySummary.fig');
saveas(h7,'ReliabilitySummary.png');
saveas(h8,'ReliabilitySummaryBar.fig');
saveas(h8,'ReliabilitySummaryBar.png');

save('GTVecSubSimAllICDifICNum','GTVecSubSimAllICDifICNum');
save('IVAVecSubSimAllICDifICNum','IVAVecSubSimAllICDifICNum');
    
cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');

%%
%GIG-ICA
GTVecSubSimAllICDifICNum=zeros(max(ICnumMat)*sbnum*sbnum,size(ICnumMat,1));
GIGVecSubSimAllICDifICNum=zeros(max(ICnumMat)*sbnum*sbnum,size(ICnumMat,1));

for EstiICNum=1:3
    ICnum=ICnumMat(EstiICNum);%IC number used in computation
    %%
    %GIG-ICA
    %1.set some parameters
    GIGSubPCnum=ICnum;
    GIGGroupPCnum=ICnum;
    
    %2.read data, and implement subject PCA.
    for i=1:sbnum
        if i<10
            strzero='00';
        else if i>9&&i<100
                strzero='0';
            end
        end
        
        v=spm_vol(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\',num2str(DataFolder),'\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_DATA.nii'));
        dat=spm_read_vols(v);
        for j=1:timepoints
            FmriVec=reshape(dat(:,:,:,j),1,[]);
            FmriMatr(j,:) = FmriVec;
        end
        
        FmriMatMask=zeros(timepoints,VoxNum);
        h=1;
        for k=1:M*N*L
            if MaskVec(k)==1
                FmriMatMask(:,h)=FmriMatr(:,k);
                h=h+1;
            end
        end
        
        IndiPCAData= GIG_CalPCA( FmriMatMask',GIGSubPCnum); %subject level PCA
        SubPCAOut(:,GIGSubPCnum*(i-1)+1:GIGSubPCnum*i)=IndiPCAData;%
    end
    
    GroupPCAOut = GIG_CalPCA(SubPCAOut,GIGGroupPCnum); %
    
    disp('Start group level ICA for geting group components......................................');
    %group ICA
    algorithmName='Infomax';
    %use the ICASSO
    %[A, GICs] = useICASSO(GroupPCAOut', algorithmName);
    [W2, A2, GICs2] = GIG_IcaAlgorithm(algorithmName, GroupPCAOut');
    clear SubPCAOut;
    clear GroupPCAOut;
    GICsN2=zeros(GIGGroupPCnum,VoxNum);
    %normalize the GICs for output or for the consequent average
    GICsC2=GICs2-repmat(mean(GICs2,2),[1,VoxNum]);
    for i=1:size(GICs2,1)
        GICsN2(i,:)=GICsC2(i,:)/std(GICsC2(i,:));
    end
    
    GICICMatPlMask=zeros(size(GICsN2,1),M*N*L);
    h=1;
    for K=1:M*N*L
        if MaskVec(K)==0
            GICICMatPlMask(:,K)=0;
        else
            GICICMatPlMask(:,K)=GICsN2(:,h);
            h=h+1;
        end
    end
    h00=figure;
    for k=1:size(GICs2,1)
        subplot(size(GICs2,1),1,k);
        imshow(reshape(GICICMatPlMask(k,:),M,N),[]);
        
    end
    
    %evaluate the results
    %match GIG-ICA and real sources
    SimGICsN2Tem=corr(GICsN2',TemICInMask');%
    figure;
    imagesc(SimGICsN2Tem);colorbar;
    %following is another matching method
    MatchV=[];
    MatchH=[];
    MatchL=[];
    Direction2GB=[];
    SimGICsN2TemG=SimGICsN2Tem;
    for i=1:min(size(SimGICsN2Tem,1),size(SimGICsN2Tem,2))
        MaxValue=max(max(abs(SimGICsN2TemG)));
        MatchV=[MatchV,MaxValue];
        if size(find(SimGICsN2TemG==MaxValue),1)
            P=find(SimGICsN2TemG==MaxValue);
            Direction2GB(i)=1;
        else if size(find(SimGICsN2TemG==-MaxValue),1)
                P=find(SimGICsN2TemG==-MaxValue);
                Direction2GB(i)=-1;
            end
        end
        
        Lie=ceil(P/size(SimGICsN2Tem,1));
        Hang=mod(P,size(SimGICsN2Tem,1));
        if Hang==0
            Hang=size(SimGICsN2Tem,1);
        end
        MatchH=[MatchH,Hang];
        MatchL=[MatchL,Lie];
        SimGICsN2TemG(Hang,:)=0;
        SimGICsN2TemG(:,Lie)=0;
    end
    
    % if GTICnum>ICnum
    % [a,b]=sort(MatchH);%different from other experiments
    % Order2G=MatchL(b);
    % else if GTICnum<ICnum||GTICnum==ICnum
    %         [a,b]=sort(MatchL);%different from other experiments
    %         Order2G=MatchH(b);
    %     end
    % end
    
    SMS2=[];
    TCS2=[];
    MeanSMSG2=[];
    MeanTCSG2=[];
  
    GIGICALL=[];
    GIGTCALL=[];
    GTICALL=[];
    GTTCALL=[];
    for i=1:sbnum
        if i<10
            strzero='00';
        else if i>9&&i<100
                strzero='0';
            end
        end
        v=spm_vol(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\',num2str(DataFolder),'\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_DATA.nii'));
        dat=spm_read_vols(v);
        for j=1:timepoints
            FmriVec=reshape(dat(:,:,:,j),1,[]);
            FmriMatr(j,:) = FmriVec;
        end
        
        FmriMatMask=zeros(timepoints,VoxNum);
        h=1;
        for k=1:M*N*L
            if MaskVec(k)==1
                FmriMatMask(:,h)=FmriMatr(:,k);
                h=h+1;
            end
        end
        
        nemda=0;
        a=0.5;
        [GIGICMat,UnmixMat,GIGTCMatB,ObFunc,C,IterMat]=GIGICAArReInCISGamaArmiTGWRSF(FmriMatMask,GIGGroupPCnum,GICsN2,a,nemda);
        %GIGTCMat=FmriMatMask*pinv(GIGICMat);method 1: like the computation in GIFT
        GIGTCMat=GIGTCMatB;%method 2: my method
        
        %     %method 3: regression one by one  like computation in FSL using
        %     GIGICs
        %     GIGTCMat=[];
        %     for  tc=1:size(GIGICMat,1)
        %         GIGTCMat(:,tc)=FmriMatMask*pinv(GIGICMat(tc,:));
        %     end
        
        %     %method 4: regression one by one using group ICs
        %     GIGTCMat=[];
        %     for  tc=1:size(GIGICMat,1)
        %     GIGTCMat(:,tc)=FmriMatMask*pinv(GICsN2(tc,:));
        %     end
        
        %     %method 5: regression at one time using group ICs
        %     GIGTCMat=FmriMatMask*pinv(GICsN2);
        
        GIGTCMatZ=[];
        for tc=1:size(GIGTCMat,2)
            GIGTCMatZ(:,tc)=(GIGTCMat(:,tc)-mean(GIGTCMat(:,tc)))/std(GIGTCMat(:,tc));
        end
        
        
        %%
        %load GT IC and TC
        if i<10
            strzero='00';
        else if i>9&&i<100
                strzero='0';
            end
        end
        
        load (strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\',num2str(DataFolder),'\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_SIM.mat'));
        RealSouMat=SM;
        RealTCMat=TC(1:timepoints,:);
        RealSouInMask=zeros(GTICnum,VoxNum);
        h=1;
        for k=1:M*N*L
            if MaskVec(k)==1
                RealSouInMask(:,h)=RealSouMat(:,k);
                h=h+1;
            end
        end
        RealSouInMaskZ=[]; %z-score the value of GT IC in mask.
        for IC=1:GTICnum
            RealSouInMaskZ(IC,:)=(RealSouInMask(IC,:)-mean(RealSouInMask(IC,:)))/std(RealSouInMask(IC,:));
        end
        
        RealTCMatZ=[];
        for tc=1:GTICnum
            RealTCMatZ(:,tc)=(RealTCMat(:,tc)-mean(RealTCMat(:,tc)))/std(RealTCMat(:,tc));
        end
        
        %change the order of RealSou and RealTC so that comparing with IVA
        %results
        RealSouInMaskCO=[];
        RealSouInMaskZCO=[];
        RealTCMatCO=[];
        RealTCMatZCO=[];
        if GTICnum>ICnum
            number=ICnum;
        else if GTICnum<ICnum
                number=GTICnum;
            else
                number=ICnum;
            end
        end
        for ICorder=1:number
            RealSouInMaskCO(ICorder,:)=RealSouInMask(MatchL(ICorder),:);
            RealSouInMaskZCO(ICorder,:)=RealSouInMaskZ(MatchL(ICorder),:);
            RealTCMatCO(:,ICorder)= RealTCMat(:,MatchL(ICorder));
            RealTCMatZCO(:,ICorder)=RealTCMatZ(:,MatchL(ICorder));
        end
        
        %change the order of GIG result
        GIGTCMatCO=zeros(timepoints,number);
        GIGICMatCO=zeros(number,VoxNum);
        GIGTCMatZCO=zeros(timepoints,number);
        for ICorder=1:number
            GIGICMatCO(ICorder,:)=GIGICMat(MatchH(ICorder),:);
            GIGTCMatCO(:,ICorder)= GIGTCMat(:,MatchH(ICorder));
            GIGTCMatZCO(:,ICorder)=GIGTCMatZ(:,MatchH(ICorder));
        end
        
        cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');
        
        [IndiIC2RealSMSim,IndiIC2ReSm]=SMSim(GIGICMatCO,RealSouInMaskCO);
        [IndiTC2RealTCSim,IndiTC2ReTc]=TCSim(GIGTCMatCO,RealTCMatCO);
        
        [IndiIC2RealSMSimZ,IndiIC2ReSmZ]=SMSim(GIGICMatCO,RealSouInMaskZCO);
        [IndiTC2RealTCSimZ,IndiTC2ReTcZ]=TCSim(GIGTCMatZCO,RealTCMatZCO);
        
        SMS2(i,:)=IndiIC2ReSm';
        TCS2(i,:)=IndiTC2ReTc';
        MeanSMSG2(i)=mean(IndiIC2ReSm);
        MeanTCSG2(i)=mean(IndiTC2ReTc);
        
        binsPara=3;
        %compute the independence between estimated ICs from IVA
        for S=1:number
            GIGKurt(i,S)= kurtn(GIGICMatCO(S,:));
            GIGNege(i,S)= nege(GIGICMatCO(S,:));
            for S1=1:number
                [NMI,MI,MIxy,Entropyx,Entropyy,Entropyxy]=MIEtropy(GIGICMatCO(S,:),GIGICMatCO(S1,:),binsPara);
                GIGMutuInfo(S,S1)=MI;
                GIGNMutuInfo(S,S1)=NMI;
            end
        end
        
        GIGMuIn=(sum(sum(triu(GIGMutuInfo)))-sum(diag(triu(GIGMutuInfo))))/((number*number-number)/2);
        GIGNMuIn=(sum(sum(triu(GIGNMutuInfo)))-sum(diag(triu(GIGNMutuInfo))))/((number*number-number)/2);
        
        SumGIGKurt(i)=sum(GIGKurt(i,:),2);
        SumGIGNege(i)=sum(GIGNege(i,:),2);
        GIGMI(i)=GIGMuIn;
        GIGNMI(i)=GIGNMuIn;
                      
        GIGICMatCOZPlMask=zeros(size(GIGICMatCO,1),M*N*L);
        RealSouInMaskZCOPlMask=zeros(size(GIGICMatCO,1),M*N*L);%z scored GT IC (after reordering) plus mask.
        h=1;
        for K=1:M*N*L
            if MaskVec(K)==0
                GIGICMatCOZPlMask(:,K)=0;
                RealSouInMaskZCOPlMask(:,K)=0;
            else
                GIGICMatCOZPlMask(:,K)=GIGICMatCO(:,h);
                RealSouInMaskZCOPlMask(:,K)=RealSouInMaskZCO(:,h);
                h=h+1;
            end
        end
        %if i==1||i==3||i==7;
        h01=figure;
        for k=1:min(GTICnum,ICnum)
            subplot(min(GTICnum,ICnum),5,5*k-3);
            imshow(reshape(GIGICMatCOZPlMask(k,:),M,N),[]);
            tmp = sprintf('%.2f', IndiIC2ReSm(k));
            title(['\bf {GIG-ICA IC} ',int2str(k),' (',tmp,')'],'fontsize',8);
            
            
            subplot(min(GTICnum,ICnum),5,5*k-2);
            plot(GIGTCMatZCO(:,k));
            tmp = sprintf('%.2f', IndiTC2ReTc(k));
            title(['\bf {GIG-ICA TC} ',int2str(k),' (',tmp,')'],'fontsize',8);
            xlim([0 timepoints]);
            ylim([-4 4]);
            
            subplot(min(GTICnum,ICnum),5,5*k-1);
            imshow(reshape(RealSouInMaskZCOPlMask(k,:),M,N),[]);
            title(['\bf {GT IC} ',int2str(k)],'fontSize',8);
            subplot(min(GTICnum,ICnum),5,5*k);
            plot(RealTCMatZCO(:,k));
            title(['\bf {GT TC} ',int2str(k)],'fontSize',8);
            xlim([0 timepoints]);
            ylim([-4 4]);
        end
        
        
        mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ICnum',num2str(ICnum)));
        mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ICnum',num2str(ICnum),'\sb',num2str(i)));
        cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ICnum',num2str(ICnum),'\sb',num2str(i)));
        saveas(h01,'GIGICTC.fig');
        saveas(h01,'GIGICTC.png');
        save('GIGICMat','GIGICMat');
        save('GIGTCMat','GIGTCMat');
        
        cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');
        %save individual ICs for later reliability evaluation
        GIGICALL((i*number-(number-1)):(number*i),:)=GIGICMatCO;
        GTICALL((i*number-(number-1)):(number*i),:)=RealSouInMaskZCO;
        %save individual TCs for later reliability evaluation
        GIGTCALL(:,(i*number-(number-1)):(number*i))=GIGTCMatZCO;
        GTTCALL(:,(i*number-(number-1)):(number*i))=RealTCMatZCO;
        cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');
    end
     
    
    
    cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');
    h5=figure;
    set (gcf,'Position',[100,100,600,500], 'color','w')
    b_1=boxplotCsub(SMS2,1,['*'],1,1,'r',2,1,true,[1 4],1.3,0,'ks');
    set(gcf,'color','white')
    yrange=size(GICsN2,1)+0.5;
    axis([0.5 yrange 0 1])
    set(gca,'ygrid','on');
    set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',16);
    xlabel('ICs','Fontsize',20,'Fontweight','Bold','Fontsize',20);
    ylabel('Spatial accuracy','Fontsize',20,'Fontweight','Bold','Fontsize',20);
    title('GIG spatial accuracy','Fontsize',20,'Fontweight','Bold');
    % hold on;
    % for i=1:7
    %     %X=[xaixs(i)+0.5,xaixs(i)+0.5];
    %     X=[i+0.5,i+0.5];
    %     Y=[0,1];
    %     plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
    % end
    
    
    %boxplot temporal accuracy
    h6=figure;
    set (gcf,'Position',[100,100,600,500], 'color','w')
    b_1=boxplotCsub(TCS2,1,['*'],1,1,'r',2,1,true,[1 4],1.3,0,'ks');
    set(gcf,'color','white')
    axis([0.5 yrange 0 1])
    set(gca,'ygrid','on');
    set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',16);
    xlabel('ICs','Fontsize',20,'Fontweight','Bold','Fontsize',20);
    ylabel('Temporal accuracy','Fontsize',20,'Fontweight','Bold','Fontsize',20);
    title('GIG temporal accuracy','Fontsize',20,'Fontweight','Bold');
    % hold on;
    % for i=1:7
    %     %X=[xaixs(i)+0.5,xaixs(i)+0.5];
    %     X=[i+0.5,i+0.5];
    %     Y=[0,1];
    %     plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
    % end
    
    fprintf(strcat('Mean spatial accuracy of GIG method is'));
    MeanSpaAccGIG=mean(MeanSMSG2)
    fprintf(strcat('Mean temporal accuracy of GIG method is'));
    MeanTemAccGIG=mean(MeanTCSG2)
    
    MeanSMSG2DifICNum(:,EstiICNum)=MeanSMSG2';
    MeanTCSG2DifICNum(:,EstiICNum)=MeanTCSG2';
    
    GIGKurtDifICNum(:,EstiICNum)=SumGIGKurt;
    GIGNegeDifICNum(:,EstiICNum)=SumGIGNege;
    GIGMIDifICNum(:,EstiICNum)=GIGMI;
    GIGNMIDifICNum(:,EstiICNum)=GIGNMI;
    
    GTKurtDifICNum(:,EstiICNum)=SumGTKurt;
    GTNegeDifICNum(:,EstiICNum)=SumGTNege;
    GTMIDifICNum(:,EstiICNum)=GTMI;
    GTNMIDifICNum(:,EstiICNum)=GTNMI;
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ICnum',num2str(ICnum),'\Accuracy'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ICnum',num2str(ICnum),'\Accuracy'));
    saveas(h5,strcat('GIGSpaAcc.fig'));
    saveas(h5,strcat('GIGSpaAcc.png'));
    saveas(h6,strcat('GIGTemAcc.fig'));
    saveas(h6,strcat('GIGTemAcc.png'));
    save('MeanSpaAccGIG','MeanSpaAccGIG');
    save('MeanTemAccGIG','MeanTemAccGIG');
    xlswrite('MeanSpaAccGIG',MeanSpaAccGIG);
    xlswrite('MeanTemAccGIG',MeanTemAccGIG);
    
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ICnum',num2str(ICnum)));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ICnum',num2str(ICnum)));
    save('GIGICALL','GIGICALL');
    save('GIGTCALL','GIGTCALL');
    save('GTICALL','GTICALL');
    save('GTTCALL','GTTCALL');
    
    
    cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');
    %show the reliability of different methods
    GTICALLs=[];
    for k=1:sbnum
        for l=1:number
            GTICALLs(sbnum*(l-1)+k,:)=GTICALL(number*(k-1)+l,:);
        end
    end
    GTSimMatALLs=[];
    for j=1:sbnum*number
        for k=1:sbnum*number
            GTSimMatALLs(j,k)=abs(corr(GTICALLs(j,:)',GTICALLs(k,:)'));
        end
    end
    GTSimMatALLsG=GTSimMatALLs;
    for ICorder=1:number
        for i=1+((ICorder-1)*sbnum):sbnum+((ICorder-1)*sbnum)
            for j=sbnum+1+((ICorder-1)*sbnum):sbnum*number
                GTSimMatALLsG(i,j)=NaN;
            end
        end
    end
    
    figure;
    [X,Y]=meshgrid(1:1:sbnum*number, 1:1:sbnum*number);
    h=pcolor(X,Y,GTSimMatALLsG);
    caxis([0,1]);
    %colorbar('horiz');
    colormap(jet(64));
    grid off;
    axis ij
    axis square
    set(h,'LineStyle','none')
    set(gca,'FontName','Times New Roman','Fontsize',26,'Fontweight','Bold')
    title(['\bf {GT}' ],'Fontsize',26,'Fontweight','Bold');
    
    %axis([0.5 124.5 0.5 124.5])
    set(gca,'XTick',[sbnum/2:sbnum:sbnum*number],'Fontweight','Bold','Fontsize',20);
    set(gca,'YTick',[sbnum/2:sbnum:sbnum*number],'Fontweight','Bold','Fontsize',20);
    set(gca,'box','off')
    set(gcf,'paperunits','centimeters');
    set(gcf,'papersize',[3 3]);
    set(gca,'XTickLabel',{'1','2','3','4','5','6','7','8'},'Fontweight','Bold','Fontsize',26);
    set(gca,'YTickLabel',{'1','2','3','4','5','6','7','8'},'Fontweight','Bold','Fontsize',26);
    
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ICnum',num2str(ICnum),'\Reliability'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ICnum',num2str(ICnum),'\Reliability'));
    saveas(h,strcat('GTCorrMatrix.fig'));
    print('-dtiff','-r500',strcat('GTCorrMatrix.tif'));
    
    GTMat=[];
    GTVecSubSimAllIC=[];
    %boxplot the similarity
    for k=1:number
        GTSubSimMat=GTSimMatALLs(sbnum*(k-1)+1:sbnum*k,sbnum*(k-1)+1:sbnum*k);
        GTTriSub=triu(GTSubSimMat,1);
        GTVecSubSim=reshape(GTTriSub,1,sbnum*sbnum);
        % MeanSimIC2(k)=mean(VecSubSim2);
        % StdSimIC2(k)=std(VecSubSim2);
        GTMat(:,k)=GTVecSubSim';
        GTVecSubSimAllIC=[GTVecSubSimAllIC,GTVecSubSim];
    end
    [m,n]=size(GTVecSubSimAllIC);
    GTVecSubSimAllICg=[GTVecSubSimAllIC,zeros(1,max(ICnumMat)*sbnum*sbnum-n)];
    GTVecSubSimAllICDifICNum(:,EstiICNum)=GTVecSubSimAllICg';

    
    GTMatG=GTMat;
    GTMatGG=GTMat;
    for i=1:sbnum*sbnum
        for j=1:number
            if GTMat(i,j)==1
                GTMatG(i,j)=NaN;
                GTMatGG(i,j)=0;
            end
            if GTMat(i,j)==0
                GTMatG(i,j)=NaN;
            end;
        end
    end
    GTEachICMeanCorr=zeros(1,number);
    for j=1:number
        GTEachICMeanCorr(1,j)=sum(GTMatGG(:,j))/size(find(GTMatGG(:,j)~=0),1);
    end
    
    
    cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');
    hp=figure;
    %set (gcf,'Position',[0,0,400,1200], 'color','w')
    set (gcf,'Position',[0,0,1200,400], 'color','w')
    b_1=boxplotCsub(GTMatG,1,['*'],1,1,'b',2,2,true,[1 1],1.3,0,'ks');
    Hla=cell(1,number);
    for i=1:size(Hla,2)
        Hla{i}=i;
    end
    set(gcf,'color','white')
    a=number+0.5;
    axis([0.5 a 0 1])
    set(gca,'ygrid','on');
    set(gca,'YTick',[0:0.2:2],'Fontweight','Bold','Fontsize',20);
    xlabel('IC ID','Fontweight','Bold','Fontsize',20);
    ylabel('Absolute value of correlation','Fontweight','Bold','Fontsize',20);
    set(gca,'XTickLabel',Hla,'Fontweight','Bold','Fontsize',20);%,
    title('GT','Fontsize',20,'Fontweight','Bold');
    
    hold on;
    for i=1:number-1
        %X=[xaixs(i)+0.5,xaixs(i)+0.5];
        X=[i+0.5,i+0.5];
        Y=[0,1];
        plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
    end
    % az = -90;
    % el = 90;
    % view(az, el);
    
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ICnum',num2str(ICnum),'\Reliability'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ICnum',num2str(ICnum),'\Reliability'));
    saveas(hp,'GTEachICReliability.png');
    saveas(hp,'GTEachICReliability.fig');   
    
    a=1:number;
    Label=[];
    for i=1:sbnum
        Label=[Label,a];
    end
    figure;
    GTAllFea2D = tsne(GTICALL, Label);
    hP=gcf;
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ICnum',num2str(ICnum),'\Reliability'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ICnum',num2str(ICnum),'\Reliability'));
    
    saveas(hP,'GTProjectionOfAllsubAllIC.tif');
    saveas(hP,'GTProjectionOfAllsubAllIC.fig');
    save('GTAllFea2D','GTAllFea2D');
    save('GTICALL','GTICALL');
    save('GTTCALL','GTTCALL');
     figure;
    GTAllFea2DG=zeros(size(GTAllFea2D));
    for k=1:sbnum
        for l=1:number
            GTAllFea2DG(sbnum*(l-1)+k,:)=GTAllFea2D(number*(k-1)+l,:);
        end
    end
    hPSpaG=figure;
    if number==7
        for i=1:size(GTAllFea2DG,1)
            if i<sbnum+1
                scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'r','filled');
                hold on;
            else if i<sbnum*2+1
                    scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'b','filled');
                    hold on;
                else if i<sbnum*3+1
                        scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'c','filled');
                        hold on;
                    else if i<sbnum*4+1
                            scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'g','filled');
                            hold on;
                        else if i<sbnum*5+1
                                scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'k','filled');
                                hold on;
                            else if i<sbnum*6+1
                                    scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'y','filled');
                                    hold on;
                                else if i<sbnum*7+1
                                        scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'m','filled');
                                        hold on;
                                        
                                    end
                                end
                            end
                        end
                    end
                end
            end
        end
        title('t-SNE projection');
        
    else if number==8
            for i=1:size(GTAllFea2DG,1)
                if i<sbnum+1
                    scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'r','filled');
                    hold on;
                else if i<sbnum*2+1
                        scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'b','filled');
                        hold on;
                    else if i<sbnum*3+1
                            scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'c','filled');
                            hold on;
                        else if i<sbnum*4+1
                                scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'g','filled');
                                hold on;
                            else if i<sbnum*5+1
                                    scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'k','filled');
                                    hold on;
                                else if i<sbnum*6+1
                                        scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'y','filled');
                                        hold on;
                                    else if i<sbnum*7+1
                                            scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'m','filled');
                                            hold on;
                                        else if i<sbnum*8+1
                                                scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,[0.5 0.3 1],'filled');
                                                hold on;
                                            end
                                        end
                                    end
                                end
                            end
                        end
                    end
                end
            end
            title('t-SNE projection');
        end
    end
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ICnum',num2str(ICnum),'\Reliability'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ICnum',num2str(ICnum),'\Reliability'));
    
    saveas(hPSpaG,'GTProjectionOfAllsubAllICOwn.tif');
    saveas(hPSpaG,'GTProjectionOfAllsubAllICOwn.fig');
    close all;
    GIGICALLs=[];
    for k=1:sbnum
        for l=1:number
            GIGICALLs(sbnum*(l-1)+k,:)=GIGICALL(number*(k-1)+l,:);
        end
    end
    GIGSimMatALLs=[];
    for j=1:sbnum*number
        for k=1:sbnum*number
            GIGSimMatALLs(j,k)=abs(corr(GIGICALLs(j,:)',GIGICALLs(k,:)'));
        end
    end
    GIGSimMatALLsG=GIGSimMatALLs;
    for ICorder=1:number
        for i=1+((ICorder-1)*sbnum):sbnum+((ICorder-1)*sbnum)
            for j=sbnum+1+((ICorder-1)*sbnum):sbnum*number
                GIGSimMatALLsG(i,j)=NaN;
            end
        end
    end
    
    figure;
    [X,Y]=meshgrid(1:1:sbnum*number, 1:1:sbnum*number);
    h=pcolor(X,Y,GIGSimMatALLsG);
    caxis([0,1]);
    %colorbar('horiz');
    colormap(jet(64));
    grid off;
    axis ij
    axis square
    set(h,'LineStyle','none')
    set(gca,'FontName','Times New Roman','Fontsize',26,'Fontweight','Bold')
    title(['\bf {GIG-ICA }' ],'Fontsize',26,'Fontweight','Bold');
    
    %axis([0.5 124.5 0.5 124.5])
    set(gca,'XTick',[sbnum/2:sbnum:sbnum*number],'Fontweight','Bold','Fontsize',20);
    set(gca,'YTick',[sbnum/2:sbnum:sbnum*number],'Fontweight','Bold','Fontsize',20);
    set(gca,'box','off')
    set(gcf,'paperunits','centimeters');
    set(gcf,'papersize',[3 3]);
    set(gca,'XTickLabel',{'1','2','3','4','5','6','7','8'},'Fontweight','Bold','Fontsize',26);
    set(gca,'YTickLabel',{'1','2','3','4','5','6','7','8'},'Fontweight','Bold','Fontsize',26);
    
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ICnum',num2str(ICnum),'\Reliability'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ICnum',num2str(ICnum),'\Reliability'));
    saveas(h,strcat('GIGCorrMatrix.fig'));
    print('-dtiff','-r500',strcat('GIGCorrMatrix.tif'));
    
    GIGMat=[];
    GIGVecSubSimAllIC=[];
    %boxplot the similarity
    for k=1:number
        GIGSubSimMat=GIGSimMatALLs(sbnum*(k-1)+1:sbnum*k,sbnum*(k-1)+1:sbnum*k);
        GIGTriSub=triu(GIGSubSimMat,1);
        GIGVecSubSim=reshape(GIGTriSub,1,sbnum*sbnum);
        % MeanSimIC2(k)=mean(VecSubSim2);
        % StdSimIC2(k)=std(VecSubSim2);
        GIGMat(:,k)=GIGVecSubSim';
        GIGVecSubSimAllIC=[GIGVecSubSimAllIC,GIGVecSubSim];
    end
    [m,n]=size(GIGVecSubSimAllIC);
    GIGVecSubSimAllICg=[GIGVecSubSimAllIC,zeros(1,max(ICnumMat)*sbnum*sbnum-n)];
    GIGVecSubSimAllICDifICNum(:,EstiICNum)=GIGVecSubSimAllICg';

    
    GIGMatG=GIGMat;
    GIGMatGG=GIGMat;
    for i=1:sbnum*sbnum
        for j=1:number
            if GIGMat(i,j)==1
                GIGMatG(i,j)=NaN;
                GIGMatGG(i,j)=0;
            end
            if GIGMat(i,j)==0
                GIGMatG(i,j)=NaN;
            end;
        end
    end
    GIGEachICMeanCorr=zeros(1,number);
    for j=1:number
        GIGEachICMeanCorr(1,j)=sum(GIGMatGG(:,j))/size(find(GIGMatGG(:,j)~=0),1);
    end
    
    
    cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');
    hp=figure;
    %set (gcf,'Position',[0,0,400,1200], 'color','w')
    set (gcf,'Position',[0,0,1200,400], 'color','w')
    b_1=boxplotCsub(GIGMatG,1,['*'],1,1,'b',2,2,true,[1 1],1.3,0,'ks');
    Hla=cell(1,number);
    for i=1:size(Hla,2)
        Hla{i}=i;
    end
    set(gcf,'color','white')
    a=number+0.5;
    axis([0.5 a 0 1])
    set(gca,'ygrid','on');
    set(gca,'YTick',[0:0.2:2],'Fontweight','Bold','Fontsize',20);
    xlabel('IC ID','Fontweight','Bold','Fontsize',20);
    ylabel('Absolute value of correlation','Fontweight','Bold','Fontsize',20);
    set(gca,'XTickLabel',Hla,'Fontweight','Bold','Fontsize',20);%,
    title('GIG-ICA','Fontsize',20,'Fontweight','Bold');
    
    hold on;
    for i=1:number-1
        %X=[xaixs(i)+0.5,xaixs(i)+0.5];
        X=[i+0.5,i+0.5];
        Y=[0,1];
        plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
    end
    % az = -90;
    % el = 90;
    % view(az, el);
    
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ICnum',num2str(ICnum),'\Reliability'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ICnum',num2str(ICnum),'\Reliability'));
    saveas(hp,'GIGEachICReliability.png');
    saveas(hp,'GIGEachICReliability.fig');
    
    figure;
    GIGAllFea2D = tsne(GIGICALL, Label);
    hP=gcf;
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ICnum',num2str(ICnum),'\Reliability'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ICnum',num2str(ICnum),'\Reliability'));
    
    saveas(hP,'GIGProjectionOfAllsubAllIC.tif');
    saveas(hP,'GIGProjectionOfAllsubAllIC.fig');
    save('GIGAllFea2D','GIGAllFea2D');
     figure;
    GIGAllFea2DG=zeros(size(GIGAllFea2D));
    for k=1:sbnum
        for l=1:number
            GIGAllFea2DG(sbnum*(l-1)+k,:)=GIGAllFea2D(number*(k-1)+l,:);
        end
    end
    hPSpaG=figure;
    if number==7
        for i=1:size(GIGAllFea2DG,1)
            if i<sbnum+1
                scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'r','filled');
                hold on;
            else if i<sbnum*2+1
                    scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'b','filled');
                    hold on;
                else if i<sbnum*3+1
                        scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'c','filled');
                        hold on;
                    else if i<sbnum*4+1
                            scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'g','filled');
                            hold on;
                        else if i<sbnum*5+1
                                scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'k','filled');
                                hold on;
                            else if i<sbnum*6+1
                                    scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'y','filled');
                                    hold on;
                                else if i<sbnum*7+1
                                        scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'m','filled');
                                        hold on;
                                        
                                    end
                                end
                            end
                        end
                    end
                end
            end
        end
        title('t-SNE projection');
        
    else if number==8
            for i=1:size(GIGAllFea2DG,1)
                if i<sbnum+1
                    scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'r','filled');
                    hold on;
                else if i<sbnum*2+1
                        scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'b','filled');
                        hold on;
                    else if i<sbnum*3+1
                            scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'c','filled');
                            hold on;
                        else if i<sbnum*4+1
                                scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'g','filled');
                                hold on;
                            else if i<sbnum*5+1
                                    scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'k','filled');
                                    hold on;
                                else if i<sbnum*6+1
                                        scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'y','filled');
                                        hold on;
                                    else if i<sbnum*7+1
                                            scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'m','filled');
                                            hold on;
                                        else if i<sbnum*8+1
                                                scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,[0.5 0.3 1],'filled');
                                                hold on;
                                            end
                                        end
                                    end
                                end
                            end
                        end
                    end
                end
            end
            title('t-SNE projection');
        end
    end
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareGIGGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ICnum',num2str(ICnum),'\Reliability'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareGIGGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ICnum',num2str(ICnum),'\Reliability'));
    
    saveas(hPSpaG,'GIGProjectionOfAllsubAllICOwn.tif');
    saveas(hPSpaG,'GIGProjectionOfAllsubAllICOwn.fig');

    
    %show the independence of different methods
    h7=figure;
    set(gcf,'Position',[100,100,600,500], 'color','w')
    bar([GTNMI',GIGNMI'],'group');
    
    h8=figure;
    set(gcf,'Position',[100,100,600,500], 'color','w')
    bar([SumGTKurt', SumGIGKurt'],'group');
    
    h9=figure;
    set(gcf,'Position',[100,100,600,500], 'color','w')
    bar([SumGTNege', SumGIGNege'],'group');
    
    h10=figure;
    set(gcf,'Position',[100,100,600,500], 'color','w')
    bar([GTMI',GIGMI'],'group');
    
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ICnum',num2str(ICnum),'\Independence'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ICnum',num2str(ICnum),'\Independence'));
    
    saveas(h7,strcat('NMI.fig'));
    saveas(h7,strcat('NMI.png'));
    saveas(h8,strcat('Kurt.fig'));
    saveas(h8,strcat('Kurt.png'));
    saveas(h9,strcat('Nege.fig'));
    saveas(h9,strcat('Nege.png'));
    saveas(h10,strcat('MI.fig'));
    saveas(h10,strcat('MI.png'));
      
    GTReliaDifICNum(:,EstiICNum)=mean(GTEachICMeanCorr);
    GIGReliaDifICNum(:,EstiICNum)=mean(GIGEachICMeanCorr);   
    cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');

end


%show the accuracy of IVA
h1=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(MeanSMSG2DifICNum,1,['*'],1,1,'r',2,1,true,[1 1],1.3,0,'ks');
set(gcf,'color','white')
axis([0.5 3.5 0.3 1])
set(gca,'ygrid','on');
set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',24);
xlabel('Number of ICs used in compuation','Fontsize',24,'Fontweight','Bold','Fontsize',24);
ylabel('Spatial accuracy','Fontsize',24,'Fontweight','Bold','Fontsize',24);
set(gca,'XTickLabel',{'6','8','10'},'Fontweight','Bold','Fontsize',24);%,
title('(A)','Fontsize',24,'Fontweight','Bold');
hold on;
for i=1:3
    X=[i+0.5,i+0.5];
    Y=[0,1];
    plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
end
legend([b_1(8,1)],{'GIG-ICA'},3)

%boxplot spatial accuracy under different GIGGroupPCnum
h2=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(MeanTCSG2DifICNum,1,['*'],1,1,'r',2,1,true,[1 1],1.3,0,'ks');
set(gcf,'color','white')
axis([0.5 3.5 0.3 1])
set(gca,'ygrid','on');
set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',24);
xlabel('Number of ICs used in compuation','Fontsize',24,'Fontweight','Bold','Fontsize',24);
ylabel('Temporal accuracy','Fontsize',24,'Fontweight','Bold','Fontsize',24);
set(gca,'XTickLabel',{'6','8','10'},'Fontweight','Bold','Fontsize',24);%,
title('(B)','Fontsize',24,'Fontweight','Bold');
hold on;
for i=1:3
    X=[i+0.5,i+0.5];
    Y=[0,1];
    plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
end
legend([b_1(8,1)],{'GIG-ICA'},3)

cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date)));

 mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ResultSum\Accuracy'));
cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ResultSum\Accuracy'));   
saveas(h1,'SpatialAccuracySummary.fig');
saveas(h1,'SpatialAccuracySummary.png');
saveas(h2,'TemporalAccuracySummary.fig');
saveas(h2,'TemporalAccuracySummary.png');
save('MeanSMSG1DifICNum','MeanSMSG1DifICNum');
save('MeanTCSG1DifICNum','MeanTCSG1DifICNum');

cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');

h3=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(GTKurtDifICNum,1,['*'],1,1,'m',2,1,true,[1 2],1.3,0,'ks');
b_2=boxplotCsub(GIGKurtDifICNum,1,['*'],1,1,'r',2,1,true,[2 2],1.3,0,'ks');

set(gcf,'color','white')
axis([0.5 3.5 0 100])
set(gca,'ygrid','on');
%set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',24);
xlabel('Number of ICs used in compuation','Fontsize',24,'Fontweight','Bold','Fontsize',24);
ylabel('Kurtosis','Fontsize',24,'Fontweight','Bold','Fontsize',24);
set(gca,'XTickLabel',{'6','8','10'},'Fontweight','Bold','Fontsize',24);%,

title('(A)','Fontsize',24,'Fontweight','Bold');
hold on;
for i=1:3
    X=[i+0.5,i+0.5];
    Y=[0,1];
    plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
end
legend([b_1(8,1) b_2(8,1)],{'GT','GIG-ICA'},3)

h4=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(GTNegeDifICNum,1,['*'],1,1,'m',2,1,true,[1 2],1.3,0,'ks');
b_2=boxplotCsub(GIGNegeDifICNum,1,['*'],1,1,'r',2,1,true,[2 2],1.3,0,'ks');

set(gcf,'color','white')
axis([0.5 3.5 0 0.2])
set(gca,'ygrid','on');
%set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',24);
xlabel('Number of ICs used in compuation','Fontsize',24,'Fontweight','Bold','Fontsize',24);
ylabel('Negentropy','Fontsize',24,'Fontweight','Bold','Fontsize',24);
set(gca,'XTickLabel',{'6','8','10'},'Fontweight','Bold','Fontsize',24);%,

title('(B)','Fontsize',24,'Fontweight','Bold');
hold on;
for i=1:3
    X=[i+0.5,i+0.5];
    Y=[0,1];
    plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
end
legend([b_1(8,1) b_2(8,1)],{'GT','GIG-ICA'},3) 

h5=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(GTMIDifICNum,1,['*'],1,1,'m',2,1,true,[1 2],1.3,0,'ks');
b_2=boxplotCsub(GIGMIDifICNum,1,['*'],1,1,'r',2,1,true,[2 2],1.3,0,'ks');

set(gcf,'color','white')
axis([0.5 3.5 0 0.2])
set(gca,'ygrid','on');
%set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',24);
xlabel('Number of ICs used in compuation','Fontsize',24,'Fontweight','Bold','Fontsize',24);
ylabel('Mutual information','Fontsize',24,'Fontweight','Bold','Fontsize',24);
set(gca,'XTickLabel',{'6','8','10'},'Fontweight','Bold','Fontsize',24);%,
title('(C)','Fontsize',24,'Fontweight','Bold');

hold on;
for i=1:3
    X=[i+0.5,i+0.5];
    Y=[0,1];
    plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
end
legend([b_1(8,1) b_2(8,1)],{'GT','GIG-ICA'},3)

h6=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(GTNMIDifICNum,1,['*'],1,1,'m',2,1,true,[1 2],1.3,0,'ks');
b_2=boxplotCsub(GIGNMIDifICNum,1,['*'],1,1,'r',2,1,true,[2 2],1.3,0,'ks');

set(gcf,'color','white')
axis([0.5 3.5 0 0.2])
set(gca,'ygrid','on');
%set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',24);
xlabel('Number of ICs used in compuation','Fontsize',24,'Fontweight','Bold','Fontsize',24);
ylabel('Normalized mutual information','Fontsize',24,'Fontweight','Bold','Fontsize',24);
set(gca,'XTickLabel',{'6','8','10'},'Fontweight','Bold','Fontsize',24);%,
title('(D)','Fontsize',24,'Fontweight','Bold');
hold on;
for i=1:3
    X=[i+0.5,i+0.5];
    Y=[0,1];
    plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
end
legend([b_1(8,1) b_2(8,1)],{'GT','GIG-ICA'},3)

mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ResultSum\Independence'));
cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ResultSum\Independence'));
saveas(h3,'KurtSummary.fig');
saveas(h3,'KurtSummary.png');
saveas(h4,'NegeSummary.fig');
saveas(h4,'NegeSummary.png');
saveas(h5,'MISummary.fig');
saveas(h5,'MISummary.png');
saveas(h6,'NMISummary.fig');
saveas(h6,'NMISummary.png');

save('GTKurtDifICNum','GTKurtDifICNum');
save('GIGKurtDifICNum','GIGKurtDifICNum');

save('GTNegeDifICNum','GTNegeDifICNum');
save('GIGNegeDifICNum','GIGNegeDifICNum');

save('GTMIDifICNum','GTMIDifICNum');
save('GIGMIDifICNum','GIGMIDifICNum');

save('GTNMIDifICNum','GTNMIDifICNum');
save('GIGNMIDifICNum','GIGNMIDifICNum');
cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');

%%
%show the reliability under Number of ICs used in compuation
    for i=1:size(GTVecSubSimAllICDifICNum,1)
        for j=1:size(GTVecSubSimAllICDifICNum,2)
            if GTVecSubSimAllICDifICNum(i,j)==0
                GTVecSubSimAllICDifICNum(i,j)=NaN;
            end
            if GTVecSubSimAllICDifICNum(i,j)==1
                GTVecSubSimAllICDifICNum(i,j)=NaN;
            end
        end
    end 
         
   for i=1:size(GIGVecSubSimAllICDifICNum,1)
        for j=1:size(GIGVecSubSimAllICDifICNum,2)
            if GIGVecSubSimAllICDifICNum(i,j)==0
                GIGVecSubSimAllICDifICNum(i,j)=NaN;
            end
            if GIGVecSubSimAllICDifICNum(i,j)==1
                GIGVecSubSimAllICDifICNum(i,j)=NaN;
            end
        end
    end
h7=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(GTVecSubSimAllICDifICNum,1,['*'],1,1,'m',2,1,true,[1 3],1.3,0,'ks');
b_2=boxplotCsub(GIGVecSubSimAllICDifICNum,1,['*'],1,1,'r',2,1,true,[2 3],1.3,0,'ks');

set(gcf,'color','white')
axis([0.5 3.5 0 1])
set(gca,'ygrid','on');
set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',24);
xlabel('Number of ICs used in compuation','Fontsize',24,'Fontweight','Bold','Fontsize',24);
ylabel('Reliability','Fontsize',24,'Fontweight','Bold','Fontsize',24);
set(gca,'XTickLabel',{'6','8','10'},'Fontweight','Bold','Fontsize',24);%,

%title('(D)','Fontsize',24,'Fontweight','Bold');
hold on;
for i=1:3
    X=[i+0.5,i+0.5];
    Y=[0,1];
    plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
end
legend([b_1(8,1) b_2(8,1) ],{'GT','GIG-ICA'},3)

h8=figure;
bar([GTReliaDifICNum;GIGReliaDifICNum]','group');
mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ResultSum\Reliability'));
cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ResultSum\Reliability'));
saveas(h7,'ReliabilitySummary.fig');
saveas(h7,'ReliabilitySummary.png');
saveas(h8,'ReliabilitySummaryBar.fig');
saveas(h8,'ReliabilitySummaryBar.png');

save('GTVecSubSimAllICDifICNum','GTVecSubSimAllICDifICNum');
save('GIGVecSubSimAllICDifICNum','GIGVecSubSimAllICDifICNum');

cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');

%%
%match the results from IVA, GIG-ICA and the GT source/TC
MeanSMSG1DifICNum=[];
MeanTCSG1DifICNum=[];
MeanSMSG2DifICNum=[];
MeanTCSG2DifICNum=[];

IVAKurtDifICNum=[];
IVANegeDifICNum=[];
IVAMIDifICNum=[];
IVANMIDifICNum=[];

GTKurtDifICNum=[];
GTNegeDifICNum=[];
GTMIDifICNum=[];
GTNMIDifICNum=[];

GIGKurtDifICNum=[];
GIGNegeDifICNum=[];
GIGMIDifICNum=[];
GIGNMIDifICNum=[];

for EstiICNum=1:3
    ICnum=ICnumMat(EstiICNum);%IC number used in computation
    IndiIVAICMat=[];
    IndiIVATCMat=[];
    for i=1:sbnum
        %load IVA results
        load(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ICnum',num2str(ICnum),'\sb',num2str(i),'\IVAICMat.mat'));
        IndiIVAICMat(:,:,i)=IVAICMat;
        load(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\IVA\ICnum',num2str(ICnum),'\sb',num2str(i),'\IVATCMat.mat'));
        IndiIVATCMat(:,:,i)=IVATCMat;
    end
    MeanIndiIVAICMat=mean(IndiIVAICMat,3);
    
    %match the results of IVA and
    SimMeICN1Tem=corr(MeanIndiIVAICMat',TemICInMask');%
    %following is another matching method
    MatchV1=[];
    MatchH1=[];
    MatchL1=[];
    DirectioN1GB=[];
    SimMeICN1TemG=SimMeICN1Tem;
    for i=1:min(size(SimMeICN1Tem,1),size(SimMeICN1Tem,2))
        MaxValue=max(max(abs(SimMeICN1TemG)));
        MatchV1=[MatchV1,MaxValue];
        if size(find(SimMeICN1TemG==MaxValue),1)
            P=find(SimMeICN1TemG==MaxValue);
            DirectioN1GB(i)=1;
        else if size(find(SimMeICN1TemG==-MaxValue),1)
                P=find(SimMeICN1TemG==-MaxValue);
                DirectioN1GB(i)=-1;
            end
        end
        
        Lie=ceil(P/size(SimMeICN1Tem,1));
        Hang=mod(P,size(SimMeICN1Tem,1));
        if Hang==0
            Hang=size(SimMeICN1Tem,1);
        end
        MatchH1=[MatchH1,Hang];
        MatchL1=[MatchL1,Lie];
        SimMeICN1TemG(Hang,:)=0;
        SimMeICN1TemG(:,Lie)=0;
    end
    
    %load GIG results
    IndiGIGICMat=[];
    IndiGIGTCMat=[];
    for i=1:sbnum
        %load GIG results
        load(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ICnum',num2str(ICnum),'\sb',num2str(i),'\GIGICMat.mat'));
        IndiGIGICMat(:,:,i)=GIGICMat;
        load(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\GIG\ICnum',num2str(ICnum),'\sb',num2str(i),'\GIGTCMat.mat'));
        IndiGIGTCMat(:,:,i)=GIGTCMat;
    end
    MeanIndiGIGICMat=mean(IndiGIGICMat,3);
    
    %match the results of GIG and
    SimMeICN2Tem=corr(MeanIndiGIGICMat',TemICInMask');%
    %following is another matching method
    MatchV2=[];
    MatchH2=[];
    MatchL2=[];
    DirectioN2GB=[];
    SimMeICN2TemG=SimMeICN2Tem;
    for i=1:min(size(SimMeICN2Tem,1),size(SimMeICN2Tem,2))
        MaxValue=max(max(abs(SimMeICN2TemG)));
        MatchV2=[MatchV2,MaxValue];
        if size(find(SimMeICN2TemG==MaxValue),1)
            P=find(SimMeICN2TemG==MaxValue);
            DirectioN2GB(i)=1;
        else if size(find(SimMeICN2TemG==-MaxValue),1)
                P=find(SimMeICN2TemG==-MaxValue);
                DirectioN1GB(i)=-1;
            end
        end   
        Lie=ceil(P/size(SimMeICN2Tem,1));
        Hang=mod(P,size(SimMeICN2Tem,1));
        if Hang==0
            Hang=size(SimMeICN2Tem,1);
        end
        MatchH2=[MatchH2,Hang];
        MatchL2=[MatchL2,Lie];
        SimMeICN2TemG(Hang,:)=0;
        SimMeICN2TemG(:,Lie)=0;
    end
    
    [a1,b1]=sort(MatchL1);
    [a2,b2]=sort(MatchL2);

    if a1==a2
        OrderGT=a1;
        OrderIVA=MatchH1(b1);
        OrderGIG=MatchH2(b2);
        number=size(OrderGIG,2);
    else
        fprintf('IVA and GIG generated differnet ICs');
        ComIC=intersect(MatchL1,MatchL2);
        OrderIVA=[];
        OrderGIG=[];
        for o=1:size(ComIC,2)
            [c1,d1]=find(MatchL1==ComIC(o));
            OrderIVA(o)=MatchH1(d1);
            [c2,d2]=find(MatchL2==ComIC(o));
            OrderGIG(o)=MatchH2(d2);
        end
        OrderGT=ComIC;
        number=size(ComIC,2);
    end
    
    IVAICALL=[];
    GIGICALL=[];
    GTICALL=[];
    SMS1=[];
    TCS1=[];      
    SMS2=[];
    TCS2=[];
    
    MeanSMSG1=[];
    MeanTCSG1=[];
    MeanSMSG2=[];
    MeanTCSG2=[];
    for i=1:sbnum
         
        if i<10
            strzero='00';
        else if i>9&&i<100
                strzero='0';
            end
        end
        
        load (strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\',num2str(DataFolder),'\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_SIM.mat'));
        RealSouMat=SM;
        RealTCMat=TC(1:timepoints,:);
        RealSouInMask=zeros(GTICnum,VoxNum);
        h=1;
        for k=1:M*N*L
            if MaskVec(k)==1
                RealSouInMask(:,h)=RealSouMat(:,k);
                h=h+1;
            end
        end
        
        RealSouInMaskZ=[]; %z-score the value of GT IC in mask.
        for IC=1:GTICnum
            RealSouInMaskZ(IC,:)=(RealSouInMask(IC,:)-mean(RealSouInMask(IC,:)))/std(RealSouInMask(IC,:));
        end
        
        RealTCMatZ=[];
        for tc=1:GTICnum
            RealTCMatZ(:,tc)=(RealTCMat(:,tc)-mean(RealTCMat(:,tc)))/std(RealTCMat(:,tc));
        end
        
        
        %change the order of RealSou and RealTC
        RealSouInMaskCO=[];
        RealSouInMaskZCO=[];
        RealTCMatCO=[];
        RealTCMatZCO=[];

        for ICorder=1:number
            RealSouInMaskCO(ICorder,:)=RealSouInMask(OrderGT(ICorder),:);
            RealSouInMaskZCO(ICorder,:)=RealSouInMaskZ(OrderGT(ICorder),:);
            RealTCMatCO(:,ICorder)= RealTCMat(:,OrderGT(ICorder));
            RealTCMatZCO(:,ICorder)=RealTCMatZ(:,OrderGT(ICorder));
        end
        
        %compute the independence between GT ICs
        for S=1:number
            GTKurt(i,S)= kurtn(RealSouInMaskZCO(S,:));
            GTNege(i,S)= nege(RealSouInMaskZCO(S,:));
            for S1=1:number
                [NMI,MI,MIxy,Entropyx,Entropyy,Entropyxy]=MIEtropy(RealSouInMaskZCO(S,:),RealSouInMaskZCO(S1,:),binsPara);
                GTMutuInfo(S,S1)=MI;
                GTNMutuInfo(S,S1)=NMI;
            end
        end
        
        GTMuIn=(sum(sum(triu(GTMutuInfo)))-sum(diag(triu(GTMutuInfo))))/((number*number-number)/2);
        GTNMuIn=(sum(sum(triu(GTNMutuInfo)))-sum(diag(triu(GTNMutuInfo))))/((number*number-number)/2);
        
        SumGTKurt(i)=sum(GTKurt(i,:),2);
        SumGTNege(i)=sum(GTNege(i,:),2);
        GTMI(i)=GTMuIn;
        GTNMI(i)=GTNMuIn;
        
        %%
        IVAICMat=IndiIVAICMat(:,:,i);
        IVATCMat=IndiIVATCMat(:,:,i);
        IVAICMatZ=[];
        for icorder=1:size(IVAICMat,1)
            IVAICMatZ(icorder,:)=(IVAICMat(icorder,:)-mean(IVAICMat(icorder,:)))/std(IVAICMat(icorder,:));
        end
        IVATCMatZ=[];
        for tcorder=1:size(IVATCMat,2)
            IVATCMatZ(:,tcorder)=(IVATCMat(:,tcorder)-mean(IVATCMat(:,tcorder)))/std(IVATCMat(:,tcorder));
        end
        
        %change the order of IVA ICs/TCs to match GT source/TCs
        IVATCMatCO=zeros(timepoints,number);
        IVAICMatCO=zeros(number,VoxNum);
        for ICorder=1:number
            IVAICMatCO(ICorder,:)=IVAICMat(OrderIVA(ICorder),:);
            IVATCMatCO(:,ICorder)=IVATCMat(:,OrderIVA(ICorder));
        end
        
        %change the order of z-scored IVA TC result
        IVATCMatCOZ=zeros(timepoints,number);
        IVAICMatCOZ=zeros(number,VoxNum);
        for ICorder=1:number
            IVAICMatCOZ(ICorder,:)=IVAICMatZ(OrderIVA(ICorder),:);
            IVATCMatCOZ(:,ICorder)=IVATCMatZ(:,OrderIVA(ICorder));
        end
        
        cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');
        
        [IndiIC1RealSMSim,IndiIC1ReSm]=SMSim(IVAICMatCO,RealSouInMaskCO);
        [IndiTC1RealTCSim,IndiTC1ReTc]=TCSim(IVATCMatCO,RealTCMatCO);
        
        [IndiIC1RealSMSimZ,IndiIC1ReSmZ]=SMSim(IVAICMatCOZ,RealSouInMaskZCO);
        [IndiTC1RealTCSimZ,IndiTC1ReTcZ]=TCSim(IVATCMatCOZ,RealTCMatZCO);
        
        for s=1:size(IndiTC1ReTc,1)
            if isnan(IndiTC1ReTc(s))
                IndiIC1ReSm(s)=0;
                IndiTC1ReTc(s)=0;
                IndiIC1ReSmZ(s)=0;
                IndiTC1ReTcZ(s)=0;
            end
        end
        SMS1(i,:)=IndiIC1ReSm';
        TCS1(i,:)=IndiTC1ReTc';
        MeanSMSG1(i)=sum(IndiIC1ReSm)/size(find(IndiIC1ReSm~=0),1);
        MeanTCSG1(i)=sum(IndiTC1ReTc)/size(find(IndiTC1ReTc~=0),1);
        
        %compute the independence between estimated ICs from IVA
        for S=1:number
            IVAKurt(i,S)= kurtn(IVAICMatCOZ(S,:));
            IVANege(i,S)= nege(IVAICMatCOZ(S,:));
            for S1=1:number
                [NMI,MI,MIxy,Entropyx,Entropyy,Entropyxy]=MIEtropy(IVAICMatCOZ(S,:),IVAICMatCOZ(S1,:),binsPara);
                IVAMutuInfo(S,S1)=MI;
                IVANMutuInfo(S,S1)=NMI;
            end
        end
        
        IVAMuIn=(sum(sum(triu(IVAMutuInfo)))-sum(diag(triu(IVAMutuInfo))))/((number*number-number)/2);
        IVANMuIn=(sum(sum(triu(IVANMutuInfo)))-sum(diag(triu(IVANMutuInfo))))/((number*number-number)/2);
        
        SumIVAKurt(i)=sum(IVAKurt(i,:),2);
        SumIVANege(i)=sum(IVANege(i,:),2);
        IVAMI(i)=IVAMuIn;
        IVANMI(i)=IVANMuIn;
        
        
        IVAICMatCOZPlMask=zeros(size(IVAICMatCO,1),M*N*L);
        RealSouInMaskZCOPlMask=zeros(size(IVAICMatCO,1),M*N*L);%z scored GT IC (after reordering) plus mask.
        h=1;
        for K=1:M*N*L
            if MaskVec(K)==0
                IVAICMatCOZPlMask(:,K)=0;
                RealSouInMaskZCOPlMask(:,K)=0;
            else
                IVAICMatCOZPlMask(:,K)=IVAICMatCOZ(:,h);
                RealSouInMaskZCOPlMask(:,K)=RealSouInMaskZCO(:,h);
                h=h+1;
            end
        end
        
        
        %change the order of GIG result
        GIGICMat=IndiGIGICMat(:,:,i);
        GIGTCMat=IndiGIGTCMat(:,:,i);
        GIGTCMatCO=zeros(timepoints,number);
        GIGICMatCO=zeros(number,VoxNum);
        GIGTCMatZCO=zeros(timepoints,number);
        for ICorder=1:number
            GIGICMatCO(ICorder,:)=GIGICMat(OrderGIG(ICorder),:);
            GIGTCMatCO(:,ICorder)= GIGTCMat(:,OrderGIG(ICorder));
            GIGTCMatZCO(:,ICorder)=GIGTCMatZ(:,OrderGIG(ICorder));
        end
        
        cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');
        
        [IndiIC2RealSMSim,IndiIC2ReSm]=SMSim(GIGICMatCO,RealSouInMaskCO);
        [IndiTC2RealTCSim,IndiTC2ReTc]=TCSim(GIGTCMatCO,RealTCMatCO);
        
        [IndiIC2RealSMSimZ,IndiIC2ReSmZ]=SMSim(GIGICMatCO,RealSouInMaskZCO);
        [IndiTC2RealTCSimZ,IndiTC2ReTcZ]=TCSim(GIGTCMatZCO,RealTCMatZCO);
        
        for s=1:size(IndiTC2ReTc,1)
            if isnan(IndiTC2ReTc(s))
                IndiIC2ReSm(s)=0;
                IndiTC2ReTc(s)=0;
                IndiIC2ReSmZ(s)=0;
                IndiTC2ReTcZ(s)=0;
            end
        end
        SMS2(i,:)=IndiIC2ReSm';
        TCS2(i,:)=IndiTC2ReTc';
        MeanSMSG2(i)=sum(IndiIC2ReSm)/size(find(IndiIC2ReSm~=0),1);
        MeanTCSG2(i)=sum(IndiTC2ReTc)/size(find(IndiTC2ReTc~=0),1);
        
        %compute the independence between estimated ICs from IVA
        for S=1:number
            GIGKurt(i,S)= kurtn(GIGICMatCO(S,:));
            GIGNege(i,S)= nege(GIGICMatCO(S,:));
            for S1=1:number
                [NMI,MI,MIxy,Entropyx,Entropyy,Entropyxy]=MIEtropy(GIGICMatCO(S,:),GIGICMatCO(S1,:),binsPara);
                GIGMutuInfo(S,S1)=MI;
                GIGNMutuInfo(S,S1)=NMI;
            end
        end
        
        GIGMuIn=(sum(sum(triu(GIGMutuInfo)))-sum(diag(triu(GIGMutuInfo))))/((number*number-number)/2);
        GIGNMuIn=(sum(sum(triu(GIGNMutuInfo)))-sum(diag(triu(GIGNMutuInfo))))/((number*number-number)/2);
        
        SumGIGKurt(i)=sum(GIGKurt(i,:),2);
        SumGIGNege(i)=sum(GIGNege(i,:),2);
        GIGMI(i)=GIGMuIn;
        GIGNMI(i)=GIGNMuIn;
        
        
        GIGICMatCOZPlMask=zeros(size(GIGICMatCO,1),M*N*L);
        RealSouInMaskZCOPlMask=zeros(size(GIGICMatCO,1),M*N*L);%z scored GT IC (after reordering) plus mask.
        h=1;
        for K=1:M*N*L
            if MaskVec(K)==0
                GIGICMatCOZPlMask(:,K)=0;
                RealSouInMaskZCOPlMask(:,K)=0;
            else
                GIGICMatCOZPlMask(:,K)=GIGICMatCO(:,h);
                RealSouInMaskZCOPlMask(:,K)=RealSouInMaskZCO(:,h);
                h=h+1;
            end
        end
        %if i==1||i==3||i==7;
        h03=figure;
        for k=1:number
            subplot(min(GTICnum,ICnum),7,7*k-5);
            imshow(reshape(IVAICMatCOZPlMask(k,:),M,N),[]);
            tmp = sprintf('%.2f', IndiIC1ReSm(k));
            title(['\bf {IVA IC} ',int2str(k),' (',tmp,')'],'fontsize',8);
            
            
            subplot(min(GTICnum,ICnum),7,7*k-4);
            plot(IVATCMatCOZ(:,k));
            tmp = sprintf('%.2f', IndiTC1ReTc(k));
            title(['\bf {IVA TC} ',int2str(k),' (',tmp,')'],'fontsize',8);
            xlim([0 timepoints]);
            ylim([-4 4]);
            
            subplot(min(GTICnum,ICnum),7,7*k-3);
            imshow(reshape(GIGICMatCOZPlMask(k,:),M,N),[]);
            tmp = sprintf('%.2f', IndiIC2ReSm(k));
            title(['\bf {GIG-ICA IC} ',int2str(k),' (',tmp,')'],'fontsize',8);
            
            
            subplot(min(GTICnum,ICnum),7,7*k-2);
            plot(GIGTCMatZCO(:,k));
            tmp = sprintf('%.2f', IndiTC2ReTc(k));
            title(['\bf {GIG-ICA TC} ',int2str(k),' (',tmp,')'],'fontsize',8);
            xlim([0 timepoints]);
            ylim([-4 4]);
            
            subplot(min(GTICnum,ICnum),7,7*k-1);
            imshow(reshape(RealSouInMaskZCOPlMask(k,:),M,N),[]);
            title(['\bf {GT IC} ',int2str(k)],'fontSize',8);
            
            subplot(min(GTICnum,ICnum),7,7*k);
            plot(RealTCMatZCO(:,k));
            title(['\bf {GT TC} ',int2str(k)],'fontSize',8);
            xlim([0 timepoints]);
            ylim([-4 4]);
        end
        
        mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum),'\IndiResult\sb',num2str(i)));
        cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum),'\IndiResult\sb',num2str(i)));    
        saveas(h03,'IndiICTC.fig');
        saveas(h03,'IndiICTC.png');
        
        cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');
        %save individual ICs for later reliability evaluation
        IVAICALL((i*number-(number-1)):(number*i),:)=IVAICMatCOZ;
        GIGICALL((i*number-(number-1)):(number*i),:)=GIGICMatCO;
        GTICALL((i*number-(number-1)):(number*i),:)=RealSouInMaskZCO;
        %save individual TCs for later reliability evaluation
        IVATCALL(:,(i*number-(number-1)):(number*i))=IVATCMatCOZ;
        GIGTCALL(:,(i*number-(number-1)):(number*i))=GIGTCMatZCO;
        GTTCALL(:,(i*number-(number-1)):(number*i))=RealTCMatZCO;
        cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');
        
    end
    
    cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');
    
    %%
    %save the results for IVA
    %boxplot spatial accuracy
    h1=figure;
    set (gcf,'Position',[100,100,600,500], 'color','w')
    b_1=boxplotCsub(SMS1,1,['*'],1,1,'b',2,1,true,[1 2],1.3,0,'ks');
    b_2=boxplotCsub(SMS2,1,['*'],1,1,'r',2,1,true,[2 2],1.3,0,'ks');

    set(gcf,'color','white')
    xmax=number+0.5;
    axis([0.5 xmax 0 1])
    set(gca,'ygrid','on');
    set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',16);
    xlabel('ICs','Fontsize',20,'Fontweight','Bold','Fontsize',20);
    ylabel('Spatial accuracy','Fontsize',20,'Fontweight','Bold','Fontsize',20);
    title('Spatial accuracy','Fontsize',20,'Fontweight','Bold');
    % hold on;
    % for i=1:7
    %     %X=[xaixs(i)+0.5,xaixs(i)+0.5];
    %     X=[i+0.5,i+0.5];
    %     Y=[0,1];
    %     plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
    % end
    
    %boxplot temporal accuracy
    h2=figure;
    set (gcf,'Position',[100,100,600,500], 'color','w')
    b_1=boxplotCsub(TCS1,1,['*'],1,1,'b',2,1,true,[1 2],1.3,0,'ks');
    b_2=boxplotCsub(TCS2,1,['*'],1,1,'r',2,1,true,[2 2],1.3,0,'ks');

    set(gcf,'color','white')
    xmax=number+0.5;
    axis([0.5 xmax 0 1])
    set(gca,'ygrid','on');
    set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',16);
    xlabel('ICs','Fontsize',20,'Fontweight','Bold','Fontsize',20);
    ylabel('Temporal accuracy','Fontsize',20,'Fontweight','Bold','Fontsize',20);
    title('Temporal accuracy','Fontsize',20,'Fontweight','Bold');
    % hold on;
    % for i=1:7
    %     %X=[xaixs(i)+0.5,xaixs(i)+0.5];
    %     X=[i+0.5,i+0.5];
    %     Y=[0,1];
    %     plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
    % end
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum),'\Accuracy'));    
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum),'\Accuracy'));    

    saveas(h1,strcat('IVASpaAcc.fig'));
    saveas(h1,strcat('IVASpaAcc.png'));
    saveas(h2,strcat('IVATemAcc.fig'));
    saveas(h2,strcat('IVATemAcc.png'));
    
    fprintf(strcat('Mean spatial accuracy of IVA method is'));
    MeanSpaAccIVA=mean(MeanSMSG1)
    fprintf(strcat('Mean temporal accuracy of IVA method is'));
    MeanTemAccIVA=mean(MeanTCSG1)
    save('MeanSpaAccIVA','MeanSpaAccIVA');
    save('MeanTemAccIVA','MeanTemAccIVA');
    xlswrite('MeanSpaAccIVA',MeanSpaAccIVA);
    xlswrite('MeanTemAccIVA',MeanTemAccIVA);
    
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum)));    
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum)));  
    
    save('IVAICALL','IVAICALL');
    save('IVATCALL','IVATCALL');
    save('GTICALL','GTICALL');
    save('GTTCALL','GTTCALL');
    
    
    MeanSMSG1DifICNum(:,EstiICNum)=MeanSMSG1';
    MeanTCSG1DifICNum(:,EstiICNum)=MeanTCSG1';
    
    IVAKurtDifICNum(:,EstiICNum)=SumIVAKurt;
    IVANegeDifICNum(:,EstiICNum)=SumIVANege;
    IVAMIDifICNum(:,EstiICNum)=IVAMI;
    IVANMIDifICNum(:,EstiICNum)=IVANMI;
    
    GTKurtDifICNum(:,EstiICNum)=SumGTKurt;
    GTNegeDifICNum(:,EstiICNum)=SumGTNege;
    GTMIDifICNum(:,EstiICNum)=GTMI;
    GTNMIDifICNum(:,EstiICNum)=GTNMI;
    
    
    MeanSMSG2DifICNum(:,EstiICNum)=MeanSMSG2';
    MeanTCSG2DifICNum(:,EstiICNum)=MeanTCSG2';
    
    GIGKurtDifICNum(:,EstiICNum)=SumGIGKurt;
    GIGNegeDifICNum(:,EstiICNum)=SumGIGNege;
    GIGMIDifICNum(:,EstiICNum)=GIGMI;
    GIGNMIDifICNum(:,EstiICNum)=GIGNMI;
    
    
    %save the reliability results
    %show the reliability of different methods
    GTICALLs=[];
    for k=1:sbnum
        for l=1:number
            GTICALLs(sbnum*(l-1)+k,:)=GTICALL(number*(k-1)+l,:);
        end
    end
    GTSimMatALLs=[];
    for j=1:sbnum*number
        for k=1:sbnum*number
            GTSimMatALLs(j,k)=abs(corr(GTICALLs(j,:)',GTICALLs(k,:)'));
        end
    end
    GTSimMatALLsG=GTSimMatALLs;
    for ICorder=1:number
        for i=1+((ICorder-1)*sbnum):sbnum+((ICorder-1)*sbnum)
            for j=sbnum+1+((ICorder-1)*sbnum):sbnum*number
                GTSimMatALLsG(i,j)=NaN;
            end
        end
    end
    
    figure;
    [X,Y]=meshgrid(1:1:sbnum*number, 1:1:sbnum*number);
    h=pcolor(X,Y,GTSimMatALLsG);
    caxis([0,1]);
    %colorbar('horiz');
    colormap(jet(64));
    grid off;
    axis ij
    axis square
    set(h,'LineStyle','none')
    set(gca,'FontName','Times New Roman','Fontsize',26,'Fontweight','Bold')
    title(['\bf {GT}' ],'Fontsize',26,'Fontweight','Bold');
    
    %axis([0.5 124.5 0.5 124.5])
    set(gca,'XTick',[sbnum/2:sbnum:sbnum*number],'Fontweight','Bold','Fontsize',20);
    set(gca,'YTick',[sbnum/2:sbnum:sbnum*number],'Fontweight','Bold','Fontsize',20);
    set(gca,'box','off')
    set(gcf,'paperunits','centimeters');
    set(gcf,'papersize',[3 3]);
    set(gca,'XTickLabel',{'1','2','3','4','5','6','7','8'},'Fontweight','Bold','Fontsize',26);
    set(gca,'YTickLabel',{'1','2','3','4','5','6','7','8'},'Fontweight','Bold','Fontsize',26);
    
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum),'\Reliability'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum),'\Reliability'));
    saveas(h,strcat('GTCorrMatrix.fig'));
    print('-dtiff','-r500',strcat('GTCorrMatrix.tif'));
    
    GTMat=[];
    GTVecSubSimAllIC=[];
    %boxplot the similarity
    for k=1:number
        GTSubSimMat=GTSimMatALLs(sbnum*(k-1)+1:sbnum*k,sbnum*(k-1)+1:sbnum*k);
        GTTriSub=triu(GTSubSimMat,1);
        GTVecSubSim=reshape(GTTriSub,1,sbnum*sbnum);
        % MeanSimIC2(k)=mean(VecSubSim2);
        % StdSimIC2(k)=std(VecSubSim2);
        GTMat(:,k)=GTVecSubSim';
        GTVecSubSimAllIC=[GTVecSubSimAllIC,GTVecSubSim];
    end
    [m,n]=size(GTVecSubSimAllIC);
    GTVecSubSimAllICg=[GTVecSubSimAllIC,zeros(1,max(ICnumMat)*sbnum*sbnum-n)];
    GTVecSubSimAllICDifICNum(:,EstiICNum)=GTVecSubSimAllICg';
    
    
    GTMatG=GTMat;
    GTMatGG=GTMat;
    for i=1:sbnum*sbnum
        for j=1:number
            if GTMat(i,j)==1
                GTMatG(i,j)=NaN;
                GTMatGG(i,j)=0;
            end
            if GTMat(i,j)==0
                GTMatG(i,j)=NaN;
            end;
        end
    end
    GTEachICMeanCorr=zeros(1,number);
    for j=1:number
        GTEachICMeanCorr(1,j)=sum(GTMatGG(:,j))/size(find(GTMatGG(:,j)~=0),1);
    end
    
    cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');
    hp=figure;
    %set (gcf,'Position',[0,0,400,1200], 'color','w')
    set (gcf,'Position',[0,0,1200,400], 'color','w')
    b_1=boxplotCsub(GTMatG,1,['*'],1,1,'b',2,2,true,[1 1],1.3,0,'ks');
    Hla=cell(1,number);
    for i=1:size(Hla,2)
        Hla{i}=i;
    end
    set(gcf,'color','white')
    a=number+0.5;
    axis([0.5 a 0 1])
    set(gca,'ygrid','on');
    set(gca,'YTick',[0:0.2:2],'Fontweight','Bold','Fontsize',20);
    xlabel('IC ID','Fontweight','Bold','Fontsize',20);
    ylabel('Absolute value of correlation','Fontweight','Bold','Fontsize',20);
    set(gca,'XTickLabel',Hla,'Fontweight','Bold','Fontsize',20);%,
    title('GT','Fontsize',20,'Fontweight','Bold');
    
    hold on;
    for i=1:number-1
        %X=[xaixs(i)+0.5,xaixs(i)+0.5];
        X=[i+0.5,i+0.5];
        Y=[0,1];
        plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
    end
    % az = -90;
    % el = 90;
    % view(az, el);
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum),'\Reliability'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum),'\Reliability'));
    saveas(hp,'GTEachICReliability.png');
    saveas(hp,'GTEachICReliability.fig');
    
    a=1:number;
    Label=[];
    for i=1:sbnum
        Label=[Label,a];
    end
    figure;
    GTAllFea2D = tsne(GTICALL, Label);
    hP=gcf;
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum),'\Reliability'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum),'\Reliability'));
    
    saveas(hP,'GTProjectionOfAllsubAllIC.tif');
    saveas(hP,'GTProjectionOfAllsubAllIC.fig');
    save('GTAllFea2D','GTAllFea2D');
    save('GTICALL','GTICALL');
    save('GTTCALL','GTTCALL');
    %draw the projection result myself.
    figure;
    GTAllFea2DG=zeros(size(GTAllFea2D));
    for k=1:sbnum
        for l=1:number
            GTAllFea2DG(sbnum*(l-1)+k,:)=GTAllFea2D(number*(k-1)+l,:);
        end
    end
    hPSpaG=figure;
    if number==7
        for i=1:size(GTAllFea2DG,1)
            if i<sbnum+1
                scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'r','filled');
                hold on;
            else if i<sbnum*2+1
                    scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'b','filled');
                    hold on;
                else if i<sbnum*3+1
                        scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'c','filled');
                        hold on;
                    else if i<sbnum*4+1
                            scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'g','filled');
                            hold on;
                        else if i<sbnum*5+1
                                scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'k','filled');
                                hold on;
                            else if i<sbnum*6+1
                                    scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'y','filled');
                                    hold on;
                                else if i<sbnum*7+1
                                        scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'m','filled');
                                        hold on;
                                        
                                    end
                                end
                            end
                        end
                    end
                end
            end
        end
        title('t-SNE projection');
        
    else if number==8
            for i=1:size(GTAllFea2DG,1)
                if i<sbnum+1
                    scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'r','filled');
                    hold on;
                else if i<sbnum*2+1
                        scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'b','filled');
                        hold on;
                    else if i<sbnum*3+1
                            scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'c','filled');
                            hold on;
                        else if i<sbnum*4+1
                                scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'g','filled');
                                hold on;
                            else if i<sbnum*5+1
                                    scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'k','filled');
                                    hold on;
                                else if i<sbnum*6+1
                                        scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'y','filled');
                                        hold on;
                                    else if i<sbnum*7+1
                                            scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,'m','filled');
                                            hold on;
                                        else if i<sbnum*8+1
                                                scatter(GTAllFea2DG(i,1),GTAllFea2DG(i,2),30,[0.5 0.3 1],'filled');
                                                hold on;
                                            end
                                        end
                                    end
                                end
                            end
                        end
                    end
                end
            end
            title('t-SNE projection');
        end
    end
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum),'\Reliability'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum),'\Reliability'));
    
    saveas(hPSpaG,'GTProjectionOfAllsubAllICOwn.tif');
    saveas(hPSpaG,'GTProjectionOfAllsubAllICOwn.fig');
    
    
    close all;
    IVAICALLs=[];
    for k=1:sbnum
        for l=1:number
            IVAICALLs(sbnum*(l-1)+k,:)=IVAICALL(number*(k-1)+l,:);
        end
    end
    IVASimMatALLs=[];
    for j=1:sbnum*number
        for k=1:sbnum*number
            IVASimMatALLs(j,k)=abs(corr(IVAICALLs(j,:)',IVAICALLs(k,:)'));
        end
    end
    IVASimMatALLsG=IVASimMatALLs;
    for ICorder=1:number
        for i=1+((ICorder-1)*sbnum):sbnum+((ICorder-1)*sbnum)
            for j=sbnum+1+((ICorder-1)*sbnum):sbnum*number
                IVASimMatALLsG(i,j)=NaN;
            end
        end
    end
    
    figure;
    [X,Y]=meshgrid(1:1:sbnum*number, 1:1:sbnum*number);
    h=pcolor(X,Y,IVASimMatALLsG);
    caxis([0,1]);
    %colorbar('horiz');
    colormap(jet(64));
    grid off;
    axis ij
    axis square
    set(h,'LineStyle','none')
    set(gca,'FontName','Times New Roman','Fontsize',26,'Fontweight','Bold')
    title(['\bf {IVA }' ],'Fontsize',26,'Fontweight','Bold');
    
    %axis([0.5 124.5 0.5 124.5])
    set(gca,'XTick',[sbnum/2:sbnum:sbnum*number],'Fontweight','Bold','Fontsize',20);
    set(gca,'YTick',[sbnum/2:sbnum:sbnum*number],'Fontweight','Bold','Fontsize',20);
    set(gca,'box','off')
    set(gcf,'paperunits','centimeters');
    set(gcf,'papersize',[3 3]);
    set(gca,'XTickLabel',{'1','2','3','4','5','6','7','8'},'Fontweight','Bold','Fontsize',26);
    set(gca,'YTickLabel',{'1','2','3','4','5','6','7','8'},'Fontweight','Bold','Fontsize',26);
    
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum),'\Reliability'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum),'\Reliability'));
    saveas(h,strcat('IVACorrMatrix.fig'));
    print('-dtiff','-r500',strcat('IVACorrMatrix.tif'));
    
    IVAMat=[];
    IVAVecSubSimAllIC=[];
    %boxplot the similarity
    for k=1:number
        IVASubSimMat=IVASimMatALLs(sbnum*(k-1)+1:sbnum*k,sbnum*(k-1)+1:sbnum*k);
        IVATriSub=triu(IVASubSimMat,1);
        IVAVecSubSim=reshape(IVATriSub,1,sbnum*sbnum);
        % MeanSimIC2(k)=mean(VecSubSim2);
        % StdSimIC2(k)=std(VecSubSim2);
        IVAMat(:,k)=IVAVecSubSim';
        IVAVecSubSimAllIC=[IVAVecSubSimAllIC,IVAVecSubSim];
    end
    [m,n]=size(IVAVecSubSimAllIC);
    IVAVecSubSimAllICg=[IVAVecSubSimAllIC,zeros(1,max(ICnumMat)*sbnum*sbnum-n)];
    IVAVecSubSimAllICDifICNum(:,EstiICNum)=IVAVecSubSimAllICg';
    
    IVAMatG=IVAMat;
    IVAMatGG=IVAMat;
    for i=1:sbnum*sbnum
        for j=1:number
            if IVAMat(i,j)==1
                IVAMatG(i,j)=NaN;
                IVAMatGG(i,j)=0;
            end
            if IVAMat(i,j)==0
                IVAMatG(i,j)=NaN;
            end;
        end
    end
    IVAEachICMeanCorr=zeros(1,number);
    for j=1:number
        IVAEachICMeanCorr(1,j)=sum(IVAMatGG(:,j))/size(find(IVAMatGG(:,j)~=0),1);
    end
    
    cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');
    hp=figure;
    %set (gcf,'Position',[0,0,400,1200], 'color','w')
    set (gcf,'Position',[0,0,1200,400], 'color','w')
    b_1=boxplotCsub(IVAMatG,1,['*'],1,1,'b',2,2,true,[1 1],1.3,0,'ks');
    Hla=cell(1,number);
    for i=1:size(Hla,2)
        Hla{i}=i;
    end
    set(gcf,'color','white')
    a=number+0.5;
    axis([0.5 a 0 1])
    set(gca,'ygrid','on');
    set(gca,'YTick',[0:0.2:2],'Fontweight','Bold','Fontsize',20);
    xlabel('IC ID','Fontweight','Bold','Fontsize',20);
    ylabel('Absolute value of correlation','Fontweight','Bold','Fontsize',20);
    set(gca,'XTickLabel',Hla,'Fontweight','Bold','Fontsize',20);%,
    title('IVA','Fontsize',20,'Fontweight','Bold');
    
    hold on;
    for i=1:number-1
        %X=[xaixs(i)+0.5,xaixs(i)+0.5];
        X=[i+0.5,i+0.5];
        Y=[0,1];
        plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
    end
    % az = -90;
    % el = 90;
    % view(az, el);
    
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum),'\Reliability'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum),'\Reliability'));
    saveas(hp,'IVAEachICReliability.png');
    saveas(hp,'IVAEachICReliability.fig');
    
    
    figure;
    IVAAllFea2D = tsne(IVAICALL, Label);
    hP=gcf;
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum),'\Reliability'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum),'\Reliability'));
    
    saveas(hP,'IVAProjectionOfAllsubAllIC.tif');
    saveas(hP,'IVAProjectionOfAllsubAllIC.fig');
    save('IVAAllFea2D','IVAAllFea2D');
    figure;
    IVAAllFea2DG=zeros(size(IVAAllFea2D));
    for k=1:sbnum
        for l=1:number
            IVAAllFea2DG(sbnum*(l-1)+k,:)=IVAAllFea2D(number*(k-1)+l,:);
        end
    end
    hPSpaG=figure;
    if number==7
        for i=1:size(IVAAllFea2DG,1)
            if i<sbnum+1
                scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'r','filled');
                hold on;
            else if i<sbnum*2+1
                    scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'b','filled');
                    hold on;
                else if i<sbnum*3+1
                        scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'c','filled');
                        hold on;
                    else if i<sbnum*4+1
                            scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'g','filled');
                            hold on;
                        else if i<sbnum*5+1
                                scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'k','filled');
                                hold on;
                            else if i<sbnum*6+1
                                    scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'y','filled');
                                    hold on;
                                else if i<sbnum*7+1
                                        scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'m','filled');
                                        hold on;
                                        
                                    end
                                end
                            end
                        end
                    end
                end
            end
        end
        title('t-SNE projection');
        
    else if number==8
            for i=1:size(IVAAllFea2DG,1)
                if i<sbnum+1
                    scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'r','filled');
                    hold on;
                else if i<sbnum*2+1
                        scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'b','filled');
                        hold on;
                    else if i<sbnum*3+1
                            scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'c','filled');
                            hold on;
                        else if i<sbnum*4+1
                                scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'g','filled');
                                hold on;
                            else if i<sbnum*5+1
                                    scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'k','filled');
                                    hold on;
                                else if i<sbnum*6+1
                                        scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'y','filled');
                                        hold on;
                                    else if i<sbnum*7+1
                                            scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,'m','filled');
                                            hold on;
                                        else if i<sbnum*8+1
                                                scatter(IVAAllFea2DG(i,1),IVAAllFea2DG(i,2),30,[0.5 0.3 1],'filled');
                                                hold on;
                                            end
                                        end
                                    end
                                end
                            end
                        end
                    end
                end
            end
            title('t-SNE projection');
        end
    end
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum),'\Reliability'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum),'\Reliability'));
    
    saveas(hPSpaG,'IVAProjectionOfAllsubAllICOwn.tif');
    saveas(hPSpaG,'IVAProjectionOfAllsubAllICOwn.fig');
    
    cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');
    GIGICALLs=[];
    for k=1:sbnum
        for l=1:number
            GIGICALLs(sbnum*(l-1)+k,:)=GIGICALL(number*(k-1)+l,:);
        end
    end
    GIGSimMatALLs=[];
    for j=1:sbnum*number
        for k=1:sbnum*number
            GIGSimMatALLs(j,k)=abs(corr(GIGICALLs(j,:)',GIGICALLs(k,:)'));
        end
    end
    GIGSimMatALLsG=GIGSimMatALLs;
    for ICorder=1:number
        for i=1+((ICorder-1)*sbnum):sbnum+((ICorder-1)*sbnum)
            for j=sbnum+1+((ICorder-1)*sbnum):sbnum*number
                GIGSimMatALLsG(i,j)=NaN;
            end
        end
    end
    
    figure;
    [X,Y]=meshgrid(1:1:sbnum*number, 1:1:sbnum*number);
    h=pcolor(X,Y,GIGSimMatALLsG);
    caxis([0,1]);
    %colorbar('horiz');
    colormap(jet(64));
    grid off;
    axis ij
    axis square
    set(h,'LineStyle','none')
    set(gca,'FontName','Times New Roman','Fontsize',26,'Fontweight','Bold')
    title(['\bf {GIG-ICA }' ],'Fontsize',26,'Fontweight','Bold');
    
    %axis([0.5 124.5 0.5 124.5])
    set(gca,'XTick',[sbnum/2:sbnum:sbnum*number],'Fontweight','Bold','Fontsize',20);
    set(gca,'YTick',[sbnum/2:sbnum:sbnum*number],'Fontweight','Bold','Fontsize',20);
    set(gca,'box','off')
    set(gcf,'paperunits','centimeters');
    set(gcf,'papersize',[3 3]);
    set(gca,'XTickLabel',{'1','2','3','4','5','6','7','8'},'Fontweight','Bold','Fontsize',26);
    set(gca,'YTickLabel',{'1','2','3','4','5','6','7','8'},'Fontweight','Bold','Fontsize',26);
    
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum),'\Reliability'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum),'\Reliability'));
    saveas(h,strcat('GIGCorrMatrix.fig'));
    print('-dtiff','-r500',strcat('GIGCorrMatrix.tif'));
    
    GIGMat=[];
    GIGVecSubSimAllIC=[];
    %boxplot the similarity
    for k=1:number
        GIGSubSimMat=GIGSimMatALLs(sbnum*(k-1)+1:sbnum*k,sbnum*(k-1)+1:sbnum*k);
        GIGTriSub=triu(GIGSubSimMat,1);
        GIGVecSubSim=reshape(GIGTriSub,1,sbnum*sbnum);
        % MeanSimIC2(k)=mean(VecSubSim2);
        % StdSimIC2(k)=std(VecSubSim2);
        GIGMat(:,k)=GIGVecSubSim';
        GIGVecSubSimAllIC=[GIGVecSubSimAllIC,GIGVecSubSim];
    end
    [m,n]=size(GIGVecSubSimAllIC);
    GIGVecSubSimAllICg=[GIGVecSubSimAllIC,zeros(1,max(ICnumMat)*sbnum*sbnum-n)];
    GIGVecSubSimAllICDifICNum(:,EstiICNum)=GIGVecSubSimAllICg';
    
    
    GIGMatG=GIGMat;
    GIGMatGG=GIGMat;
    for i=1:sbnum*sbnum
        for j=1:number
            if GIGMat(i,j)==1
                GIGMatG(i,j)=NaN;
                GIGMatGG(i,j)=0;
            end
            if GIGMat(i,j)==0
                GIGMatG(i,j)=NaN;
            end;
        end
    end
    GIGEachICMeanCorr=zeros(1,number);
    for j=1:number
        GIGEachICMeanCorr(1,j)=sum(GIGMatGG(:,j))/size(find(GIGMatGG(:,j)~=0),1);
    end
    
    
    cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');
    hp=figure;
    %set (gcf,'Position',[0,0,400,1200], 'color','w')
    set (gcf,'Position',[0,0,1200,400], 'color','w')
    b_1=boxplotCsub(GIGMatG,1,['*'],1,1,'b',2,2,true,[1 1],1.3,0,'ks');
    Hla=cell(1,number);
    for i=1:size(Hla,2)
        Hla{i}=i;
    end
    set(gcf,'color','white')
    a=number+0.5;
    axis([0.5 a 0 1])
    set(gca,'ygrid','on');
    set(gca,'YTick',[0:0.2:2],'Fontweight','Bold','Fontsize',20);
    xlabel('IC ID','Fontweight','Bold','Fontsize',20);
    ylabel('Absolute value of correlation','Fontweight','Bold','Fontsize',20);
    set(gca,'XTickLabel',Hla,'Fontweight','Bold','Fontsize',20);%,
    title('GIG-ICA','Fontsize',20,'Fontweight','Bold');
    
    hold on;
    for i=1:number-1
        %X=[xaixs(i)+0.5,xaixs(i)+0.5];
        X=[i+0.5,i+0.5];
        Y=[0,1];
        plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
    end
    % az = -90;
    % el = 90;
    % view(az, el);
    
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum),'\Reliability'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum),'\Reliability'));
    saveas(hp,'GIGEachICReliability.png');
    saveas(hp,'GIGEachICReliability.fig');
    
    
    figure;
    GIGAllFea2D = tsne(GIGICALL, Label);
    hP=gcf;
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum),'\Reliability'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum),'\Reliability'));
    
    saveas(hP,'GIGProjectionOfAllsubAllIC.tif');
    saveas(hP,'GIGProjectionOfAllsubAllIC.fig');
    save('GIGAllFea2D','GIGAllFea2D');
    figure;
    GIGAllFea2DG=zeros(size(GIGAllFea2D));
    for k=1:sbnum
        for l=1:number
            GIGAllFea2DG(sbnum*(l-1)+k,:)=GIGAllFea2D(number*(k-1)+l,:);
        end
    end
    hPSpaG=figure;
    if number==7
        for i=1:size(GIGAllFea2DG,1)
            if i<sbnum+1
                scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'r','filled');
                hold on;
            else if i<sbnum*2+1
                    scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'b','filled');
                    hold on;
                else if i<sbnum*3+1
                        scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'c','filled');
                        hold on;
                    else if i<sbnum*4+1
                            scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'g','filled');
                            hold on;
                        else if i<sbnum*5+1
                                scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'k','filled');
                                hold on;
                            else if i<sbnum*6+1
                                    scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'y','filled');
                                    hold on;
                                else if i<sbnum*7+1
                                        scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'m','filled');
                                        hold on;
                                        
                                    end
                                end
                            end
                        end
                    end
                end
            end
        end
        title('t-SNE projection');
        
    else if number==8
            for i=1:size(GIGAllFea2DG,1)
                if i<sbnum+1
                    scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'r','filled');
                    hold on;
                else if i<sbnum*2+1
                        scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'b','filled');
                        hold on;
                    else if i<sbnum*3+1
                            scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'c','filled');
                            hold on;
                        else if i<sbnum*4+1
                                scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'g','filled');
                                hold on;
                            else if i<sbnum*5+1
                                    scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'k','filled');
                                    hold on;
                                else if i<sbnum*6+1
                                        scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'y','filled');
                                        hold on;
                                    else if i<sbnum*7+1
                                            scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,'m','filled');
                                            hold on;
                                        else if i<sbnum*8+1
                                                scatter(GIGAllFea2DG(i,1),GIGAllFea2DG(i,2),30,[0.5 0.3 1],'filled');
                                                hold on;
                                            end
                                        end
                                    end
                                end
                            end
                        end
                    end
                end
            end
            title('t-SNE projection');
        end
    end
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareGIGGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum),'\Reliability'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareGIGGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum),'\Reliability'));
    
    saveas(hPSpaG,'GIGProjectionOfAllsubAllICOwn.tif');
    saveas(hPSpaG,'GIGProjectionOfAllsubAllICOwn.fig');
    
    cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');
    
    GTReliaDifICNum(:,EstiICNum)=mean(GTEachICMeanCorr);
    IVAReliaDifICNum(:,EstiICNum)=mean(IVAEachICMeanCorr);
    GIGReliaDifICNum(:,EstiICNum)=mean(GIGEachICMeanCorr);
    
    close all;
    %show the independence of different methods
    h7=figure;
    set(gcf,'Position',[100,100,600,500], 'color','w')
    bar([IVANMI',GIGNMI',GTNMI'],'group');
    title('NMI');
    
    h8=figure;
    set(gcf,'Position',[100,100,600,500], 'color','w')
    bar([SumIVAKurt',SumGIGKurt',SumGTKurt'],'group');
    title('Kurt');
    
    h9=figure;
    set(gcf,'Position',[100,100,600,500], 'color','w')
    bar([SumIVANege',SumGIGNege',SumGTNege'],'group');
    title('Nege');
    
    h10=figure;
    set(gcf,'Position',[100,100,600,500], 'color','w')
    bar([IVAMI',GIGMI',GTMI'],'group');
    title('MI');
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum),'\Independence'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ICnum',num2str(ICnum),'\Independence'));
    
    saveas(h7,strcat('NMI.fig'));
    saveas(h7,strcat('NMI.png'));
    saveas(h8,strcat('Kurt.fig'));
    saveas(h8,strcat('Kurt.png'));
    saveas(h9,strcat('Nege.fig'));
    saveas(h9,strcat('Nege.png'));
    saveas(h10,strcat('MI.fig'));
    saveas(h10,strcat('MI.png'));
    cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');

end



%boxplot the IVA and GIG results together
%boxplot spatial accuracy under different length of time course
h5=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(MeanSMSG1DifICNum,1,['*'],1,1,'b',2,1,true,[1 2],1.3,0,'ks');
b_2=boxplotCsub(MeanSMSG2DifICNum,1,['*'],1,1,'r',2,1,true,[2 2],1.3,0,'ks');
set(gcf,'color','white')
axis([0.5 3.5 0.3 1])
set(gca,'ygrid','on');
set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',24);
xlabel('Number of ICs used in compuation','Fontsize',24,'Fontweight','Bold','Fontsize',24);
ylabel('Spatial accuracy','Fontsize',24,'Fontweight','Bold','Fontsize',24);
set(gca,'XTickLabel',{'6','8','10'},'Fontweight','Bold','Fontsize',24);%,
title('(A)','Fontsize',24,'Fontweight','Bold');
hold on;
for i=1:3
    X=[i+0.5,i+0.5];
    Y=[0,1];
    plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
end
legend([b_1(8,1) b_2(8,1)],{'IVA','GIG-ICA'},3)

%boxplot spatial accuracy under different GIGGroupPCnum
h6=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(MeanTCSG1DifICNum,1,['*'],1,1,'b',2,1,true,[1 2],1.3,0,'ks');
b_2=boxplotCsub(MeanTCSG2DifICNum,1,['*'],1,1,'r',2,1,true,[2 2],1.3,0,'ks');
set(gcf,'color','white')
axis([0.5 3.5 0.3 1])
set(gca,'ygrid','on');
set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',24);
xlabel('Number of ICs used in compuation','Fontsize',24,'Fontweight','Bold','Fontsize',24);
ylabel('Temporal accuracy','Fontsize',24,'Fontweight','Bold','Fontsize',24);
set(gca,'XTickLabel',{'6','8','10'},'Fontweight','Bold','Fontsize',24);%,
title('(B)','Fontsize',24,'Fontweight','Bold');
hold on;
for i=1:3
    X=[i+0.5,i+0.5];
    Y=[0,1];
    plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
end
legend([b_1(8,1) b_2(8,1)],{'IVA','GIG-ICA'},3)
mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ResultSummary'));
mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ResultSummary\Accuracy'));
cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ResultSummary\Accuracy'));
saveas(h5,'SpatialAccuracySummary.fig');
saveas(h5,'SpatialAccuracySummary.png');
saveas(h6,'TemporalAccuracySummary.fig');
saveas(h6,'TemporalAccuracySummary.png');
save('MeanSMSG1DifICNum','MeanSMSG1DifICNum');
save('MeanSMSG2DifICNum','MeanSMSG2DifICNum');
save('MeanTCSG1DifICNum','MeanTCSG1DifICNum');
save('MeanTCSG2DifICNum','MeanTCSG2DifICNum');


cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');
h3=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(IVAKurtDifICNum,1,['*'],1,1,'b',2,1,true,[1 3],1.3,0,'ks');
b_2=boxplotCsub(GIGKurtDifICNum,1,['*'],1,1,'r',2,1,true,[2 3],1.3,0,'ks');
b_3=boxplotCsub(GTKurtDifICNum,1,['*'],1,1,'m',2,1,true,[3 3],1.3,0,'ks');

set(gcf,'color','white')
axis([0.5 3.5 0 100])
set(gca,'ygrid','on');
%set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',24);
xlabel('Number of ICs used in compuation','Fontsize',24,'Fontweight','Bold','Fontsize',24);
ylabel('Kurtosis','Fontsize',24,'Fontweight','Bold','Fontsize',24);
set(gca,'XTickLabel',{'6','8','10'},'Fontweight','Bold','Fontsize',24);%,

title('(A)','Fontsize',24,'Fontweight','Bold');
hold on;
for i=1:3
    X=[i+0.5,i+0.5];
    Y=[0,1];
    plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
end
legend([b_1(8,1) b_2(8,1) b_3(8,1)],{'IVA','GIG-ICA','GT'},3)

h4=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(IVANegeDifICNum,1,['*'],1,1,'b',2,1,true,[1 3],1.3,0,'ks');
b_2=boxplotCsub(GIGNegeDifICNum,1,['*'],1,1,'r',2,1,true,[2 3],1.3,0,'ks');
b_3=boxplotCsub(GTNegeDifICNum,1,['*'],1,1,'m',2,1,true,[3 3],1.3,0,'ks');

set(gcf,'color','white')
axis([0.5 3.5 0 0.2])
set(gca,'ygrid','on');
%set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',24);
xlabel('Number of ICs used in compuation','Fontsize',24,'Fontweight','Bold','Fontsize',24);
ylabel('Negentropy','Fontsize',24,'Fontweight','Bold','Fontsize',24);
set(gca,'XTickLabel',{'6','8','10'},'Fontweight','Bold','Fontsize',24);%,

title('(B)','Fontsize',24,'Fontweight','Bold');
hold on;
for i=1:3
    X=[i+0.5,i+0.5];
    Y=[0,1];
    plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
end
legend([b_1(8,1) b_2(8,1) b_3(8,1)],{'IVA','GIG-ICA','GT'},3)


h5=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(IVAMIDifICNum,1,['*'],1,1,'b',2,1,true,[1 3],1.3,0,'ks');
b_2=boxplotCsub(GIGMIDifICNum,1,['*'],1,1,'r',2,1,true,[2 3],1.3,0,'ks');
b_3=boxplotCsub(GTMIDifICNum,1,['*'],1,1,'m',2,1,true,[3 3],1.3,0,'ks');

set(gcf,'color','white')
axis([0.5 3.5 0 0.5])
set(gca,'ygrid','on');
%set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',24);
xlabel('Number of ICs used in compuation','Fontsize',24,'Fontweight','Bold','Fontsize',24);
ylabel('Mutual information','Fontsize',24,'Fontweight','Bold','Fontsize',24);
set(gca,'XTickLabel',{'6','8','10'},'Fontweight','Bold','Fontsize',24);%,
title('(C)','Fontsize',24,'Fontweight','Bold');

hold on;
for i=1:3
    X=[i+0.5,i+0.5];
    Y=[0,1];
    plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
end
legend([b_1(8,1) b_2(8,1) b_3(8,1)],{'IVA','GIG-ICA','GT'},3)

h6=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(IVANMIDifICNum,1,['*'],1,1,'b',2,1,true,[1 3],1.3,0,'ks');
b_2=boxplotCsub(GIGNMIDifICNum,1,['*'],1,1,'r',2,1,true,[2 3],1.3,0,'ks');
b_3=boxplotCsub(GTNMIDifICNum,1,['*'],1,1,'m',2,1,true,[3 3],1.3,0,'ks');

set(gcf,'color','white')
axis([0.5 3.5 0 0.5])
set(gca,'ygrid','on');
%set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',24);
xlabel('Number of ICs used in compuation','Fontsize',24,'Fontweight','Bold','Fontsize',24);
ylabel('Normalized mutual information','Fontsize',24,'Fontweight','Bold','Fontsize',24);
set(gca,'XTickLabel',{'6','8','10'},'Fontweight','Bold','Fontsize',24);%,
title('(D)','Fontsize',24,'Fontweight','Bold');
hold on;
for i=1:3
    X=[i+0.5,i+0.5];
    Y=[0,1];
    plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
end
legend([b_1(8,1) b_2(8,1) b_3(8,1)],{'IVA','GIG-ICA','GT'},3)

mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ResultSummary\Independence'));
cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ResultSummary\Independence'));
saveas(h3,'KurtSummary.fig');
saveas(h3,'KurtSummary.png');
saveas(h4,'NegeSummary.fig');
saveas(h4,'NegeSummary.png');
saveas(h5,'MISummary.fig');
saveas(h5,'MISummary.png');
saveas(h6,'NMISummary.fig');
saveas(h6,'NMISummary.png');

save('GTKurtDifICNum','GTKurtDifICNum');
save('GIGKurtDifICNum','GIGKurtDifICNum');

save('GTNegeDifICNum','GTNegeDifICNum');
save('GIGNegeDifICNum','GIGNegeDifICNum');

save('GTMIDifICNum','GTMIDifICNum');
save('GIGMIDifICNum','GIGMIDifICNum');

save('GTNMIDifICNum','GTNMIDifICNum');
save('GIGNMIDifICNum','GIGNMIDifICNum');
cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');

%%
%show the reliability under Number of ICs used in compuation
for i=1:size(IVAVecSubSimAllICDifICNum,1)
    for j=1:size(IVAVecSubSimAllICDifICNum,2)
        if IVAVecSubSimAllICDifICNum(i,j)==0
            IVAVecSubSimAllICDifICNum(i,j)=NaN;
        end
        if IVAVecSubSimAllICDifICNum(i,j)==1
            IVAVecSubSimAllICDifICNum(i,j)=NaN;
        end
    end
end

for i=1:size(GTVecSubSimAllICDifICNum,1)
    for j=1:size(GTVecSubSimAllICDifICNum,2)
        if GTVecSubSimAllICDifICNum(i,j)==0
            GTVecSubSimAllICDifICNum(i,j)=NaN;
        end
        if GTVecSubSimAllICDifICNum(i,j)==1
            GTVecSubSimAllICDifICNum(i,j)=NaN;
        end
    end
end

for i=1:size(GIGVecSubSimAllICDifICNum,1)
    for j=1:size(GIGVecSubSimAllICDifICNum,2)
        if GIGVecSubSimAllICDifICNum(i,j)==0
            GIGVecSubSimAllICDifICNum(i,j)=NaN;
        end
        if GIGVecSubSimAllICDifICNum(i,j)==1
            GIGVecSubSimAllICDifICNum(i,j)=NaN;
        end
    end
end

h7=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(IVAVecSubSimAllICDifICNum,1,['*'],1,1,'b',2,1,true,[1 3],1.3,0,'ks');
b_2=boxplotCsub(GIGVecSubSimAllICDifICNum,1,['*'],1,1,'r',2,1,true,[2 3],1.3,0,'ks');
b_3=boxplotCsub(GTVecSubSimAllICDifICNum,1,['*'],1,1,'m',2,1,true,[3 3],1.3,0,'ks');

set(gcf,'color','white')
axis([0.5 3.5 0 1])
set(gca,'ygrid','on');
set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',24);
xlabel('Number of ICs used in compuation','Fontsize',24,'Fontweight','Bold','Fontsize',24);
ylabel('Reliability','Fontsize',24,'Fontweight','Bold','Fontsize',24);
set(gca,'XTickLabel',{'6','8','10'},'Fontweight','Bold','Fontsize',24);%,

%title('(D)','Fontsize',24,'Fontweight','Bold');
hold on;
for i=1:3
    X=[i+0.5,i+0.5];
    Y=[0,1];
    plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
end
legend([b_1(8,1) b_2(8,1) b_3(8,1)],{'IVA','GIG-ICA','GT'},3)


h8=figure;
bar([IVAReliaDifICNum;GIGReliaDifICNum;GTReliaDifICNum]','group');
mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ResultSummary\Reliability'));
cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\MatchIVAGIGGT\ResultSummary\Reliability'));
saveas(h7,'ReliabilitySummary.fig');
saveas(h7,'ReliabilitySummary.png');
saveas(h8,'ReliabilitySummaryBar.fig');
saveas(h8,'ReliabilitySummaryBar.png');

save('GTVecSubSimAllICDifICNum','GTVecSubSimAllICDifICNum');
save('GIGVecSubSimAllICDifICNum','GIGVecSubSimAllICDifICNum');
save('IVAVecSubSimAllICDifICNum','IVAVecSubSimAllICDifICNum');
