%duyuhui,2017,04,01
%add statistical analyses to measure the component/IC accuracy

%%
%for different CNR
clc;
clear all;
close all;
OutParameter='BaseTran5TheSpr3DifCNRUniHFTC_Exp12';
dateP='CompareGIGIVA_DifCNR5to20_GIGdualTC_Accu_Inde_161218';
load(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(OutParameter),num2str(dateP),'\MeanSMSG1DifSNR.mat'));
load(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(OutParameter),num2str(dateP),'\MeanSMSG2DifSNR.mat'));

load(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(OutParameter),num2str(dateP),'\MeanTCSG1DifSNR.mat'));
load(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(OutParameter),num2str(dateP),'\MeanTCSG2DifSNR.mat'));

SMSPairTtestTval=zeros(1,16);
SMSPairTtestPval=zeros(1,16);
TCSPairTtestTval=zeros(1,16);
TCSPairTtestPval=zeros(1,16);
for i=1:16
    [h,SMSp,ci,stats]=ttest(MeanSMSG1DifSNR(:,i),MeanSMSG2DifSNR(:,i),0.05,'both');
    SMSt=stats.tstat;
    SMSPairTtestTval(1,i)=SMSt;
    SMSPairTtestPval(1,i)=SMSp;
    
    [h,TCSp,ci,stats]=ttest(MeanTCSG1DifSNR(:,i),MeanTCSG2DifSNR(:,i),0.05,'both');
    TCSt=stats.tstat;
    TCSPairTtestTval(1,i)=TCSt;
    TCSPairTtestPval(1,i)=TCSp;
end

SumAccPairTtest=[SMSPairTtestPval;SMSPairTtestTval;TCSPairTtestPval;TCSPairTtestTval];
mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(OutParameter),num2str(dateP),'\AccuracyTtest170401'));
cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(OutParameter),num2str(dateP),'\AccuracyTtest170401'));
save('SumAccPairTtest','SumAccPairTtest');
xlswrite('SumAccPairTtest',SumAccPairTtest);

%%
%for different TP
clc;
clear all;
close all;

dateP='CompareGIGIVA_DifTP_GIGdualTC_Accu_Inde_161218';
OutParameter='BaseTran5TheSpr3CNR20UniHFTC_Exp12';


load(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(OutParameter),num2str(dateP),'\MeanSMSG1DifTP.mat'));
load(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(OutParameter),num2str(dateP),'\MeanSMSG2DifTP.mat'));

load(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(OutParameter),num2str(dateP),'\MeanTCSG1DifTP.mat'));
load(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(OutParameter),num2str(dateP),'\MeanTCSG2DifTP.mat'));

SMSPairTtestTval=zeros(1,5);
SMSPairTtestPval=zeros(1,5);
TCSPairTtestTval=zeros(1,5);
TCSPairTtestPval=zeros(1,5);
for i=1:5
    [h,SMSp,ci,stats]=ttest(MeanSMSG1DifTP(:,i),MeanSMSG2DifTP(:,i),0.05,'both');
    SMSt=stats.tstat;
    SMSPairTtestTval(1,i)=SMSt;
    SMSPairTtestPval(1,i)=SMSp;
    
    [h,TCSp,ci,stats]=ttest(MeanTCSG1DifTP(:,i),MeanTCSG2DifTP(:,i),0.05,'both');
    TCSt=stats.tstat;
    TCSPairTtestTval(1,i)=TCSt;
    TCSPairTtestPval(1,i)=TCSp;
end

SumAccPairTtest=[SMSPairTtestPval;SMSPairTtestTval;TCSPairTtestPval;TCSPairTtestTval];
mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(OutParameter),num2str(dateP),'\AccuracyTtest170401'));
cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(OutParameter),num2str(dateP),'\AccuracyTtest170401'));
save('SumAccPairTtest','SumAccPairTtest');
xlswrite('SumAccPairTtest',SumAccPairTtest);

%%
%for different source number
 clc;
clear all;
close all;

dateP='CompareGIGIVA_DifSourceNum_GIGdualTC_161218';
OutParameter='BaseTran5TheSpr3CNR2UniHFTC_Exp3';

load(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(OutParameter),num2str(dateP),'\MatchIVAGIGGT\ResultSummary\Accuracy\MeanSMSG1DifICNum.mat'));
load(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(OutParameter),num2str(dateP),'\MatchIVAGIGGT\ResultSummary\Accuracy\MeanSMSG2DifICNum.mat'));

load(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(OutParameter),num2str(dateP),'\MatchIVAGIGGT\ResultSummary\Accuracy\MeanTCSG1DifICNum.mat'));
load(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(OutParameter),num2str(dateP),'\MatchIVAGIGGT\ResultSummary\Accuracy\MeanTCSG2DifICNum.mat'));

SMSPairTtestTval=zeros(1,2);
SMSPairTtestPval=zeros(1,2);
TCSPairTtestTval=zeros(1,2);
TCSPairTtestPval=zeros(1,2);
for i=1:2
    [h,SMSp,ci,stats]=ttest(MeanSMSG1DifICNum(:,i),MeanSMSG2DifICNum(:,i),0.02,'both');
    SMSt=stats.tstat;
    SMSPairTtestTval(1,i)=SMSt;
    SMSPairTtestPval(1,i)=SMSp;
    
    [h,TCSp,ci,stats]=ttest(MeanTCSG1DifICNum(:,i),MeanTCSG2DifICNum(:,i),0.02,'both');
    TCSt=stats.tstat;
    TCSPairTtestTval(1,i)=TCSt;
    TCSPairTtestPval(1,i)=TCSp;
end

SumAccPairTtest=[SMSPairTtestPval;SMSPairTtestTval;TCSPairTtestPval;TCSPairTtestTval];
mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(OutParameter),num2str(dateP),'\AccuracyTtest170401'));
cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(OutParameter),num2str(dateP),'\AccuracyTtest170401'));
save('SumAccPairTtest','SumAccPairTtest');
xlswrite('SumAccPairTtest',SumAccPairTtest);


%%
%for biased source number
 clc;
clear all;
close all;

dateP='CompareGIGIVA_BiasedICnum_GIGOwnTC_161218';
OutParameter='BaseTran5TheSpr3CNR20UniHFTC_Exp12';

load(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(OutParameter),num2str(dateP),'\MatchIVAGIGGT\ResultSummary\Accuracy\MeanSMSG1DifICNum.mat'));
load(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(OutParameter),num2str(dateP),'\MatchIVAGIGGT\ResultSummary\Accuracy\MeanSMSG2DifICNum.mat'));

load(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(OutParameter),num2str(dateP),'\MatchIVAGIGGT\ResultSummary\Accuracy\MeanTCSG1DifICNum.mat'));
load(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(OutParameter),num2str(dateP),'\MatchIVAGIGGT\ResultSummary\Accuracy\MeanTCSG2DifICNum.mat'));

SMSPairTtestTval=zeros(1,3);
SMSPairTtestPval=zeros(1,3);
TCSPairTtestTval=zeros(1,3);
TCSPairTtestPval=zeros(1,3);
for i=1:3
    [h,SMSp,ci,stats]=ttest(MeanSMSG1DifICNum(:,i),MeanSMSG2DifICNum(:,i),0.02,'both');
    SMSt=stats.tstat;
    SMSPairTtestTval(1,i)=SMSt;
    SMSPairTtestPval(1,i)=SMSp;
    
    [h,TCSp,ci,stats]=ttest(MeanTCSG1DifICNum(:,i),MeanTCSG2DifICNum(:,i),0.02,'both');
    TCSt=stats.tstat;
    TCSPairTtestTval(1,i)=TCSt;
    TCSPairTtestPval(1,i)=TCSp;
end

SumAccPairTtest=[SMSPairTtestPval;SMSPairTtestTval;TCSPairTtestPval;TCSPairTtestTval];
mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(OutParameter),num2str(dateP),'\AccuracyTtest170401'));
cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(OutParameter),num2str(dateP),'\AccuracyTtest170401'));
save('SumAccPairTtest','SumAccPairTtest');
xlswrite('SumAccPairTtest',SumAccPairTtest);


%%
%for unique-source experiment, I need to rerun it. 
