%duyuhui,2014,5.30
%compare GIG-ICA and IVA.

clc;
clear all;
close all;

date='CompareGIGIVA__ownTC_140618';

DataParameter='BaseTran4TheSpr2CNR2UniTC_Exp4'
%DataParameter='BaseTran5TheSpr3CNR15UniHFTC_Exp4'

CMdata = load('CM_coldhot_256');
CMAP = CMdata.CM;
%mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\PreviousSimTBData\',num2str(DataParameter),num2str(date)));
ICnum=8;%real ICnum, not used here.
timepoints=150;
M=148;N=148;L=1;
sbnum=10;
v0=spm_vol(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\PreviousSimTBData\',num2str(DataParameter),'\',num2str(DataParameter),'_MASK.nii'));
MaskData=spm_read_vols(v0);
MaskData=round(MaskData);
VoxNum=size(find(MaskData==1),1);
MaskVec=reshape(MaskData,1,[]);



%%
    %compute templates, and use the templates to match results from GIG-ICA(or
    %IVA)and real sources
    SumTemIC=zeros(ICnum,M*N);
    for i=1:sbnum %if here sbnum=1, that is just use GT of one subject as templates, in such case nosie components can not be removed accurately.
        if i<10
            strzero='00';
        else if i>9&&i<100
                strzero='0';
            end
        end
        
        %we can use the ground truth source to find the nosie components
        load (strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\PreviousSimTBData\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_SIM.mat'));
        
        RealSouMat=[SM(1:7,:);SM(i+7,:)];
        SumTemIC=SumTemIC+RealSouMat;
        
    end
    TemIC=SumTemIC/sbnum;
    TemICInMask=zeros(ICnum,VoxNum);
    h=1;
    for k=1:M*N*L
        if MaskVec(k)==1
            TemICInMask(:,h)=TemIC(:,k);
            h=h+1;
        end
    end
    
    %%
    
    % mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\PreviousSimTBData\',num2str(DataParameter),num2str(date),'\IVA\IVA_R',num2str(R)));
    
    FirIndiIC=zeros(sbnum*ICnum,VoxNum);
    
    FmriMatr=[];data=[]; FmriMatMaskAllSub=[];
    IVASubPC1num=8;
    for i=1:sbnum
        if i<10
            strzero='00';
        else if i>9&&i<100
                strzero='0';
            end
        end
        v=spm_vol(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\PreviousSimTBData\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_DATA.nii'));
        dat=spm_read_vols(v);
        for j=1:timepoints
            FmriVec=reshape(dat(:,:,:,j),1,[]);
            FmriMatr(j,:) = FmriVec;
        end
        %     figure;
        %     imshow(reshape(FmriMatr(1,:),M,N),[]);
        %1).implement individual ICA
        
        FmriMatMask=zeros(timepoints,VoxNum);
        h=1;
        for k=1:M*N*L
            if MaskVec(k)==1
                FmriMatMask(:,h)=FmriMatr(:,k);
                h=h+1;
            end
        end
        FmriMatMaskAllSub(:,:,i)=FmriMatMask;
        [IndiPCAOut,WhitenMatrix,DewhitenMatrix]=GIG_CalPCA(FmriMatMask',IVASubPC1num);
        
        data(:,:,i)=IndiPCAOut';
        
    end
   
    W = icatb_iva_second_order(data, 'whiten', false);
    ICA_Options = {'maxIter', 1024, 'termThreshold', 1e-6, 'alpha0', 0.1, 'verbose', true,'whiten', false, 'initW', W};
    
    disp('Weights from second order IVA are used as initial weights in laplacian IVA. Computing laplacian IVA ...');
    W = icatb_iva_laplace(data, ICA_Options{:}); % run iva-l, initialized with iva-g result
    
    for n = 1:size(W, 3)
        S = squeeze(W(:, :, n)*data(:, :, n))';
        sk = sign(icatb_skewness(S) + eps);
        W(:, :, n) = diag(sk)*W(:, :, n);
        clear S;
    end
    
    IVAICAllsubMat=zeros(size(data));
    for i=1:sbnum
        IVAICAllsubMat(:,:,i)=W(:,:,i)*data(:,:,i);
    end
    
    for i=1:sbnum
        IVAICMat=IVAICAllsubMat(:,:,i);
        IVAIndiICPlMask=zeros(IVASubPC1num,M*N*L);
        h=1;
        for K=1:M*N*L
            if MaskVec(K)==0
                IVAIndiICPlMask(:,K)=0;
            else
                IVAIndiICPlMask(:,K)=IVAICMat(:,h);
                h=h+1;
            end
        end
        
        h0=figure;
        for k=1:IVASubPC1num
            subplot(IVASubPC1num,1,k);
            imshow(reshape(IVAIndiICPlMask(k,:),M,N),[]);
            
        end
        
    end
    
    %evaluate IVA's results
    %compute the mean IC maps across subjects for matching with template
    IVAICAllsubMatMean=mean(IVAICAllsubMat,3);
    
    SimGICsN1Tem=corr(IVAICAllsubMatMean',TemICInMask');%
    %following is another matching method
    MatchV=[];
    MatchH=[];
    MatchL=[];
    DirectioN1GB=[];
    SimGICsN1TemG=SimGICsN1Tem;
    for i=1:ICnum
        MaxValue=max(max(abs(SimGICsN1TemG)));
        MatchV=[MatchV,MaxValue];
        if size(find(SimGICsN1TemG==MaxValue),1)
            P=find(SimGICsN1TemG==MaxValue);
            DirectioN1GB(i)=1;
        else if size(find(SimGICsN1TemG==-MaxValue),1)
                P=find(SimGICsN1TemG==-MaxValue);
                DirectioN1GB(i)=-1;
            end
        end
        
        Lie=ceil(P/ICnum);
        Hang=mod(P,ICnum);
        if Hang==0
            Hang=ICnum;
        end
        MatchH=[MatchH,Hang];
        MatchL=[MatchL,Lie];
        SimGICsN1TemG(Hang,:)=0;
        SimGICsN1TemG(:,Lie)=0;
    end
    
    [a,b]=sort(MatchL);
    Order1G=MatchH(b);
    
    
    for i=1:sbnum
        %load GT IC and TC
        if i<10
            strzero='00';
        else if i>9&&i<100
                strzero='0';
            end
        end
        
        %use the ground truth source to find the nosie components in IRPG    
        load (strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\PreviousSimTBData\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_SIM.mat'));
        RealSouMat=[SM(1:7,:);SM(i+7,:)];
        RealTCMat=[TC(:,1:7),TC(:,i+7)];
        RealSouInMask=zeros(ICnum,VoxNum);
        h=1;
        for k=1:M*N*L
            if MaskVec(k)==1
                RealSouInMask(:,h)=RealSouMat(:,k);
                h=h+1;
            end
        end
        RealSouInMaskZ=[]; %z-score the value of GT IC in mask.
        for IC=1:ICnum
            RealSouInMaskZ(IC,:)=(RealSouInMask(IC,:)-mean(RealSouInMask(IC,:)))/std(RealSouInMask(IC,:));  
        end
        RealTCMatZ=[];
        for tc=1:ICnum
            RealTCMatZ(:,tc)=(RealTCMat(:,tc)-mean(RealTCMat(:,tc)))/std(RealTCMat(:,tc));     
        end
        
        %%
        IVAICMat=IVAICAllsubMat(:,:,i);  
        IVATCMat=FmriMatMaskAllSub(:,:,i)*pinv(IVAICMat);
        IVATCMatZ=[];
        for tcorder=1:size(IVATCMat,2)
        IVATCMatZ(:,tcorder)=(IVATCMat(:,tcorder)-mean(IVATCMat(:,tcorder)))/std(IVATCMat(:,tcorder));
        end
        
        
        %change the order of GIG result
        IVATCMatCO=zeros(timepoints,ICnum);
        IVAICMatCO=zeros(ICnum,VoxNum);
        for ICorder=1:ICnum
            IVAICMatCO(ICorder,:)=IVAICMat(Order1G(ICorder),:);
            IVATCMatCO(:,ICorder)= IVATCMat(:,Order1G(ICorder));
        end
        %change the order of z-scored IVA TC result
        IVATCMatCOZ=zeros(timepoints,ICnum);
        for ICorder=1:ICnum
            IVATCMatCOZ(:,ICorder)=IVATCMatZ(:,Order1G(ICorder));
        end
        
        [IndiIC1RealSMSim,IndiIC1ReSm]=SMSim(IVAICMatCO,RealSouInMask);
        [IndiTC1RealTCSim,IndiTC1ReTc]=TCSim(IVATCMatCO,RealTCMat);
        
        [IndiIC1RealSMSimZ,IndiIC1ReSmZ]=SMSim(IVAICMatCO,RealSouInMaskZ);
        [IndiTC1RealTCSimZ,IndiTC1ReTcZ]=TCSim(IVATCMatCOZ,RealTCMatZ);
        
        SMS1(i,:)=IndiIC1ReSm';
        TCS1(i,:)=IndiTC1ReTc';
        MeanSMSG1(i)=mean(IndiIC1ReSm);
        MeanTCSG1(i)=mean(IndiTC1ReTc);
        
        
        IVAICMatPlMask=zeros(size(IVAICMat,1),M*N*L);
        RealSouMatZ=zeros(size(IVAICMat,1),M*N*L);%z scored GT IC plus mask.
        h=1;
        for K=1:M*N*L
            if MaskVec(K)==0
                IVAICMatPlMask(:,K)=0;
                RealSouMatZ(:,K)=0;
            else
                IVAICMatPlMask(:,K)=IVAICMat(:,h);
                RealSouMatZ(:,K)=RealSouInMaskZ(:,h);
                h=h+1;
            end
        end
        
        
        %if i==1||i==3||i==7;
        h00=figure;
        for k=1:IVASubPC1num
            subplot(IVASubPC1num,5,5*k-3);
            imshow(reshape(IVAICMatPlMask(Order1G(k),:),M,N),[]);
            tmp = sprintf('%.4f', IndiIC1ReSm(k));
            title(['\bf {IVA IC} ',int2str(k),' (',tmp,')'],'fontsize',8);
            
            
            subplot(IVASubPC1num,5,5*k-2);
            plot(IVATCMatZ(:,Order1G(k)));
            tmp = sprintf('%.4f', IndiTC1ReTc(k));
            title(['\bf {IVA TC} ',int2str(k),' (',tmp,')'],'fontsize',8);
            xlim([0 timepoints]);
            ylim([-4 4]);
            
            subplot(IVASubPC1num,5,5*k-1);
            imshow(reshape(RealSouMatZ(k,:),M,N),[]);
            title(['\bf {GT IC} ',int2str(k)],'fontSize',8);
            subplot(IVASubPC1num,5,5*k);
            plot(RealTCMatZ(:,k));
            title(['\bf {GT TC} ',int2str(k)],'fontSize',8);
            xlim([0 timepoints]);
            ylim([-4 4]);
        end
    end
    
    
    
    
    
    %%
    %GIG-ICA
    
    %1.set some parameters
    GIGSubPCnum=8;
    GIGGroupPCnum=8;
    
    %2.read data, and implement subject PCA.
    for i=1:sbnum
        if i<10
            strzero='00';
        else if i>9&&i<100
                strzero='0';
            end
        end
        
        v=spm_vol(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\PreviousSimTBData\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_DATA.nii'));
        dat=spm_read_vols(v);
        for j=1:timepoints
            FmriVec=reshape(dat(:,:,:,j),1,[]);
            FmriMatr(j,:) = FmriVec;
        end
        
        FmriMatMask=zeros(timepoints,VoxNum);
        h=1;
        for k=1:M*N*L
            if MaskVec(k)==1
                FmriMatMask(:,h)=FmriMatr(:,k);
                h=h+1;
            end
        end
        
        IndiPCAData=GIG_CalPCA( FmriMatMask',GIGSubPCnum); %subject level PCA
        SubPCAOut(:,GIGSubPCnum*(i-1)+1:GIGSubPCnum*i)=IndiPCAData;%
    end
    
    GroupPCAOut=GIG_CalPCA(SubPCAOut,GIGGroupPCnum); %
    
    disp('Start group level ICA for geting group components......................................');
    %group ICA
    algorithmName='Infomax';
    %use the ICASSO
    %[A, GICs] = useICASSO(GroupPCAOut', algorithmName);
    [W2, A2, GICs2] = GIG_IcaAlgorithm(algorithmName, GroupPCAOut');
    clear SubPCAOut;
    clear GroupPCAOut;
    GICsN2=zeros(GIGGroupPCnum,VoxNum);
    %normalize the GICs for output or for the consequent average
    GICsC2=GICs2-repmat(mean(GICs2,2),[1,VoxNum]);
    for i=1:size(GICs2,1)
        GICsN2(i,:)=GICsC2(i,:)/std(GICsC2(i,:));
    end
    
    %evaluate the results
    %match GIG-ICA and real sources
    SimGICsN2Tem=corr(GICsN2',TemICInMask');%
    %following is another matching method
    MatchV=[];
    MatchH=[];
    MatchL=[];
    Direction2GB=[];
    SimGICsN2TemG=SimGICsN2Tem;
    for i=1:ICnum
        MaxValue=max(max(abs(SimGICsN2TemG)));
        MatchV=[MatchV,MaxValue];
        if size(find(SimGICsN2TemG==MaxValue),1)
            P=find(SimGICsN2TemG==MaxValue);
            Direction2GB(i)=1;
        else if size(find(SimGICsN2TemG==-MaxValue),1)
                P=find(SimGICsN2TemG==-MaxValue);
                Direction2GB(i)=-1;
            end
        end
        
        Lie=ceil(P/ICnum);
        Hang=mod(P,ICnum);
        if Hang==0
            Hang=ICnum;
        end
        MatchH=[MatchH,Hang];
        MatchL=[MatchL,Lie];
        SimGICsN2TemG(Hang,:)=0;
        SimGICsN2TemG(:,Lie)=0;
    end
    
    [a,b]=sort(MatchL);
    Order2G=MatchH(b);
    
    for i=1:sbnum
        if i<10
            strzero='00';
        else if i>9&&i<100
                strzero='0';
            end
        end
        v=spm_vol(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\PreviousSimTBData\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_DATA.nii'));
        dat=spm_read_vols(v);
        for j=1:timepoints
            FmriVec=reshape(dat(:,:,:,j),1,[]);
            FmriMatr(j,:) = FmriVec;
        end
        
        FmriMatMask=zeros(timepoints,VoxNum);
        h=1;
        for k=1:M*N*L
            if MaskVec(k)==1
                FmriMatMask(:,h)=FmriMatr(:,k);
                h=h+1;
            end
        end
        
        nemda=0;
        a=0.5;
        [GIGICMat,UnmixMat,GIGTCMat,ObFunc,C,IterMat]=GIGICAArReInCISGamaArmiTGWRSF(FmriMatMask,GIGGroupPCnum,GICsN2,a,nemda);
        %GIGTCMat=FmriMatMask*pinv(GIGICMat);
        
        
        %         GIGICMatPlMask=zeros(size(GIGICMat,1),M*N*L);
        %         h=1;
        %         for K=1:M*N*L
        %             if MaskVec(K)==0
        %                 GIGICMatPlMask(:,K)=0;
        %             else
        %                 GIGICMatPlMask(:,K)=GIGICMat(:,h);
        %                 h=h+1;
        %             end
        %         end
        %         h00=figure;
        %         for k=1:8
        %             subplot(8,1,k);
        %             imshow(reshape(GIGICMatPlMask(k,:),M,N),[]);
        %             %title(['\bf {GIG-ICA IC} ',int2str(k),'
        %             %(',num2str(vpa(IndiIC2ReSm(k)),4),')'],'fontsize',8);
        %             %tmp = sprintf('%.4f', IndiIC2ReSm(k));
        %             %title(['\bf {GIG-ICA IC} ',int2str(k),' (',tmp,')'],'fontsize',8);
        %         end
        
        
        %change the order of GIG result
        GIGTCMatCO=zeros(timepoints,size(GICsN2,1));
        GIGICMatCO=zeros(size(GICsN2,1),VoxNum);
        for ICorder=1:size(GICsN2,1)
            GIGICMatCO(ICorder,:)=GIGICMat(Order2G(ICorder),:);
            GIGTCMatCO(:,ICorder)= GIGTCMat(:,Order2G(ICorder));
        end
        GIGTCMatZ=[];  
        for tc=1:size(GIGTCMat,2)
            GIGTCMatZ(:,tc)=(GIGTCMat(:,tc)-mean(GIGTCMat(:,tc)))/std(GIGTCMat(:,tc));            
        end
        %change the order of z-scored GIG TC result
        GIGTCMatCOZ=zeros(timepoints,size(GICsN2,1));
        for ICorder=1:size(GICsN2,1)
            GIGTCMatCOZ(:,ICorder)=GIGTCMatZ(:,Order2G(ICorder));
        end
        
        
        %%
        %load GT IC and TC
        if i<10
            strzero='00';
        else if i>9&&i<100
                strzero='0';
            end
        end
        
        %use the ground truth source to find the nosie components in IRPG    
        load (strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\PreviousSimTBData\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_SIM.mat'));
        RealSouMat=[SM(1:7,:);SM(i+7,:)];
        RealTCMat=[TC(:,1:7),TC(:,i+7)];
        RealSouInMask=zeros(ICnum,VoxNum);
        h=1;
        for k=1:M*N*L
            if MaskVec(k)==1
                RealSouInMask(:,h)=RealSouMat(:,k);
                h=h+1;
            end
        end
        RealSouInMaskZ=[]; %z-score the value of GT IC in mask.
        for IC=1:ICnum
            RealSouInMaskZ(IC,:)=(RealSouInMask(IC,:)-mean(RealSouInMask(IC,:)))/std(RealSouInMask(IC,:));  
        end
        RealTCMatZ=[];
        for tc=1:ICnum
            RealTCMatZ(:,tc)=(RealTCMat(:,tc)-mean(RealTCMat(:,tc)))/std(RealTCMat(:,tc));     
        end
        
        %%
        [IndiIC2RealSMSim,IndiIC2ReSm]=SMSim(GIGICMatCO,RealSouInMask);
        [IndiTC2RealTCSim,IndiTC2ReTc]=TCSim(GIGTCMatCO,RealTCMat);
        
        [IndiIC2RealSMSimZ,IndiIC2ReSmZ]=SMSim(GIGICMatCO,RealSouInMaskZ);
        [IndiTC2RealTCSimZ,IndiTC2ReTcZ]=TCSim(GIGTCMatCOZ,RealTCMatZ);
        
        SMS2(i,:)=IndiIC2ReSm';
        TCS2(i,:)=IndiTC2ReTc';
        MeanSMSG2(i)=mean(IndiIC2ReSm);
        MeanTCSG2(i)=mean(IndiTC2ReTc);
        
        
        GIGICMatPlMask=zeros(size(GIGICMat,1),M*N*L);
        RealSouMatZ=zeros(size(GIGICMat,1),M*N*L);%z scored GT IC plus mask.
        h=1;
        for K=1:M*N*L
            if MaskVec(K)==0
                GIGICMatPlMask(:,K)=0;
                RealSouMatZ(:,K)=0;
            else
                GIGICMatPlMask(:,K)=GIGICMat(:,h);
                RealSouMatZ(:,K)=RealSouInMaskZ(:,h);
                h=h+1;
            end
        end
        
        
        %if i==1||i==3||i==7;
        h00=figure;
        for k=1:size(GICsN2,1)
            subplot(size(GICsN2,1),5,5*k-3);
            imshow(reshape(GIGICMatPlMask(Order2G(k),:),M,N),[]);
            tmp = sprintf('%.4f', IndiIC2ReSm(k));
            title(['\bf {GIG-ICA IC} ',int2str(k),' (',tmp,')'],'fontsize',8);
            
            
            subplot(size(GICsN2,1),5,5*k-2);
            plot(GIGTCMatZ(:,Order2G(k)));
            tmp = sprintf('%.4f', IndiTC2ReTc(k));
            title(['\bf {GIG-ICA TC} ',int2str(k),' (',tmp,')'],'fontsize',8);
            xlim([0 timepoints]);
            ylim([-4 4]);
            
            subplot(size(GICsN2,1),5,5*k-1);
            imshow(reshape(RealSouMatZ(k,:),M,N),[]);
            title(['\bf {GT IC} ',int2str(k)],'fontSize',8);
            subplot(size(GICsN2,1),5,5*k);
            plot(RealTCMatZ(:,k));
            title(['\bf {GT TC} ',int2str(k)],'fontSize',8);
            xlim([0 timepoints]);
            ylim([-4 4]);
            
            
        end
        
    end
    
     mean(MeanSMSG1)
     mean(MeanSMSG2)
      mean(MeanTCSG1)
       mean(MeanTCSG2)

       
            mean(MeanSMSG1(1:7))
     mean(MeanSMSG2(1:7))
      mean(MeanTCSG1(1:7))
       mean(MeanTCSG2(1:7))