%duyuhui,2014,5.30
%compare GIG-ICA and IVA.
%different time points
clc;
clear all;
close all;

date='CompareGIGIVA_140616';
DataParameter='BaseTran5TheSpr3CNR10UniHFTC_Exp12';
%DataParameter='BaseTran6TheSpr4CNR2UniTC_Exp12';

CMdata = load('CM_coldhot_256');
CMAP = CMdata.CM;
ICnum=8;%real ICnum, not used here.
timepoints=150;
M=148;N=148;L=1;
sbnum=10;
v0=spm_vol(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\PreviousSimTBData\BaseTran5TheSpr3DifCNRUniHFTC_Exp12\',num2str(DataParameter),'\',num2str(DataParameter),'_MASK.nii'));
MaskData=spm_read_vols(v0);
MaskData=round(MaskData);
VoxNum=size(find(MaskData==1),1);
MaskVec=reshape(MaskData,1,[]);

for timepoints=40:20:120
    
    %compute templates, and use the templates to match results from GIG-ICA(or
    %IVA)and real sources
    SumTemIC=zeros(ICnum,M*N);
    for i=1:sbnum %if here sbnum=1, that is just use GT of one subject as templates, in such case nosie components can not be removed accurately.
        if i<10
            strzero='00';
        else if i>9&&i<100
                strzero='0';
            end
        end
        
        %we can use the ground truth source to find the nosie components
        load (strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\PreviousSimTBData\BaseTran5TheSpr3DifCNRUniHFTC_Exp12\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_SIM.mat'));
        SumTemIC=SumTemIC+SM;
        
    end
    TemIC=SumTemIC/sbnum;
    TemICInMask=zeros(ICnum,VoxNum);
    h=1;
    for k=1:M*N*L
        if MaskVec(k)==1
            TemICInMask(:,h)=TemIC(:,k);
            h=h+1;
        end
    end
    
    %%
    
    % mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\PreviousSimTBData\BaseTran5TheSpr3DifCNRUniHFTC_Exp12\',num2str(DataParameter),num2str(date),'\IVA\IVA_R',num2str(R)));
    
    FirIndiIC=zeros(sbnum*ICnum,VoxNum);
    
    FmriMatr=[];data=[]; FmriMatMaskAllSub=[];
    IVASubPC1num=8;
    for i=1:sbnum
        if i<10
            strzero='00';
        else if i>9&&i<100
                strzero='0';
            end
        end
        v=spm_vol(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\PreviousSimTBData\BaseTran5TheSpr3DifCNRUniHFTC_Exp12\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_DATA.nii'));
        dat=spm_read_vols(v);
        for j=1:timepoints
            FmriVec=reshape(dat(:,:,:,j),1,[]);
            FmriMatr(j,:) = FmriVec;
        end
        %     figure;
        %     imshow(reshape(FmriMatr(1,:),M,N),[]);
        %1).implement individual ICA
        
        FmriMatMask=zeros(timepoints,VoxNum);
        h=1;
        for k=1:M*N*L
            if MaskVec(k)==1
                FmriMatMask(:,h)=FmriMatr(:,k);
                h=h+1;
            end
        end
        FmriMatMaskAllSub(:,:,i)=FmriMatMask;
        [IndiPCAOut,WhitenMatrix,DewhitenMatrix]=GIG_CalPCA(FmriMatMask',IVASubPC1num);
        
        data(:,:,i)=IndiPCAOut';
        
    end
    
    W = icatb_iva_second_order(data, 'whiten', false);
    ICA_Options = {'maxIter', 1024, 'termThreshold', 1e-6, 'alpha0', 0.1, 'verbose', true,'whiten', false, 'initW', W};
    
    disp('Weights from second order IVA are used as initial weights in laplacian IVA. Computing laplacian IVA ...');
    W = icatb_iva_laplace(data, ICA_Options{:}); % run iva-l, initialized with iva-g result
    
    for n = 1:size(W, 3)
        S = squeeze(W(:, :, n)*data(:, :, n))';
        sk = sign(icatb_skewness(S) + eps);
        W(:, :, n) = diag(sk)*W(:, :, n);
        clear S;
    end
    
    IVAICAllsubMat=zeros(size(data));
    for i=1:sbnum
        IVAICAllsubMat(:,:,i)=W(:,:,i)*data(:,:,i);
    end
    
    for i=1:sbnum
        IVAICMat=IVAICAllsubMat(:,:,i);
        IVAIndiICPlMask=zeros(IVASubPC1num,M*N*L);
        h=1;
        for K=1:M*N*L
            if MaskVec(K)==0
                IVAIndiICPlMask(:,K)=0;
            else
                IVAIndiICPlMask(:,K)=IVAICMat(:,h);
                h=h+1;
            end
        end
        
        h0=figure;
        for k=1:IVASubPC1num
            subplot(IVASubPC1num,1,k);
            imshow(reshape(IVAIndiICPlMask(k,:),M,N),[]);
            
        end
        
    end
    
    %evaluate IVA's results
    %compute the mean IC maps across subjects for matching with template
    IVAICAllsubMatMean=mean(IVAICAllsubMat,3);
    
    SimGICsN1Tem=corr(IVAICAllsubMatMean',TemICInMask');%
    %following is another matching method
    MatchV=[];
    MatchH=[];
    MatchL=[];
    DirectioN1GB=[];
    SimGICsN1TemG=SimGICsN1Tem;
    for i=1:ICnum
        MaxValue=max(max(abs(SimGICsN1TemG)));
        MatchV=[MatchV,MaxValue];
        if size(find(SimGICsN1TemG==MaxValue),1)
            P=find(SimGICsN1TemG==MaxValue);
            DirectioN1GB(i)=1;
        else if size(find(SimGICsN1TemG==-MaxValue),1)
                P=find(SimGICsN1TemG==-MaxValue);
                DirectioN1GB(i)=-1;
            end
        end
        
        Lie=ceil(P/ICnum);
        Hang=mod(P,ICnum);
        if Hang==0
            Hang=ICnum;
        end
        MatchH=[MatchH,Hang];
        MatchL=[MatchL,Lie];
        SimGICsN1TemG(Hang,:)=0;
        SimGICsN1TemG(:,Lie)=0;
    end
    
    [a,b]=sort(MatchL);
    Order1G=MatchH(b);
    
    
    for i=1:sbnum
        %load GT IC and TC
        if i<10
            strzero='00';
        else if i>9&&i<100
                strzero='0';
            end
        end
        
        %use the ground truth source to find the nosie components in IRPG
        load (strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\PreviousSimTBData\BaseTran5TheSpr3DifCNRUniHFTC_Exp12\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_SIM.mat'));
        RealSouMat=SM;
        RealTCMat=TC(1:timepoints,:);
        RealSouInMask=zeros(ICnum,VoxNum);
        h=1;
        for k=1:M*N*L
            if MaskVec(k)==1
                RealSouInMask(:,h)=RealSouMat(:,k);
                h=h+1;
            end
        end
        RealSouInMaskZ=[]; %z-score the value of GT IC in mask.
        for IC=1:ICnum
            RealSouInMaskZ(IC,:)=(RealSouInMask(IC,:)-mean(RealSouInMask(IC,:)))/std(RealSouInMask(IC,:));
        end
        RealTCMatZ=[];
        for tc=1:ICnum
            RealTCMatZ(:,tc)=(RealTCMat(:,tc)-mean(RealTCMat(:,tc)))/std(RealTCMat(:,tc));
        end
        
        %%
        IVAICMat=IVAICAllsubMat(:,:,i);
        IVATCMat=FmriMatMaskAllSub(:,:,i)*pinv(IVAICMat);
        IVATCMatZ=[];
        for tcorder=1:size(IVATCMat,2)
            IVATCMatZ(:,tcorder)=(IVATCMat(:,tcorder)-mean(IVATCMat(:,tcorder)))/std(IVATCMat(:,tcorder));
        end
        
        
        %change the order of GIG result
        IVATCMatCO=zeros(timepoints,ICnum);
        IVAICMatCO=zeros(ICnum,VoxNum);
        for ICorder=1:ICnum
            IVAICMatCO(ICorder,:)=IVAICMat(Order1G(ICorder),:);
            IVATCMatCO(:,ICorder)= IVATCMat(:,Order1G(ICorder));
        end
        %change the order of z-scored IVA TC result
        IVATCMatCOZ=zeros(timepoints,ICnum);
        for ICorder=1:ICnum
            IVATCMatCOZ(:,ICorder)=IVATCMatZ(:,Order1G(ICorder));
        end
        
        [IndiIC1RealSMSim,IndiIC1ReSm]=SMSim(IVAICMatCO,RealSouInMask);
        [IndiTC1RealTCSim,IndiTC1ReTc]=TCSim(IVATCMatCO,RealTCMat);
        
        [IndiIC1RealSMSimZ,IndiIC1ReSmZ]=SMSim(IVAICMatCO,RealSouInMaskZ);
        [IndiTC1RealTCSimZ,IndiTC1ReTcZ]=TCSim(IVATCMatCOZ,RealTCMatZ);
        
        SMS1(i,:)=IndiIC1ReSm';
        TCS1(i,:)=IndiTC1ReTc';
        MeanSMSG1(i)=mean(IndiIC1ReSm);
        MeanTCSG1(i)=mean(IndiTC1ReTc);
        
   
        
        IVAICMatPlMask=zeros(size(IVAICMat,1),M*N*L);
        RealSouMatZ=zeros(size(IVAICMat,1),M*N*L);%z scored GT IC plus mask.
        h=1;
        for K=1:M*N*L
            if MaskVec(K)==0
                IVAICMatPlMask(:,K)=0;
                RealSouMatZ(:,K)=0;
            else
                IVAICMatPlMask(:,K)=IVAICMat(:,h);
                RealSouMatZ(:,K)=RealSouInMaskZ(:,h);
                h=h+1;
            end
        end
        
        
        %if i==1||i==3||i==7;
        h00=figure;
        for k=1:IVASubPC1num
            subplot(IVASubPC1num,5,5*k-3);
            imshow(reshape(IVAICMatPlMask(Order1G(k),:),M,N),[]);
            tmp = sprintf('%.4f', IndiIC1ReSm(k));
            title(['\bf {IVA IC} ',int2str(k),' (',tmp,')'],'fontsize',8);
            
            
            subplot(IVASubPC1num,5,5*k-2);
            plot(IVATCMatZ(:,Order1G(k)));
            tmp = sprintf('%.4f', IndiTC1ReTc(k));
            title(['\bf {IVA TC} ',int2str(k),' (',tmp,')'],'fontsize',8);
            xlim([0 timepoints]);
            ylim([-4 4]);
            
            subplot(IVASubPC1num,5,5*k-1);
            imshow(reshape(RealSouMatZ(k,:),M,N),[]);
            title(['\bf {GT IC} ',int2str(k)],'fontSize',8);
            subplot(IVASubPC1num,5,5*k);
            plot(RealTCMatZ(:,k));
            title(['\bf {GT TC} ',int2str(k)],'fontSize',8);
            xlim([0 timepoints]);
            ylim([-4 4]);
        end
    end
    
    
    %boxplot spatial accuracy
    h1=figure;
    set (gcf,'Position',[100,100,600,500], 'color','w')
    b_1=boxplotCsub(SMS1,1,['*'],1,1,'r',2,1,true,[1 4],1.3,0,'ks');
    set(gcf,'color','white')
    xmax=IVASubPC1num+0.5;
    axis([0.5 xmax 0 1])
    set(gca,'ygrid','on');
    set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',16);
    xlabel('ICs','Fontsize',20,'Fontweight','Bold','Fontsize',20);
    ylabel('Spatial accuracy','Fontsize',20,'Fontweight','Bold','Fontsize',20);
    title('IVA spatial accuracy','Fontsize',20,'Fontweight','Bold');
    % hold on;
    % for i=1:7
    %     %X=[xaixs(i)+0.5,xaixs(i)+0.5];
    %     X=[i+0.5,i+0.5];
    %     Y=[0,1];
    %     plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
    % end
    
    %boxplot temporal accuracy
    h2=figure;
    set (gcf,'Position',[100,100,600,500], 'color','w')
    b_1=boxplotCsub(TCS1,1,['*'],1,1,'r',2,1,true,[1 4],1.3,0,'ks');
    set(gcf,'color','white')
    xmax=IVASubPC1num+0.5;
    axis([0.5 xmax 0 1])
    set(gca,'ygrid','on');
    set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',16);
    xlabel('ICs','Fontsize',20,'Fontweight','Bold','Fontsize',20);
    ylabel('Temporal accuracy','Fontsize',20,'Fontweight','Bold','Fontsize',20);
    title('IVA temporal accuracy','Fontsize',20,'Fontweight','Bold');
    % hold on;
    % for i=1:7
    %     %X=[xaixs(i)+0.5,xaixs(i)+0.5];
    %     X=[i+0.5,i+0.5];
    %     Y=[0,1];
    %     plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
    % end
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\',num2str(timepoints)));

    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\',num2str(timepoints)));
    saveas(h1,strcat('IVASpaAcc.fig'));
    saveas(h1,strcat('IVASpaAcc.png'));
    saveas(h2,strcat('IVATemAcc.fig'));
    saveas(h2,strcat('IVATemAcc.png'));
    
    fprintf(strcat('Mean spatial accuracy of IVA method is'));
    MeanSpaAccIVA=mean(MeanSMSG1)
    fprintf(strcat('Mean temporal accuracy of IVA method is'));
    MeanTemAccIVA=mean(MeanTCSG1)
    save('MeanSpaAccIVA','MeanSpaAccIVA');
    save('MeanTemAccIVA','MeanTemAccIVA');
    xlswrite('MeanSpaAccIVA',MeanSpaAccIVA);
    xlswrite('MeanTemAccIVA',MeanTemAccIVA);
    
    MeanSMSG1DifTCL(:,timepoints/20-1)=MeanSMSG1';
    MeanTCSG1DifTCL(:,timepoints/20-1)=MeanTCSG1';
    cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');
    

    close all;
    %%
    %GIG-ICA
    %1.set some parameters
    GIGSubPCnum=8;
    GIGGroupPCnum=8;
    
    %2.read data, and implement subject PCA.
    for i=1:sbnum
        if i<10
            strzero='00';
        else if i>9&&i<100
                strzero='0';
            end
        end
        
        v=spm_vol(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\PreviousSimTBData\BaseTran5TheSpr3DifCNRUniHFTC_Exp12\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_DATA.nii'));
        dat=spm_read_vols(v);
        for j=1:timepoints
            FmriVec=reshape(dat(:,:,:,j),1,[]);
            FmriMatr(j,:) = FmriVec;
        end
        
        FmriMatMask=zeros(timepoints,VoxNum);
        h=1;
        for k=1:M*N*L
            if MaskVec(k)==1
                FmriMatMask(:,h)=FmriMatr(:,k);
                h=h+1;
            end
        end
        
        IndiPCAData= GIG_CalPCA( FmriMatMask',GIGSubPCnum); %subject level PCA
        SubPCAOut(:,GIGSubPCnum*(i-1)+1:GIGSubPCnum*i)=IndiPCAData;%
    end
    
    GroupPCAOut = GIG_CalPCA(SubPCAOut,GIGGroupPCnum); %
    
    disp('Start group level ICA for geting group components......................................');
    %group ICA
    algorithmName='Infomax';
    %use the ICASSO
    %[A, GICs] = useICASSO(GroupPCAOut', algorithmName);
    [W2, A2, GICs2] = GIG_IcaAlgorithm(algorithmName, GroupPCAOut');
    clear SubPCAOut;
    clear GroupPCAOut;
    GICsN2=zeros(GIGGroupPCnum,VoxNum);
    %normalize the GICs for output or for the consequent average
    GICsC2=GICs2-repmat(mean(GICs2,2),[1,VoxNum]);
    for i=1:size(GICs2,1)
        GICsN2(i,:)=GICsC2(i,:)/std(GICsC2(i,:));
    end
    
    %evaluate the results
    %match GIG-ICA and real sources
    SimGICsN2Tem=corr(GICsN2',TemICInMask');%
    %following is another matching method
    MatchV=[];
    MatchH=[];
    MatchL=[];
    Direction2GB=[];
    SimGICsN2TemG=SimGICsN2Tem;
    for i=1:ICnum
        MaxValue=max(max(abs(SimGICsN2TemG)));
        MatchV=[MatchV,MaxValue];
        if size(find(SimGICsN2TemG==MaxValue),1)
            P=find(SimGICsN2TemG==MaxValue);
            Direction2GB(i)=1;
        else if size(find(SimGICsN2TemG==-MaxValue),1)
                P=find(SimGICsN2TemG==-MaxValue);
                Direction2GB(i)=-1;
            end
        end
        
        Lie=ceil(P/ICnum);
        Hang=mod(P,ICnum);
        if Hang==0
            Hang=ICnum;
        end
        MatchH=[MatchH,Hang];
        MatchL=[MatchL,Lie];
        SimGICsN2TemG(Hang,:)=0;
        SimGICsN2TemG(:,Lie)=0;
    end
    
    [a,b]=sort(MatchL);
    Order2G=MatchH(b);
    
    for i=1:sbnum
        if i<10
            strzero='00';
        else if i>9&&i<100
                strzero='0';
            end
        end
        v=spm_vol(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\PreviousSimTBData\BaseTran5TheSpr3DifCNRUniHFTC_Exp12\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_DATA.nii'));
        dat=spm_read_vols(v);
        for j=1:timepoints
            FmriVec=reshape(dat(:,:,:,j),1,[]);
            FmriMatr(j,:) = FmriVec;
        end
        
        FmriMatMask=zeros(timepoints,VoxNum);
        h=1;
        for k=1:M*N*L
            if MaskVec(k)==1
                FmriMatMask(:,h)=FmriMatr(:,k);
                h=h+1;
            end
        end
        
        nemda=0;
        a=0.5;
        [GIGICMat,UnmixMat,GIGTCMatB,ObFunc,C,IterMat]=GIGICAArReInCISGamaArmiTGWRSF(FmriMatMask,GIGGroupPCnum,GICsN2,a,nemda);
        GIGTCMat=FmriMatMask*pinv(GIGICMat);
        
        
        %         GIGICMatPlMask=zeros(size(GIGICMat,1),M*N*L);
        %         h=1;
        %         for K=1:M*N*L
        %             if MaskVec(K)==0
        %                 GIGICMatPlMask(:,K)=0;
        %             else
        %                 GIGICMatPlMask(:,K)=GIGICMat(:,h);
        %                 h=h+1;
        %             end
        %         end
        %         h00=figure;
        %         for k=1:8
        %             subplot(8,1,k);
        %             imshow(reshape(GIGICMatPlMask(k,:),M,N),[]);
        %             %title(['\bf {GIG-ICA IC} ',int2str(k),'
        %             %(',num2str(vpa(IndiIC2ReSm(k)),4),')'],'fontsize',8);
        %             %tmp = sprintf('%.4f', IndiIC2ReSm(k));
        %             %title(['\bf {GIG-ICA IC} ',int2str(k),' (',tmp,')'],'fontsize',8);
        %         end
        
        
        %change the order of GIG result
        GIGTCMatCO=zeros(timepoints,size(GICsN2,1));
        GIGICMatCO=zeros(size(GICsN2,1),VoxNum);
        for ICorder=1:size(GICsN2,1)
            GIGICMatCO(ICorder,:)=GIGICMat(Order2G(ICorder),:);
            GIGTCMatCO(:,ICorder)= GIGTCMat(:,Order2G(ICorder));
        end
        GIGTCMatZ=[];
        for tc=1:size(GIGTCMat,2)
            GIGTCMatZ(:,tc)=(GIGTCMat(:,tc)-mean(GIGTCMat(:,tc)))/std(GIGTCMat(:,tc));
        end
        %change the order of z-scored GIG TC result
        GIGTCMatCOZ=zeros(timepoints,size(GICsN2,1));
        for ICorder=1:size(GICsN2,1)
            GIGTCMatCOZ(:,ICorder)=GIGTCMatZ(:,Order2G(ICorder));
        end
        
        
        %%
        %load GT IC and TC
        if i<10
            strzero='00';
        else if i>9&&i<100
                strzero='0';
            end
        end
        
        load (strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\PreviousSimTBData\BaseTran5TheSpr3DifCNRUniHFTC_Exp12\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_SIM.mat'));
        RealSouMat=SM;
        RealTCMat=TC(1:timepoints,:);
        RealSouInMask=zeros(ICnum,VoxNum);
        h=1;
        for k=1:M*N*L
            if MaskVec(k)==1
                RealSouInMask(:,h)=RealSouMat(:,k);
                h=h+1;
            end
        end
        RealSouInMaskZ=[]; %z-score the value of GT IC in mask.
        for IC=1:ICnum
            RealSouInMaskZ(IC,:)=(RealSouInMask(IC,:)-mean(RealSouInMask(IC,:)))/std(RealSouInMask(IC,:));
        end
        RealTCMatZ=[];
        for tc=1:ICnum
            RealTCMatZ(:,tc)=(RealTCMat(:,tc)-mean(RealTCMat(:,tc)))/std(RealTCMat(:,tc));
        end
        
        %%
        [IndiIC2RealSMSim,IndiIC2ReSm]=SMSim(GIGICMatCO,RealSouInMask);
        [IndiTC2RealTCSim,IndiTC2ReTc]=TCSim(GIGTCMatCO,RealTCMat);
        
        [IndiIC2RealSMSimZ,IndiIC2ReSmZ]=SMSim(GIGICMatCO,RealSouInMaskZ);
        [IndiTC2RealTCSimZ,IndiTC2ReTcZ]=TCSim(GIGTCMatCOZ,RealTCMatZ);
        
        SMS2(i,:)=IndiIC2ReSm';
        TCS2(i,:)=IndiTC2ReTc';
        MeanSMSG2(i)=mean(IndiIC2ReSm);
        MeanTCSG2(i)=mean(IndiTC2ReTc);
        
        
        GIGICMatPlMask=zeros(size(GIGICMat,1),M*N*L);
        RealSouMatZ=zeros(size(GIGICMat,1),M*N*L);%z scored GT IC plus mask.
        h=1;
        for K=1:M*N*L
            if MaskVec(K)==0
                GIGICMatPlMask(:,K)=0;
                RealSouMatZ(:,K)=0;
            else
                GIGICMatPlMask(:,K)=GIGICMat(:,h);
                RealSouMatZ(:,K)=RealSouInMaskZ(:,h);
                h=h+1;
            end
        end
        
        
        %if i==1||i==3||i==7;
        h00=figure;
        for k=1:size(GICsN2,1)
            subplot(size(GICsN2,1),5,5*k-3);
            imshow(reshape(GIGICMatPlMask(Order2G(k),:),M,N),[]);
            tmp = sprintf('%.4f', IndiIC2ReSm(k));
            title(['\bf {GIG-ICA IC} ',int2str(k),' (',tmp,')'],'fontsize',8);
            
            
            subplot(size(GICsN2,1),5,5*k-2);
            plot(GIGTCMatZ(:,Order2G(k)));
            tmp = sprintf('%.4f', IndiTC2ReTc(k));
            title(['\bf {GIG-ICA TC} ',int2str(k),' (',tmp,')'],'fontsize',8);
            xlim([0 timepoints]);
            ylim([-4 4]);
            
            subplot(size(GICsN2,1),5,5*k-1);
            imshow(reshape(RealSouMatZ(k,:),M,N),[]);
            title(['\bf {GT IC} ',int2str(k)],'fontSize',8);
            subplot(size(GICsN2,1),5,5*k);
            plot(RealTCMatZ(:,k));
            title(['\bf {GT TC} ',int2str(k)],'fontSize',8);
            xlim([0 timepoints]);
            ylim([-4 4]);
            
            
        end
        
    end
    
   
    
    h5=figure;
    set (gcf,'Position',[100,100,600,500], 'color','w')
    b_1=boxplotCsub(SMS2,1,['*'],1,1,'r',2,1,true,[1 4],1.3,0,'ks');
    set(gcf,'color','white')
    yrange=size(GICsN2,1)+0.5;
    axis([0.5 yrange 0 1])
    set(gca,'ygrid','on');
    set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',16);
    xlabel('ICs','Fontsize',20,'Fontweight','Bold','Fontsize',20);
    ylabel('Spatial accuracy','Fontsize',20,'Fontweight','Bold','Fontsize',20);
    title('GIG spatial accuracy','Fontsize',20,'Fontweight','Bold');
    % hold on;
    % for i=1:7
    %     %X=[xaixs(i)+0.5,xaixs(i)+0.5];
    %     X=[i+0.5,i+0.5];
    %     Y=[0,1];
    %     plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
    % end
    
    
    %boxplot temporal accuracy
    h6=figure;
    set (gcf,'Position',[100,100,600,500], 'color','w')
    b_1=boxplotCsub(TCS2,1,['*'],1,1,'r',2,1,true,[1 4],1.3,0,'ks');
    set(gcf,'color','white')
    axis([0.5 yrange 0 1])
    set(gca,'ygrid','on');
    set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',16);
    xlabel('ICs','Fontsize',20,'Fontweight','Bold','Fontsize',20);
    ylabel('Temporal accuracy','Fontsize',20,'Fontweight','Bold','Fontsize',20);
    title('GIG temporal accuracy','Fontsize',20,'Fontweight','Bold');
    % hold on;
    % for i=1:7
    %     %X=[xaixs(i)+0.5,xaixs(i)+0.5];
    %     X=[i+0.5,i+0.5];
    %     Y=[0,1];
    %     plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
    % end
    
    fprintf(strcat('Mean spatial accuracy of GIG method is'));
    MeanSpaAccGIG=mean(MeanSMSG2)
    fprintf(strcat('Mean temporal accuracy of GIG method is'));
    MeanTemAccGIG=mean(MeanTCSG2)
     
    MeanSMSG2DifTCL(:,timepoints/20-1)=MeanSMSG2';
    MeanTCSG2DifTCL(:,timepoints/20-1)=MeanTCSG2';
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\',num2str(timepoints)));
    saveas(h5,strcat('GIGSpaAcc.fig'));
    saveas(h5,strcat('GIGSpaAcc.png'));
    saveas(h6,strcat('GIGTemAcc.fig'));
    saveas(h6,strcat('GIGTemAcc.png'));
    save('MeanSpaAccGIG','MeanSpaAccGIG');
    save('MeanTemAccGIG','MeanTemAccGIG');
    xlswrite('MeanSpaAccGIG',MeanSpaAccGIG);
    xlswrite('MeanTemAccGIG',MeanTemAccGIG);
    
    cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');
    close all
end


%boxplot the GIG-ICA and IVA results together
%boxplot spatial accuracy under different length of time course
h5=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(MeanSMSG1DifTCL,1,['*'],1,1,'b',2,1,true,[1 2],1.3,0,'ks');
b_2=boxplotCsub(MeanSMSG2DifTCL,1,['*'],1,1,'r',2,1,true,[2 2],1.3,0,'ks');
set(gcf,'color','white')
axis([0.5 5.5 0.3 1])
set(gca,'ygrid','on');
set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',24);
xlabel('Different numbers of time points','Fontsize',24,'Fontweight','Bold','Fontsize',24);
ylabel('Spatial accuracy','Fontsize',24,'Fontweight','Bold','Fontsize',24);
set(gca,'XTickLabel',{'40','60','80','100','120',},'Fontweight','Bold','Fontsize',24);%,
title('(A)','Fontsize',24,'Fontweight','Bold');
hold on;
for i=1:5
    X=[i+0.5,i+0.5];
    Y=[0,1];
    plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
end
legend([b_1(8,1) b_2(8,1)],{'IVA','GIG-ICA'},3)

%boxplot spatial accuracy under different GIGGroupPCnum
h6=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(MeanTCSG1DifTCL,1,['*'],1,1,'b',2,1,true,[1 2],1.3,0,'ks');
b_2=boxplotCsub(MeanTCSG2DifTCL,1,['*'],1,1,'r',2,1,true,[2 2],1.3,0,'ks');
set(gcf,'color','white')
axis([0.5 5.5 0.3 1])
set(gca,'ygrid','on');
set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',24);
xlabel('Different numbers of time points','Fontsize',24,'Fontweight','Bold','Fontsize',24);
ylabel('Temporal accuracy','Fontsize',24,'Fontweight','Bold','Fontsize',24);
set(gca,'XTickLabel',{'40','60','80','100','120',},'Fontweight','Bold','Fontsize',24);%,
title('(B)','Fontsize',24,'Fontweight','Bold');
hold on;
for i=1:5
    X=[i+0.5,i+0.5];
    Y=[0,1];
    plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
end
legend([b_1(8,1) b_2(8,1)],{'IVA','GIG-ICA'},3)

cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date)));
saveas(h5,'SpatialAccuracySummary.fig');
saveas(h5,'SpatialAccuracySummary.png');
saveas(h6,'TemporalAccuracySummary.fig');
saveas(h6,'TemporalAccuracySummary.png');
save('MeanSMSG1DifTCL','MeanSMSG1DifTCL');
save('MeanSMSG2DifTCL','MeanSMSG2DifTCL');
save('MeanTCSG1DifTCL','MeanTCSG1DifTCL');
save('MeanTCSG2DifTCL','MeanTCSG2DifTCL');


