%duyuhui,2014,7.01 reivse
%compare GIG-ICA and IVA using biased estimated IC number

clc;
clear all;
close all;

date='CompareGIGIVA_BiasedICnum_GIGTCRegressAllUsingGIGIC_140701n';
DataParameter='BaseTran6The4Spr2CNR10SmallSizeSource_CNRTP';

CMdata = load('CM_coldhot_256');
CMAP = CMdata.CM;
timepoints=150;
M=148;N=148;L=1;
sbnum=10;
v0=spm_vol(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\SimTBData\BaseTran6The4Spr2DifCNRSmallSizeSource_CNRTP\',num2str(DataParameter),'\',num2str(DataParameter),'_MASK.nii'));
MaskData=spm_read_vols(v0);
MaskData=round(MaskData);
VoxNum=size(find(MaskData==1),1);
MaskVec=reshape(MaskData,1,[]);


GTICnum=8;%real IC number
%compute templates, and use the templates to match results from GIG-ICA(or
%IVA)and real sources
SumTemIC=zeros(GTICnum,M*N);
for i=1:sbnum %if here sbnum=1, that is just use GT of one subject as templates, in such case nosie components can not be removed accurately.
    if i<10
        strzero='00';
    else if i>9&&i<100
            strzero='0';
        end
    end
    
    %we can use the ground truth source to find the nosie components
    load (strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\SimTBData\BaseTran6The4Spr2DifCNRSmallSizeSource_CNRTP\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_SIM.mat'));
    SumTemIC=SumTemIC+SM;
    
end
TemIC=SumTemIC/sbnum;
TemICInMask=zeros(GTICnum,VoxNum);
h=1;
for k=1:M*N*L
    if MaskVec(k)==1
        TemICInMask(:,h)=TemIC(:,k);
        h=h+1;
    end
end
ICnumMat=[6,8,10]
for EstiICnumOrder=1:3
%%
ICnum=ICnumMat(EstiICnumOrder);%IC number used in computation

% mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\SimTBData\BaseTran6The4Spr2DifCNRSmallSizeSource_CNRTP\',num2str(DataParameter),num2str(date),'\IVA\IVA_R',num2str(R)));

FirIndiIC=zeros(sbnum*ICnum,VoxNum);

FmriMatr=[];data=[]; FmriMatMaskAllSub=[];
IVASubPC1num=ICnum;
for i=1:sbnum
    if i<10
        strzero='00';
    else if i>9&&i<100
            strzero='0';
        end
    end
    v=spm_vol(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\SimTBData\BaseTran6The4Spr2DifCNRSmallSizeSource_CNRTP\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_DATA.nii'));
    dat=spm_read_vols(v);
    for j=1:timepoints
        FmriVec=reshape(dat(:,:,:,j),1,[]);
        FmriMatr(j,:) = FmriVec;
    end
    %     figure;
    %     imshow(reshape(FmriMatr(1,:),M,N),[]);
    %1).implement individual ICA
    
    FmriMatMask=zeros(timepoints,VoxNum);
    h=1;
    for k=1:M*N*L
        if MaskVec(k)==1
            FmriMatMask(:,h)=FmriMatr(:,k);
            h=h+1;
        end
    end
    FmriMatMaskAllSub(:,:,i)=FmriMatMask;
    [IndiPCAOut,WhitenMatrix,DewhitenMatrix]=GIG_CalPCA(FmriMatMask',IVASubPC1num);
    
    data(:,:,i)=IndiPCAOut';
    
end

W = icatb_iva_second_order(data, 'whiten', false);
ICA_Options = {'maxIter', 1024, 'termThreshold', 1e-6, 'alpha0', 0.1, 'verbose', true,'whiten', false, 'initW', W};

disp('Weights from second order IVA are used as initial weights in laplacian IVA. Computing laplacian IVA ...');
W = icatb_iva_laplace(data, ICA_Options{:}); % run iva-l, initialized with iva-g result

for n = 1:size(W, 3)
    S = squeeze(W(:, :, n)*data(:, :, n))';
    sk = sign(icatb_skewness(S) + eps);
    W(:, :, n) = diag(sk)*W(:, :, n);
    clear S;
end

IVAICAllsubMat=zeros(size(data));
for i=1:sbnum
    IVAICAllsubMat(:,:,i)=W(:,:,i)*data(:,:,i);
end
IVAICOut=[];
for i=1:sbnum
    IVAICMat=IVAICAllsubMat(:,:,i);
    IVAIndiICPlMask=zeros(IVASubPC1num,M*N*L);
    h=1;
    for K=1:M*N*L
        if MaskVec(K)==0
            IVAIndiICPlMask(:,K)=0;
        else
            IVAIndiICPlMask(:,K)=IVAICMat(:,h);
            h=h+1;
        end
    end
    
    h0=figure;
    for k=1:IVASubPC1num
        subplot(IVASubPC1num,1,k);
        imshow(reshape(IVAIndiICPlMask(k,:),M,N),[]);
        
    end
    IVAICOut=[IVAICOut;IVAICMat];
end
a=1:ICnum;
Label=[];
 for i=1:sbnum
   Label=[Label,a];
 end
figure;
AllFea2D = tsne(IVAICOut, Label);
hP=gcf;
mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\',num2str(timepoints),'\IVA\ICnum',num2str(ICnum)));
cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\',num2str(timepoints),'\IVA\ICnum',num2str(ICnum)));
saveas(hP,'ProjectionOfAllsubAllIC.tif');
saveas(hP,'ProjectionOfAllsubAllIC.fig');
save('AllFea2D','AllFea2D');
save('IVAICOut','IVAICOut');

%evaluate IVA's results
%compute the mean IC maps across subjects for matching with template
IVAICAllsubMatMean=mean(IVAICAllsubMat,3);

SimGICsN1Tem=corr(IVAICAllsubMatMean',TemICInMask');%
%following is another matching method
MatchV=[];
MatchH=[];
MatchL=[];
DirectioN1GB=[];
SimGICsN1TemG=SimGICsN1Tem;
for i=1:min(size(SimGICsN1Tem,1),size(SimGICsN1Tem,2))
    MaxValue=max(max(abs(SimGICsN1TemG)));
    MatchV=[MatchV,MaxValue];
    if size(find(SimGICsN1TemG==MaxValue),1)
        P=find(SimGICsN1TemG==MaxValue);
        DirectioN1GB(i)=1;
    else if size(find(SimGICsN1TemG==-MaxValue),1)
            P=find(SimGICsN1TemG==-MaxValue);
            DirectioN1GB(i)=-1;
        end
    end
    
    Lie=ceil(P/size(SimGICsN1Tem,1));
    Hang=mod(P,size(SimGICsN1Tem,1));
    if Hang==0
        Hang=size(SimGICsN1Tem,1);
    end
    MatchH=[MatchH,Hang];
    MatchL=[MatchL,Lie];
    SimGICsN1TemG(Hang,:)=0;
    SimGICsN1TemG(:,Lie)=0;
end

% if GTICnum>ICnum
% [a,b]=sort(MatchH);%different from other experiments
% Order1G=MatchL(b);
% else if GTICnum<ICnum||GTICnum==ICnum
%         [a,b]=sort(MatchL);%different from other experiments
%         Order1G=MatchH(b);    
%     end
% end

SMS1=[]; 
TCS1=[];
MeanSMSG1=[];
MeanTCSG1=[];
for i=1:sbnum
    %load GT IC and TC
    if i<10
        strzero='00';
    else if i>9&&i<100
            strzero='0';
        end
    end
    
    %use the ground truth source to find the nosie components in IRPG
    load (strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\SimTBData\BaseTran6The4Spr2DifCNRSmallSizeSource_CNRTP\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_SIM.mat'));
    RealSouMat=SM;
    RealTCMat=TC(1:timepoints,:);
    RealSouInMask=zeros(GTICnum,VoxNum);
    h=1;
    for k=1:M*N*L
        if MaskVec(k)==1
            RealSouInMask(:,h)=RealSouMat(:,k);
            h=h+1;
        end
    end
    
    RealSouInMaskZ=[]; %z-score the value of GT IC in mask.
    for IC=1:GTICnum
        RealSouInMaskZ(IC,:)=(RealSouInMask(IC,:)-mean(RealSouInMask(IC,:)))/std(RealSouInMask(IC,:));
    end
    
    RealTCMatZ=[];
    for tc=1:GTICnum
        RealTCMatZ(:,tc)=(RealTCMat(:,tc)-mean(RealTCMat(:,tc)))/std(RealTCMat(:,tc));
    end
    
    %change the order of RealSou and RealTC so that comparing with IVA
    %results
    RealSouInMaskCO=[];
    RealSouInMaskZCO=[];
    RealTCMatCO=[];
    RealTCMatZCO=[];
    if GTICnum>ICnum
        number=ICnum;
    else if GTICnum<ICnum
            number=GTICnum;
        else
            number=ICnum;
        end
    end
    for ICorder=1:number
        RealSouInMaskCO(ICorder,:)=RealSouInMask(MatchL(ICorder),:);
        RealSouInMaskZCO(ICorder,:)=RealSouInMaskZ(MatchL(ICorder),:);
        RealTCMatCO(:,ICorder)= RealTCMat(:,MatchL(ICorder)); 
        RealTCMatZCO(:,ICorder)=RealTCMatZ(:,MatchL(ICorder));
    end
    
    %%
    IVAICMat=IVAICAllsubMat(:,:,i);
    IVATCMat=FmriMatMaskAllSub(:,:,i)*pinv(IVAICMat);
    IVATCMatZ=[];
    for tcorder=1:size(IVATCMat,2)
        IVATCMatZ(:,tcorder)=(IVATCMat(:,tcorder)-mean(IVATCMat(:,tcorder)))/std(IVATCMat(:,tcorder));
    end
    
    %change the order of IVA result
    IVATCMatCO=zeros(timepoints,number);
    IVAICMatCO=zeros(number,VoxNum);
    IVATCMatZCO=zeros(timepoints,number);
    for ICorder=1:number
        IVAICMatCO(ICorder,:)=IVAICMat(MatchH(ICorder),:);
        IVATCMatCO(:,ICorder)= IVATCMat(:,MatchH(ICorder));
        IVATCMatZCO(:,ICorder)=IVATCMatZ(:,MatchH(ICorder));
    end

 cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');
   
    [IndiIC1RealSMSim,IndiIC1ReSm]=SMSim(IVAICMatCO,RealSouInMaskCO);
    [IndiTC1RealTCSim,IndiTC1ReTc]=TCSim(IVATCMatCO,RealTCMatCO);
    
    [IndiIC1RealSMSimZ,IndiIC1ReSmZ]=SMSim(IVAICMatCO,RealSouInMaskZCO);
    [IndiTC1RealTCSimZ,IndiTC1ReTcZ]=TCSim(IVATCMatZCO,RealTCMatZCO);
    
    SMS1(i,:)=IndiIC1ReSm';
    TCS1(i,:)=IndiTC1ReTc';
    MeanSMSG1(i)=mean(IndiIC1ReSm);
    MeanTCSG1(i)=mean(IndiTC1ReTc);

    
    IVAICMatPlMask=zeros(size(IVAICMatCO,1),M*N*L);
    RealSouMatZ=zeros(size(IVAICMatCO,1),M*N*L);%z scored GT IC (after reordering) plus mask.
    h=1;
    for K=1:M*N*L
        if MaskVec(K)==0
            IVAICMatPlMask(:,K)=0;
            RealSouMatZ(:,K)=0;
        else
            IVAICMatPlMask(:,K)=IVAICMatCO(:,h);
            RealSouMatZ(:,K)=RealSouInMaskZCO(:,h);
            h=h+1;
        end
    end
    
    
    %if i==1||i==3||i==7;
    h00=figure;
    for k=1:min(GTICnum,ICnum)
        subplot(min(GTICnum,ICnum),5,5*k-3);
        imshow(reshape(IVAICMatPlMask(k,:),M,N),[]);
        tmp = sprintf('%.4f', IndiIC1ReSm(k));
        title(['\bf {IVA IC} ',int2str(k),' (',tmp,')'],'fontsize',8);
        
        
        subplot(min(GTICnum,ICnum),5,5*k-2);
        plot(IVATCMatZ(:,k));
        tmp = sprintf('%.4f', IndiTC1ReTc(k));
        title(['\bf {IVA TC} ',int2str(k),' (',tmp,')'],'fontsize',8);
        xlim([0 timepoints]);
        ylim([-4 4]);
        
        subplot(min(GTICnum,ICnum),5,5*k-1);
        imshow(reshape(RealSouMatZ(k,:),M,N),[]);
        title(['\bf {GT IC} ',int2str(k)],'fontSize',8);
        subplot(min(GTICnum,ICnum),5,5*k);
        plot(RealTCMatZ(:,k));
        title(['\bf {GT TC} ',int2str(k)],'fontSize',8);
        xlim([0 timepoints]);
        ylim([-4 4]);
    end
    
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\',num2str(timepoints),'\IVA\ICnum',num2str(ICnum)));
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\',num2str(timepoints),'\IVA\ICnum',num2str(ICnum),'\sb',num2str(i)));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\',num2str(timepoints),'\IVA\ICnum',num2str(ICnum),'\sb',num2str(i)));
    saveas(h00,'IVAICTC.fig');
    saveas(h00,'IVAICTC.png');
end

cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');

%boxplot spatial accuracy
h1=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(SMS1,1,['*'],1,1,'r',2,1,true,[1 4],1.3,0,'ks');
set(gcf,'color','white')
xmax=IVASubPC1num+0.5;
axis([0.5 xmax 0 1])
set(gca,'ygrid','on');
set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',16);
xlabel('ICs','Fontsize',20,'Fontweight','Bold','Fontsize',20);
ylabel('Spatial accuracy','Fontsize',20,'Fontweight','Bold','Fontsize',20);
title('IVA spatial accuracy','Fontsize',20,'Fontweight','Bold');
% hold on;
% for i=1:7
%     %X=[xaixs(i)+0.5,xaixs(i)+0.5];
%     X=[i+0.5,i+0.5];
%     Y=[0,1];
%     plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
% end

%boxplot temporal accuracy
h2=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(TCS1,1,['*'],1,1,'r',2,1,true,[1 4],1.3,0,'ks');
set(gcf,'color','white')
xmax=IVASubPC1num+0.5;
axis([0.5 xmax 0 1])
set(gca,'ygrid','on');
set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',16);
xlabel('ICs','Fontsize',20,'Fontweight','Bold','Fontsize',20);
ylabel('Temporal accuracy','Fontsize',20,'Fontweight','Bold','Fontsize',20);
title('IVA temporal accuracy','Fontsize',20,'Fontweight','Bold');
% hold on;
% for i=1:7
%     %X=[xaixs(i)+0.5,xaixs(i)+0.5];
%     X=[i+0.5,i+0.5];
%     Y=[0,1];
%     plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
% end
mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\',num2str(timepoints),'\IVA\ICnum',num2str(ICnum)));

cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\',num2str(timepoints),'\IVA\ICnum',num2str(ICnum)));
saveas(h1,strcat('IVASpaAcc.fig'));
saveas(h1,strcat('IVASpaAcc.png'));
saveas(h2,strcat('IVATemAcc.fig'));
saveas(h2,strcat('IVATemAcc.png'));

fprintf(strcat('Mean spatial accuracy of IVA method is'));
MeanSpaAccIVA=mean(MeanSMSG1)
fprintf(strcat('Mean temporal accuracy of IVA method is'));
MeanTemAccIVA=mean(MeanTCSG1)
save('MeanSpaAccIVA','MeanSpaAccIVA');
save('MeanTemAccIVA','MeanTemAccIVA');
xlswrite('MeanSpaAccIVA',MeanSpaAccIVA);
xlswrite('MeanTemAccIVA',MeanTemAccIVA);

MeanSMSG1DifICNum(:,EstiICnumOrder)=MeanSMSG1';
MeanTCSG1DifICNum(:,EstiICnumOrder)=MeanTCSG1';
cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');


close all;
%%
%GIG-ICA
%1.set some parameters
GIGSubPCnum=ICnum;
GIGGroupPCnum=ICnum;

%2.read data, and implement subject PCA.
for i=1:sbnum
    if i<10
        strzero='00';
    else if i>9&&i<100
            strzero='0';
        end
    end
    
    v=spm_vol(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\SimTBData\BaseTran6The4Spr2DifCNRSmallSizeSource_CNRTP\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_DATA.nii'));
    dat=spm_read_vols(v);
    for j=1:timepoints
        FmriVec=reshape(dat(:,:,:,j),1,[]);
        FmriMatr(j,:) = FmriVec;
    end
    
    FmriMatMask=zeros(timepoints,VoxNum);
    h=1;
    for k=1:M*N*L
        if MaskVec(k)==1
            FmriMatMask(:,h)=FmriMatr(:,k);
            h=h+1;
        end
    end
    
    IndiPCAData= GIG_CalPCA( FmriMatMask',GIGSubPCnum); %subject level PCA
    SubPCAOut(:,GIGSubPCnum*(i-1)+1:GIGSubPCnum*i)=IndiPCAData;%
end

GroupPCAOut = GIG_CalPCA(SubPCAOut,GIGGroupPCnum); %

disp('Start group level ICA for geting group components......................................');
%group ICA
algorithmName='Infomax';
%use the ICASSO
%[A, GICs] = useICASSO(GroupPCAOut', algorithmName);
[W2, A2, GICs2] = GIG_IcaAlgorithm(algorithmName, GroupPCAOut');
clear SubPCAOut;
clear GroupPCAOut;
GICsN2=zeros(GIGGroupPCnum,VoxNum);
%normalize the GICs for output or for the consequent average
GICsC2=GICs2-repmat(mean(GICs2,2),[1,VoxNum]);
for i=1:size(GICs2,1)
    GICsN2(i,:)=GICsC2(i,:)/std(GICsC2(i,:));
end

GICICMatPlMask=zeros(size(GICsN2,1),M*N*L);
h=1;
for K=1:M*N*L
    if MaskVec(K)==0
        GICICMatPlMask(:,K)=0;
    else
        GICICMatPlMask(:,K)=GICsN2(:,h);
        h=h+1;
    end
end
h00=figure;
for k=1:size(GICs2,1)
    subplot(size(GICs2,1),1,k);
    imshow(reshape(GICICMatPlMask(k,:),M,N),[]);

end

%evaluate the results
%match GIG-ICA and real sources
SimGICsN2Tem=corr(GICsN2',TemICInMask');%
figure;
imagesc(SimGICsN2Tem);colorbar;
%following is another matching method
MatchV=[];
MatchH=[];
MatchL=[];
Direction2GB=[];
SimGICsN2TemG=SimGICsN2Tem;
for i=1:min(size(SimGICsN2Tem,1),size(SimGICsN2Tem,2))
    MaxValue=max(max(abs(SimGICsN2TemG)));
    MatchV=[MatchV,MaxValue];
    if size(find(SimGICsN2TemG==MaxValue),1)
        P=find(SimGICsN2TemG==MaxValue);
        Direction2GB(i)=1;
    else if size(find(SimGICsN2TemG==-MaxValue),1)
            P=find(SimGICsN2TemG==-MaxValue);
            Direction2GB(i)=-1;
        end
    end
    
    Lie=ceil(P/size(SimGICsN2Tem,1));
    Hang=mod(P,size(SimGICsN2Tem,1));
    if Hang==0
        Hang=size(SimGICsN2Tem,1);
    end
    MatchH=[MatchH,Hang];
    MatchL=[MatchL,Lie];
    SimGICsN2TemG(Hang,:)=0;
    SimGICsN2TemG(:,Lie)=0;
end

% if GTICnum>ICnum
% [a,b]=sort(MatchH);%different from other experiments
% Order2G=MatchL(b);
% else if GTICnum<ICnum||GTICnum==ICnum
%         [a,b]=sort(MatchL);%different from other experiments
%         Order2G=MatchH(b); 
%     end
% end

SMS2=[]; 
TCS2=[];
MeanSMSG2=[];
MeanTCSG2=[];
GIGICOut=[];
for i=1:sbnum
    if i<10
        strzero='00';
    else if i>9&&i<100
            strzero='0';
        end
    end
    v=spm_vol(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\SimTBData\BaseTran6The4Spr2DifCNRSmallSizeSource_CNRTP\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_DATA.nii'));
    dat=spm_read_vols(v);
    for j=1:timepoints
        FmriVec=reshape(dat(:,:,:,j),1,[]);
        FmriMatr(j,:) = FmriVec;
    end
    
    FmriMatMask=zeros(timepoints,VoxNum);
    h=1;
    for k=1:M*N*L
        if MaskVec(k)==1
            FmriMatMask(:,h)=FmriMatr(:,k);
            h=h+1;
        end
    end
    
    nemda=0;
    a=0.5;
    [GIGICMat,UnmixMat,GIGTCMatB,ObFunc,C,IterMat]=GIGICAArReInCISGamaArmiTGWRSF(FmriMatMask,GIGGroupPCnum,GICsN2,a,nemda);
    GIGTCMat=FmriMatMask*pinv(GIGICMat);%method 1: like the computation in GIFT 
    %GIGTCMat=GIGTCMatB;%method 2: my method
    
%     %method 3: regression one by one  like computation in FSL using
%     GIGICs
%     GIGTCMat=[];
%     for  tc=1:size(GIGICMat,1)
%         GIGTCMat(:,tc)=FmriMatMask*pinv(GIGICMat(tc,:));
%     end
    
%     %method 4: regression one by one using group ICs
%     GIGTCMat=[];
%     for  tc=1:size(GIGICMat,1)
%     GIGTCMat(:,tc)=FmriMatMask*pinv(GICsN2(tc,:));
%     end
    
%     %method 5: regression at one time using group ICs
%     GIGTCMat=FmriMatMask*pinv(GICsN2);
    
    GIGTCMatZ=[];
    for tc=1:size(GIGTCMat,2)
        GIGTCMatZ(:,tc)=(GIGTCMat(:,tc)-mean(GIGTCMat(:,tc)))/std(GIGTCMat(:,tc));
    end
    
    GIGICOut=[GIGICOut;GIGICMat];

    %%
    %load GT IC and TC
    if i<10
        strzero='00';
    else if i>9&&i<100
            strzero='0';
        end
    end
    
    load (strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\SimTBData\BaseTran6The4Spr2DifCNRSmallSizeSource_CNRTP\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_SIM.mat'));
    RealSouMat=SM;
    RealTCMat=TC(1:timepoints,:);
    RealSouInMask=zeros(GTICnum,VoxNum);
    h=1;
    for k=1:M*N*L
        if MaskVec(k)==1
            RealSouInMask(:,h)=RealSouMat(:,k);
            h=h+1;
        end
    end
   RealSouInMaskZ=[]; %z-score the value of GT IC in mask.
    for IC=1:GTICnum
        RealSouInMaskZ(IC,:)=(RealSouInMask(IC,:)-mean(RealSouInMask(IC,:)))/std(RealSouInMask(IC,:));
    end
    
    RealTCMatZ=[];
    for tc=1:GTICnum
        RealTCMatZ(:,tc)=(RealTCMat(:,tc)-mean(RealTCMat(:,tc)))/std(RealTCMat(:,tc));
    end
 
     %change the order of RealSou and RealTC so that comparing with IVA
    %results
    RealSouInMaskCO=[];
    RealSouInMaskZCO=[];
    RealTCMatCO=[];
    RealTCMatZCO=[];
    if GTICnum>ICnum
        number=ICnum;
    else if GTICnum<ICnum
            number=GTICnum;
        else
            number=ICnum;
        end
    end
    for ICorder=1:number
        RealSouInMaskCO(ICorder,:)=RealSouInMask(MatchL(ICorder),:);
        RealSouInMaskZCO(ICorder,:)=RealSouInMaskZ(MatchL(ICorder),:);
        RealTCMatCO(:,ICorder)= RealTCMat(:,MatchL(ICorder)); 
        RealTCMatZCO(:,ICorder)=RealTCMatZ(:,MatchL(ICorder));
    end
    
     %change the order of GIG result
    GIGTCMatCO=zeros(timepoints,number);
    GIGICMatCO=zeros(number,VoxNum);
    GIGTCMatZCO=zeros(timepoints,number);
    for ICorder=1:number
        GIGICMatCO(ICorder,:)=GIGICMat(MatchH(ICorder),:);
        GIGTCMatCO(:,ICorder)= GIGTCMat(:,MatchH(ICorder));
        GIGTCMatZCO(:,ICorder)=GIGTCMatZ(:,MatchH(ICorder));
    end

    cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');

    [IndiIC2RealSMSim,IndiIC2ReSm]=SMSim(GIGICMatCO,RealSouInMaskCO);
    [IndiTC2RealTCSim,IndiTC2ReTc]=TCSim(GIGTCMatCO,RealTCMatCO);
    
    [IndiIC2RealSMSimZ,IndiIC2ReSmZ]=SMSim(GIGICMatCO,RealSouInMaskZCO);
    [IndiTC2RealTCSimZ,IndiTC2ReTcZ]=TCSim(GIGTCMatZCO,RealTCMatZCO);
    %%

    
    SMS2(i,:)=IndiIC2ReSm';
    TCS2(i,:)=IndiTC2ReTc';
    MeanSMSG2(i)=mean(IndiIC2ReSm);
    MeanTCSG2(i)=mean(IndiTC2ReTc);
    
    
    GIGICMatPlMask=zeros(size(GIGICMatCO,1),M*N*L);
    RealSouMatZ=zeros(size(GIGICMatCO,1),M*N*L);%z scored GT IC plus mask.
    h=1;
    for K=1:M*N*L
        if MaskVec(K)==0
            GIGICMatPlMask(:,K)=0;
            RealSouMatZ(:,K)=0;
        else
            GIGICMatPlMask(:,K)=GIGICMatCO(:,h);
            RealSouMatZ(:,K)=RealSouInMaskZCO(:,h);
            h=h+1;
        end
    end
    
    
    %if i==1||i==3||i==7;
    h01=figure;
    for k=1:min(GTICnum,ICnum)
        subplot(min(GTICnum,ICnum),5,5*k-3);
        imshow(reshape(GIGICMatPlMask(k,:),M,N),[]);
        tmp = sprintf('%.4f', IndiIC2ReSm(k));
        title(['\bf {GIG-ICA IC} ',int2str(k),' (',tmp,')'],'fontsize',8);
        
        
        subplot(min(GTICnum,ICnum),5,5*k-2);
        plot(GIGTCMatZ(:,k));
        tmp = sprintf('%.4f', IndiTC2ReTc(k));
        title(['\bf {GIG-ICA TC} ',int2str(k),' (',tmp,')'],'fontsize',8);
        xlim([0 timepoints]);
        ylim([-4 4]);
        
        subplot(min(GTICnum,ICnum),5,5*k-1);
        imshow(reshape(RealSouMatZ(k,:),M,N),[]);
        title(['\bf {GT IC} ',int2str(k)],'fontSize',8);
        subplot(min(GTICnum,ICnum),5,5*k);
        plot(RealTCMatZ(:,k));
        title(['\bf {GT TC} ',int2str(k)],'fontSize',8);
        xlim([0 timepoints]);
        ylim([-4 4]);
        
        
    end
     mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\',num2str(timepoints),'\GIG\ICnum',num2str(ICnum)));
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\',num2str(timepoints),'\GIG\ICnum',num2str(ICnum),'\sb',num2str(i)));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\',num2str(timepoints),'\GIG\ICnum',num2str(ICnum),'\sb',num2str(i)));
    saveas(h01,'GIGICTC.fig');
    saveas(h01,'GIGICTC.png');
    cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');

end

    figure;
    AllFea2D = tsne(GIGICOut, Label);
    hP=gcf;
    mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\',num2str(timepoints),'\GIG\ICnum',num2str(ICnum)));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\',num2str(timepoints),'\GIG\ICnum',num2str(ICnum)));
    saveas(hP,'ProjectionOfAllsubAllIC.tif');
    saveas(hP,'ProjectionOfAllsubAllIC.fig');
    save('AllFea2D','AllFea2D');
    save('GIGICOut','GIGICOut');
    
cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');

h5=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(SMS2,1,['*'],1,1,'r',2,1,true,[1 4],1.3,0,'ks');
set(gcf,'color','white')
yrange=size(GICsN2,1)+0.5;
axis([0.5 yrange 0 1])
set(gca,'ygrid','on');
set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',16);
xlabel('ICs','Fontsize',20,'Fontweight','Bold','Fontsize',20);
ylabel('Spatial accuracy','Fontsize',20,'Fontweight','Bold','Fontsize',20);
title('GIG spatial accuracy','Fontsize',20,'Fontweight','Bold');
% hold on;
% for i=1:7
%     %X=[xaixs(i)+0.5,xaixs(i)+0.5];
%     X=[i+0.5,i+0.5];
%     Y=[0,1];
%     plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
% end


%boxplot temporal accuracy
h6=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(TCS2,1,['*'],1,1,'r',2,1,true,[1 4],1.3,0,'ks');
set(gcf,'color','white')
axis([0.5 yrange 0 1])
set(gca,'ygrid','on');
set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',16);
xlabel('ICs','Fontsize',20,'Fontweight','Bold','Fontsize',20);
ylabel('Temporal accuracy','Fontsize',20,'Fontweight','Bold','Fontsize',20);
title('GIG temporal accuracy','Fontsize',20,'Fontweight','Bold');
% hold on;
% for i=1:7
%     %X=[xaixs(i)+0.5,xaixs(i)+0.5];
%     X=[i+0.5,i+0.5];
%     Y=[0,1];
%     plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
% end

fprintf(strcat('Mean spatial accuracy of GIG method is'));
MeanSpaAccGIG=mean(MeanSMSG2)
fprintf(strcat('Mean temporal accuracy of GIG method is'));
MeanTemAccGIG=mean(MeanTCSG2)

MeanSMSG2DifICNum(:,EstiICnumOrder)=MeanSMSG2';
MeanTCSG2DifICNum(:,EstiICnumOrder)=MeanTCSG2';
cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date),'\',num2str(timepoints),'\GIG\ICnum',num2str(ICnum)));
saveas(h5,strcat('GIGSpaAcc.fig'));
saveas(h5,strcat('GIGSpaAcc.png'));
saveas(h6,strcat('GIGTemAcc.fig'));
saveas(h6,strcat('GIGTemAcc.png'));
save('MeanSpaAccGIG','MeanSpaAccGIG');
save('MeanTemAccGIG','MeanTemAccGIG');
xlswrite('MeanSpaAccGIG',MeanSpaAccGIG);
xlswrite('MeanTemAccGIG',MeanTemAccGIG);

cd('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationCode');


end

%boxplot the GIG-ICA and GIG results together
%boxplot spatial accuracy under different length of time course
h5=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(MeanSMSG1DifICNum,1,['*'],1,1,'b',2,1,true,[1 2],1.3,0,'ks');
b_2=boxplotCsub(MeanSMSG2DifICNum,1,['*'],1,1,'r',2,1,true,[2 2],1.3,0,'ks');
set(gcf,'color','white')
axis([0.5 3.5 0.3 1])
set(gca,'ygrid','on');
set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',24);
xlabel('Number of ICs used in compuation','Fontsize',24,'Fontweight','Bold','Fontsize',24);
ylabel('Spatial accuracy','Fontsize',24,'Fontweight','Bold','Fontsize',24);
set(gca,'XTickLabel',{'6','8','10'},'Fontweight','Bold','Fontsize',24);%,
title('(A)','Fontsize',24,'Fontweight','Bold');
hold on;
for i=1:3
    X=[i+0.5,i+0.5];
    Y=[0,1];
    plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
end
legend([b_1(8,1) b_2(8,1)],{'IVA','GIG-ICA'},3)

%boxplot spatial accuracy under different GIGGroupPCnum
h6=figure;
set (gcf,'Position',[100,100,600,500], 'color','w')
b_1=boxplotCsub(MeanTCSG1DifICNum,1,['*'],1,1,'b',2,1,true,[1 2],1.3,0,'ks');
b_2=boxplotCsub(MeanTCSG2DifICNum,1,['*'],1,1,'r',2,1,true,[2 2],1.3,0,'ks');
set(gcf,'color','white')
axis([0.5 3.5 0.3 1])
set(gca,'ygrid','on');
set(gca,'YTick',[0:0.1:2],'Fontweight','Bold','Fontsize',24);
xlabel('Number of ICs used in compuation','Fontsize',24,'Fontweight','Bold','Fontsize',24);
ylabel('Temporal accuracy','Fontsize',24,'Fontweight','Bold','Fontsize',24);
set(gca,'XTickLabel',{'6','8','10'},'Fontweight','Bold','Fontsize',24);%,
title('(B)','Fontsize',24,'Fontweight','Bold');
hold on;
for i=1:3
    X=[i+0.5,i+0.5];
    Y=[0,1];
    plot(X,Y,'LineWidth',1,'LineStyle','-.','Color',[0 0 0]);
end
legend([b_1(8,1) b_2(8,1)],{'IVA','GIG-ICA'},3)

cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date)));
saveas(h5,'SpatialAccuracySummary.fig');
saveas(h5,'SpatialAccuracySummary.png');
saveas(h6,'TemporalAccuracySummary.fig');
saveas(h6,'TemporalAccuracySummary.png');
save('MeanSMSG1DifICNum','MeanSMSG1DifICNum');
save('MeanSMSG2DifICNum','MeanSMSG2DifICNum');
save('MeanTCSG1DifICNum','MeanTCSG1DifICNum');
save('MeanTCSG2DifICNum','MeanTCSG2DifICNum');


