%duyuhui,2016,12,18
%show the generated ground truth. 


%duyuhui,2014,4,24
%Because reviewer said the spatial varibility in my paper is small.
%So, I will use another way (by displaying edge) to show the spatial map.

%duyuhui,2013,11.22
%show Ground truth sources/TCs for experiment 1
clc;
clear;
close all;

DataFolder='PreviousSimTBData\BaseTran5TheSpr3DifCNRUniHFTC_Exp12';

DataParameter='BaseTran5TheSpr3CNR20UniHFTC_Exp12';

date='GTOutFigure_161218';
CMdata = load('CM_coldhot_256');
CMAP = CMdata.CM;
mkdir(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date)));


ICnum=8;%real ICnum, not used here.
timepoints=150;
M=148;N=148;L=1;
sbnum=10;

v0=spm_vol(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\',DataFolder,'\',num2str(DataParameter),'\',num2str(DataParameter),'_MASK.nii'));
MaskData=spm_read_vols(v0);
MaskData=round(MaskData);
VoxNum=size(find(MaskData==1),1);
MaskVec=reshape(MaskData,1,[]);

%6 columns
h1=figure;
for j=1:2
    i=j*5;
    if i<10
        strzero='00';
    else if i>9&&i<100
            strzero='0';
        end
    end
    load (strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\',DataFolder,'\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_SIM.mat'));
    RealSouMat=SM;
    RealTCMat=TC;
    
    %get the data in mask
    RealSouInMask=zeros(ICnum,VoxNum);
    h=1;
    for k=1:M*N*L
        if MaskVec(k)==1
            RealSouInMask(:,h)=RealSouMat(:,k);
            h=h+1;
        end
    end
    
    %zscore the data in mask
    for l=1:size(RealSouMat,1)
        RealSouInMaskZ(l,:)=(RealSouInMask(l,:)-mean(RealSouInMask(l,:)))/std(RealSouInMask(l,:));
        RealTCMatZ(:,l)=(RealTCMat(:,l)-mean(RealTCMat(:,l)))/std(RealTCMat(:,l));
    end
    
    %plus the mask for zscored DataInMask
    RealSouInMaskZPlMask=zeros(ICnum,M*N*L);
    h=1;
    for K=1:M*N*L
        if MaskVec(K)==0
            RealSouInMaskZPlMask(:,K)=0;%NaN;
        else
            RealSouInMaskZPlMask(:,K)=RealSouInMaskZ(:,h);
            h=h+1;
        end
    end
    
    
    %     X=1:148;
    %     Y=1:148;
    for k=1:size(RealSouMat,1)
        if j==1
            x=6*(k-1)+1;
        else if j==2
                x=6*(k-1)+3;
            end
        end
        h=subplot(size(RealSouMat,1),6,x);
        arg1 = linspace(-1,1,M);
        imagesc(arg1,arg1,reshape(RealSouInMaskZPlMask(k,:),M,N));
        axis xy; axis square; axis off;
        hold on
        BL = polar(h, linspace(0,2*pi,256),ones(1,256));
        set(BL, 'Color', 'w', 'LineWidth', 1);
        amax = max(abs(reshape(RealSouInMaskZPlMask(k,:),1,[])));
        set(h, 'CLIM', [-amax, amax])
        colormap(CMAP);
        %simtb_showSM(reshape(RealSouInMaskZPlMask(k,:),M,N));
        %imshow(reshape(RealSouInMaskZPlMask(k,:),M,N),[]);
        %imagesc(reshape(RealSouInMaskZPlMask(k,:),M,N));%colorbar;
        %h=pcolor(X,Y,reshape(RealSouInMaskZPlMask(k,:),M,N));caxis([0,5]);colormap(jet(64));
        
        title(['\bf {GT IC} ',int2str(k)],'fontSize',8);
        subplot(size(RealSouMat,1),6,x+1);
        plot(RealTCMatZ(:,k));
        title(['\bf {GT TC} ',int2str(k)],'fontSize',8);
        xlim([0 timepoints]);
        ylim([-4 4]);
    end
end

%8 columns
h2=figure;
for j=1:2
    i=j*5;
    if i<10
        strzero='00';
    else if i>9&&i<100
            strzero='0';
        end
    end
    load (strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\',DataFolder,'\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_SIM.mat'));
    RealSouMat=SM;
    RealTCMat=TC;
    
    %get the data in mask
    RealSouInMask=zeros(ICnum,VoxNum);
    h=1;
    for k=1:M*N*L
        if MaskVec(k)==1
            RealSouInMask(:,h)=RealSouMat(:,k);
            h=h+1;
        end
    end
    
    %zscore the data in mask
    for l=1:size(RealSouMat,1)
        RealSouInMaskZ(l,:)=(RealSouInMask(l,:)-mean(RealSouInMask(l,:)))/std(RealSouInMask(l,:));
        RealTCMatZ(:,l)=(RealTCMat(:,l)-mean(RealTCMat(:,l)))/std(RealTCMat(:,l));
    end
    
    %plus the mask for zscored DataInMask
    RealSouInMaskZPlMask=zeros(ICnum,M*N*L);
    h=1;
    for K=1:M*N*L
        if MaskVec(K)==0
            RealSouInMaskZPlMask(:,K)=0;%NaN;
        else
            RealSouInMaskZPlMask(:,K)=RealSouInMaskZ(:,h);
            h=h+1;
        end
    end
    
    
    %     X=1:148;
    %     Y=1:148;
    for k=1:size(RealSouMat,1)
        if j==1
            x=8*(k-1)+1;
        else if j==2
                x=8*(k-1)+4;
            end
        end
        h=subplot(size(RealSouMat,1),8,x);
        arg1 = linspace(-1,1,M);
        imagesc(arg1,arg1,reshape(RealSouInMaskZPlMask(k,:),M,N));
        axis xy; axis square; axis off;
        hold on
        BL = polar(h, linspace(0,2*pi,256),ones(1,256));
        set(BL, 'Color', 'w', 'LineWidth', 1);
        amax = max(abs(reshape(RealSouInMaskZPlMask(k,:),1,[])));
        set(h, 'CLIM', [-amax, amax])
        colormap(CMAP);
        %simtb_showSM(reshape(RealSouInMaskZPlMask(k,:),M,N));
        %imshow(reshape(RealSouInMaskZPlMask(k,:),M,N),[]);
        %imagesc(reshape(RealSouInMaskZPlMask(k,:),M,N));%colorbar;
        %h=pcolor(X,Y,reshape(RealSouInMaskZPlMask(k,:),M,N));caxis([0,5]);colormap(jet(64));
        
        %title(['\bf {GT IC} ',int2str(k)],'fontSize',8);
        subplot(size(RealSouMat,1),8,x+1);
        plot(RealTCMatZ(:,k));
        %title(['\bf {GT TC} ',int2str(k)],'fontSize',8);
        xlim([0 timepoints]);
        ylim([-4 4]);
    end
end

%% ʾ
h3=figure;
for j=1:2
    i=j*5;
    if i<10
        strzero='00';
    else if i>9&&i<100
            strzero='0';
        end
    end
    load (strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\',DataFolder,'\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_SIM.mat'));
    RealSouMat=SM;
    RealTCMat=TC;
    
    %get the data in mask
    RealSouInMask=zeros(ICnum,VoxNum);
    h=1;
    for k=1:M*N*L
        if MaskVec(k)==1
            RealSouInMask(:,h)=RealSouMat(:,k);
            h=h+1;
        end
    end
    
    %zscore the data in mask
    for l=1:size(RealSouMat,1)
        RealSouInMaskZ(l,:)=(RealSouInMask(l,:)-mean(RealSouInMask(l,:)))/std(RealSouInMask(l,:));
        RealTCMatZ(:,l)=(RealTCMat(:,l)-mean(RealTCMat(:,l)))/std(RealTCMat(:,l));
    end
    
    %plus the mask for zscored DataInMask
    RealSouInMaskZPlMask=zeros(ICnum,M*N*L);
    h=1;
    for K=1:M*N*L
        if MaskVec(K)==0
            RealSouInMaskZPlMask(:,K)=0;%NaN;
        else
            RealSouInMaskZPlMask(:,K)=RealSouInMaskZ(:,h);
            h=h+1;
        end
    end
    
    
    if j==1
        for k=1:size(RealSouMat,1)
            
            h=subplot(6,8,k);
            arg1 = linspace(-1,1,M);
            imagesc(arg1,arg1,reshape(RealSouInMaskZPlMask(k,:),M,N));
            axis xy; axis square; axis off;
            hold on
            BL = polar(h, linspace(0,2*pi,256),ones(1,256));
            set(BL, 'Color', 'w', 'LineWidth', 1);
            amax = max(abs(reshape(RealSouInMaskZPlMask(k,:),1,[])));
            set(h, 'CLIM', [-amax, amax])
            colormap(CMAP);
            
            %title(['\bf {GT IC} ',int2str(k)],'fontSize',8);
            subplot(6,8,8+k);
            plot(RealTCMatZ(:,k));
            %title(['\bf {GT TC} ',int2str(k)],'fontSize',8);
             %xlabel('Time');
            xlim([0 timepoints]);
            ylim([-4 4]);
        end
    end
        if j==2
            for k=1:size(RealSouMat,1)
                h=subplot(6,8,16+k);
                arg1 = linspace(-1,1,M);
                imagesc(arg1,arg1,reshape(RealSouInMaskZPlMask(k,:),M,N));
                axis xy; axis square; axis off;
                hold on
                BL = polar(h, linspace(0,2*pi,256),ones(1,256));
                set(BL, 'Color', 'w', 'LineWidth', 1);
                amax = max(abs(reshape(RealSouInMaskZPlMask(k,:),1,[])));
                set(h, 'CLIM', [-amax, amax])
                colormap(CMAP);
                
                %title(['\bf {GT IC} ',int2str(k)],'fontSize',8);
                subplot(6,8,16+8+k);
                plot(RealTCMatZ(:,k));
                %title(['\bf {GT TC} ',int2str(k)],'fontSize',8);
                % xlabel('Time');
                xlim([0 timepoints]);
                ylim([-4 4]);
                
            end
        end
        
end
    
cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date))); 
saveas(h1,'GTExp1_1.fig');
saveas(h2,'GTExp1_2.fig');
saveas(h3,'GTExp1_3.fig');
saveas(h1,'GTExp1_1.png');
saveas(h2,'GTExp1_2.png');
saveas(h3,'GTExp1_3.png');


%%
%show contour of spatial maps to show the spatial varibility more clearly.
% Define preferences for simtb_showSMContours

contour_level = 0.5; % draw contours at half the maximum value
FILL_flag = 0; % do not fill contours
cmap = jet(sbnum+2); % use different colors for each subject
cmap = cmap(3:sbnum+2,:); % skip first colors to avoid dark blue
LEGEND_flag=0;
BLKbg_flag=1;
%h4=figure;
% Plot the SMs
for c = 1:ICnum % loop of the sources of interest
  
    OneICSMDifSub=[];
    
    %get the corresponding ICs across different subjects
    for i=1:sbnum
        if i<10
            strzero='00';
        else if i>9&&i<100
                strzero='0';
            end
        end
        
        load (strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\',DataFolder,'\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_SIM.mat'));
        RealSouMat=SM;
        %RealTCMat=TC;
        
        %         %get the data in mask
        %         RealSouInMask=zeros(ICnum,VoxNum);
        %         h=1;
        %         for k=1:M*N*L
        %             if MaskVec(k)==1
        %                 RealSouInMask(:,h)=RealSouMat(:,k);
        %                 h=h+1;
        %             end
        %         end
        %
        %         %zscore the data in mask
        %         for l=1:size(RealSouMat,1)
        %             RealSouInMaskZ(l,:)=(RealSouInMask(l,:)-mean(RealSouInMask(l,:)))/std(RealSouInMask(l,:));
        %             RealTCMatZ(:,l)=(RealTCMat(:,l)-mean(RealTCMat(:,l)))/std(RealTCMat(:,l));
        %         end
        %
        %         %plus the mask for zscored DataInMask
        %         RealSouInMaskZPlMask=zeros(ICnum,M*N*L);
        %         h=1;
        %         for K=1:M*N*L
        %             if MaskVec(K)==0
        %                 RealSouInMaskZPlMask(:,K)=0;%NaN;
        %             else
        %                 RealSouInMaskZPlMask(:,K)=RealSouInMaskZ(:,h);
        %                 h=h+1;
        %             end
        %         end
        OneICSMDifSub=[OneICSMDifSub;SM(c,:)];
    end
  
    %f=subplot(1,ICnum,c);  set(f,'Color','Black')
    %h4=figure;
    h4=simtb_showSMContours(OneICSMDifSub, contour_level, cmap, FILL_flag,LEGEND_flag, BLKbg_flag);%SM_c  size = [number of components x number of voxels]
   
    %mkdir(strcat('E:\aMRN\aProject\CompareGIGICA\Result\SimTB\',num2str(DataParameter),num2str(date),'\contour'));
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date))); 
    saveas(h4,strcat('GTExp1_4_IC',num2str(c),'.fig'));
    saveas(h4,strcat('GTExp1_4_IC',num2str(c),'.png'));
    %export_fig(strcat('GTExp1_4_IC',num2str(c),'.pdf'),h4);
     %print('-dtiff','-r200',strcat('GTExp1_4_IC',num2str(c)))
     %can print figure mannually using matlab 
end

h5=figure;
% Plot the SMs
for c = 1:ICnum % loop of the sources of interest
  
    OneICSMDifSub=[];
    
    %get the corresponding ICs across different subjects
    for i=1:sbnum
        if i<10
            strzero='00';
        else if i>9&&i<100
                strzero='0';
            end
        end
        
        load (strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\',DataFolder,'\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_SIM.mat'));
        RealSouMat=SM;
        %RealTCMat=TC;
        
        %         %get the data in mask
        %         RealSouInMask=zeros(ICnum,VoxNum);
        %         h=1;
        %         for k=1:M*N*L
        %             if MaskVec(k)==1
        %                 RealSouInMask(:,h)=RealSouMat(:,k);
        %                 h=h+1;
        %             end
        %         end
        %
        %         %zscore the data in mask
        %         for l=1:size(RealSouMat,1)
        %             RealSouInMaskZ(l,:)=(RealSouInMask(l,:)-mean(RealSouInMask(l,:)))/std(RealSouInMask(l,:));
        %             RealTCMatZ(:,l)=(RealTCMat(:,l)-mean(RealTCMat(:,l)))/std(RealTCMat(:,l));
        %         end
        %
        %         %plus the mask for zscored DataInMask
        %         RealSouInMaskZPlMask=zeros(ICnum,M*N*L);
        %         h=1;
        %         for K=1:M*N*L
        %             if MaskVec(K)==0
        %                 RealSouInMaskZPlMask(:,K)=0;%NaN;
        %             else
        %                 RealSouInMaskZPlMask(:,K)=RealSouInMaskZ(:,h);
        %                 h=h+1;
        %             end
        %         end
        OneICSMDifSub=[OneICSMDifSub;SM(c,:)];
    end
    f=subplot(1,ICnum,c);  %set(f,'Color','Black')
    simtb_showSMContours(OneICSMDifSub, contour_level, cmap, FILL_flag,LEGEND_flag, BLKbg_flag, f);%SM_c  size = [number of components x number of voxels]
    %can use print of matlab to output figure
end
    cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date))); 
    saveas(h5,strcat('GTExp1_5.fig'));
    saveas(h5,strcat('GTExp1_5.png'));

% SeleTimepoint=80;M=148;N=148;L=1;
% h6=figure;
%     %show the simulated ovservation data for differnt subjects
%      for i=1:8
%         if i<10
%             strzero='00';
%         else if i>9&&i<100
%                 strzero='0';
%             end
%         end
%         v=spm_vol(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationData\',DataFolder,'\',num2str(DataParameter),'\',num2str(DataParameter),'_subject_',num2str(strzero),num2str(i),'_DATA.nii'));
%         dat=spm_read_vols(v);
%         for j=1:timepoints
%             FmriVec=reshape(dat(:,:,:,j),1,[]);
%             FmriMatr(j,:) = FmriVec;
%         end
%         
%         SeleData=FmriMatr(SeleTimepoint,:);
%         subplot(1,8,i);
%         SeleData2D=reshape(SeleData,M,N);
%         imshow(SeleData2D,[15 900]); %do not know why can not show correctly. 
%         %colorbar;
%      end
%      
%     cd(strcat('C:\Users\ydu\aMRN_Related\aProject\CompareIVAGIGICA\SimulationResults\',num2str(DataParameter),num2str(date))); 
%     saveas(h6,strcat('GTExp1_6.fig'));
%     saveas(h6,strcat('GTExp1_6.png'));

%%
%I should show the simulated image under different CNR, if I choose 8
%images, I could select CNR as 0.5, 0.7,0.9,1.1,1.3,1.5,1.7,1.9