function [GraphicsHandle]=neuromark_getGraphics(TitleFig, GraphicsType, Tag, visible)
% [GraphicsHandle]=icatb_getGraphics(Title,Rect,Tag)
%--------------------------------------------------------------------------
% CREATED BY: Eric Egolf 
% LAST MODIFIED: 12-29-03
% ABOUT: Sets up a figure to be used as a graphics display figure. Returns
%        the Handle to the figure
% 
% #########################################################################
% 
% USAGE: (* means optional)
% 
% - [GraphicsHandle]=icatb_getGraphics(Title,Rect,Tag)
%   INFO: Using parameters setsup a figure
%   PARAMETERS:
%       *Title = Title for figure
%           default = 'Graphics'
%       *Rect = [x y height width]
%           default = [500 100 600 600];       
%       *Tag = Tag for figure
%           default = 'Graphics'
% #############################################################
% 
% LICENSING:
% 
%------------------------------------------------------

 
 
 
BG_COLOR=[0 0 0];
% BG_COLOR=[1 1 1];
FG_COLOR=[0.562 0.562 0.562];
AXES_COLOR=[0.25 0.25 0.25];
FONT_COLOR=[1 1 1];
if(~exist('TitleFig','var'))
    TitleFig = 'Graphics';
end
if(~exist('GraphicsType','var'))
    GraphicsType = 'normal';
end
if(~exist('Tag','var'))
    Tag = 'Graphics';
end

if ~exist('visible', 'var')
    visible = 'on';
end
screen_size=get(0,'screensize');
% visible='on';
 
paperOrient = 'portrait';
 
left=(screen_size(3)-1000)/2;
Rect=[left 30 1000 screen_size(4)-120];
% %-----------Set Graphics Figure--------------------------     
GraphicsHandle = figure('Tag', Tag, 'units', 'pixels', 'Position', Rect, 'MenuBar', 'figure', ...
            'color', BG_COLOR, 'DefaultTextColor', FONT_COLOR, 'DefaultAxesColor', AXES_COLOR, ...
            'DefaultTextInterpreter', 'none', 'DefaultAxesYColor', 'k', ...
            'DefaultAxesZColor', 'k', 'DefaultPatchFaceColor', 'k', 'DefaultPatchEdgeColor', 'k',...
            'DefaultSurfaceEdgeColor', 'k', 'DefaultLineColor', 'k', 'DefaultUicontrolInterruptible', 'on', ...                                                     
            'Renderer', 'zbuffer', 'RendererMode' , 'manual', 'Visible', visible, 'Name', sprintf(TitleFig), ...
            'paperorientation', paperOrient, 'InvertHardcopy', 'off', 'resize', 'off', 'PaperPositionMode', 'auto'); 
        movegui('center')