function varargout = viewtemp(varargin)
% VIEWTEMP MATLAB code for viewtemp.fig
%      VIEWTEMP, by itself, creates a new VIEWTEMP or raises the existing
%      singleton*.
%
%      H = VIEWTEMP returns the handle to a new VIEWTEMP or the handle to
%      the existing singleton*.
%
%      VIEWTEMP('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in VIEWTEMP.M with the given input arguments.
%
%      VIEWTEMP('Property','Value',...) creates a new VIEWTEMP or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before viewtemp_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to viewtemp_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help viewtemp

% Last Modified by GUIDE v2.5 31-May-2022 17:16:22

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @viewtemp_OpeningFcn, ...
                   'gui_OutputFcn',  @viewtemp_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before viewtemp is made visible.
function viewtemp_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to viewtemp (see VARARGIN)

% Choose default command line output for viewtemp
handles.output = hObject;
set(handles.user,'value',get(handles.user,'min'));
set(handles.our,'value',get(handles.our,'max'));
% set(handles.selection,'enable','off');
set(handles.selectpanel,'visible','off');
set(handles.id1,'visible','on');

         
currentPath=strrep(which('NEUROMARK.m'),strcat('NEUROMARK.m'),'');
load(strcat(currentPath,'template',filesep,'Domain_ICN_ID.mat'));
ID=Domain_ICNID';
ID_new=zeros(53,1);
len=0;
for i=1:size(ID,1)
    ID_new(len+1:len+length(ID{i,2}))=ID{i,2};
    len=len+length(ID{i,2});
end
str='';
for i=1:53
    str=strcat(str,num2str(ID_new(i,:)),',');
end
str(end)='';



set(handles.id1,'string',str);
% Update handles structure
guidata(hObject, handles);

% UIWAIT makes viewtemp wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = viewtemp_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


function id1_Callback(hObject, eventdata, handles)


function id1_CreateFcn(hObject, eventdata, handles)

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function ok_Callback(hObject, eventdata, handles)
fprintf('Please wait......\n');
compSelectState=get(handles.our,'value');%template state(our or users)
 currentPath=strrep(which('NEUROMARK.m'),strcat('NEUROMARK.m'),'');
 if isequal(compSelectState,1)%our
     currentPath=strrep(which('NEUROMARK.m'),strcat('NEUROMARK.m'),'');
     imagepath=fullfile(currentPath,'template','NeuroMark100IC.nii');
     v=spm_vol(imagepath);
     compid=get(handles.id1,'string');
     
 else
     imagepath=get(handles.imagepath,'string');
     v=spm_vol(imagepath);
     compid=get(handles.id2,'string');
 end
  remain=strtrim(compid);
     num=0;
     ICNID=[];
     while remain
        [token,remain]=strtok(remain,',');
        ICNID(num+1,:)=str2num(token);
        num=num+1;
     end
 
     
     %%%%%
      TemplatesData=spm_read_vols(v);
        for j=1:100
          ICVec=reshape(TemplatesData(:,:,:,j),1,[]);
          ICMatr(j,:) = ICVec;
        end
        GICsN2=zeros(num,size(ICMatr,2));
        for i=1:num
            GICsN2(i,:)=ICMatr(ICNID(i,:),:);
        end
     
     
     if isequal(compSelectState,1)
         
        Template_outpath=fullfile(currentPath,'template','SpatialMap');
          if ~exist(Template_outpath,'dir')
            mkdir(Template_outpath);
          end
         v0=spm_vol(fullfile(currentPath,'template','IC_MASK.nii'));
     
          for i=1:num%53
            File_path = strcat(Template_outpath, filesep,'Template Component',32,num2str(ICNID(i,:)),'.nii');
            v0.fname = File_path ;% v0 is mask
            template_3D=reshape(GICsN2(i,:),53,63,52);
            v0.dt=[16,0];
            spm_write_vol(v0,template_3D);
          end
        
        
     else% users 
         dirname=fileparts(imagepath);
         Template_outpath=fullfile(dirname,'SpatialMap');
         if ~exist(Template_outpath,'dir')
            mkdir(Template_outpath);
         end
        ICMask=spm_read_vols(v);
        ICtemp=ICMask(:,:,:,1);
        ICoutpath=strcat(Template_outpath,filesep,'IC_maskUsers.nii');
        v(1).fname=ICoutpath;
        spm_write_vol(v(1),ICtemp);
        v0=spm_vol(ICoutpath);
          for i=1:num%53
            File_path = strcat(Template_outpath, filesep,'Template Component',32,num2str(ICNID(i,:)),'.nii');
            v0.fname = File_path ;% v0 is mask
            template_3D=reshape(GICsN2(i,:),size(ICtemp,1),size(ICtemp,2),size(ICtemp,3));
            v0.dt=[16,0];
            spm_write_vol(v0,template_3D);
          end
         
         
         
     end
   
 
 %4Dͼ

     structFile = strcat(currentPath,'template',filesep,'ch2better_aligned2EPI.nii');
     image_values='positive and negative';
     for i=1:num
        File_path=strcat(Template_outpath, filesep,'Template Component',32,num2str(ICNID(i,:)),'.nii');
        [dd, FileName, extn] = fileparts(deblank(File_path));
        
         fig_title=FileName;
        load coldhot coldhot ;
        cmap = coldhot(1:4:end, :);
        gH = neuromark_plot_orth(File_path, 'structfile', structFile, 'image_values', image_values, 'convert_to_zscores', 'yes', 'threshold', 3, 'set_to_max_voxel', 1, ...
            'labels', '', 'fig_title', fig_title, 'cmap', cmap);
         h0=gH;
         cd(Template_outpath);
         saveas(h0,strcat('Template Component',32,num2str(ICNID(i,:)),'.tif'));
%          close gcf;
        
        
     end
     fprintf('You have viewed all components!\n');
    
 
 
 
 
    
     

function our_Callback(hObject, eventdata, handles)
set(handles.user,'value',get(handles.user,'min'));
set(hObject,'value',get(hObject,'max'));
% set(handles.selection,'enable','off');
set(handles.selectpanel,'visible','off');
set(handles.id1,'visible','on');
% set(handles.comptext,'visible','on');
set(handles.id2,'string',' ','value',1);
set(handles.info,'visible','on');
currentPath=strrep(which('NEUROMARK.m'),strcat('NEUROMARK.m'),'');
load(strcat(currentPath,'template',filesep,'Domain_ICN_ID.mat'));
ID=Domain_ICNID';
ID_new=zeros(53,1);
len=0;
for i=1:size(ID,1)
    ID_new(len+1:len+length(ID{i,2}))=ID{i,2};
    len=len+length(ID{i,2});
end
str='';
for i=1:53
    str=strcat(str,num2str(ID_new(i,:)),',');
end
str(end)='';



set(handles.id1,'string',str);


function user_Callback(hObject, eventdata, handles)
set(handles.our,'value',get(handles.our,'min'));
set(hObject,'value',get(hObject,'max'));
set(handles.selectpanel,'visible','on');
set(handles.id1,'visible','off');
set(handles.info,'visible','off');
% set(handles.comptext,'visible','off');
set(handles.imagepath,'string',pwd);
function edit2_Callback(hObject, eventdata, handles)


function edit2_CreateFcn(hObject, eventdata, handles)

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function imagepath_Callback(hObject, eventdata, handles)


function imagepath_CreateFcn(hObject, eventdata, handles)

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function image_Callback(hObject, eventdata, handles)
[compname,comppath,flag]=uigetfile('*.nii','Please select template');
        if 0~=flag
            comp=fullfile(comppath,compname);
            set(handles.imagepath,'string',comp,'value',1);
            v0=spm_vol(comp);
            compID=1:length(v0);
            str='';
            for i=1:length(v0)
                str=strcat(str,num2str(compID(i)),',');
            end
            str(end)='';

            set(handles.id2,'string',str)
%             data=spm_read_vols(v0);
        else
            warndlg('Please select component file','Warning Dialog');
            
            set(handles.imagepath,'string','');
        end



function id2_Callback(hObject, eventdata, handles)


function id2_CreateFcn(hObject, eventdata, handles)

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in info.
function info_Callback(hObject, eventdata, handles)
% hObject    handle to info (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%  figure,image(load('D:\KYSCode\IABC(20220506)\NeuroMark\utilities\templateInfo.png'));
Info;
