function flag=neuromark_ResliceFunction(reslice)
%Reslice our template to match the dimension of subject's data 
    
%Input:
%     reslice.outputpath: The output path to save results
%     reslice.currentPath:The path where the toolbox resides
%     workdirpath=reslice.workdirpath;
%     reslice.subDirList:The subject lists which will be estimated ICs and related measures
%     reslice.ICNID:The component IDs used as a guide component of the template
%     reslice.compimage:The template as guide components


% Output:
    % All output results are stored in the results directory 
    % Reslice_Output contains the results including original templates and resliced templates with the prefix ''r''.
%-------------------------------------------------------------------------%
%   Written by Yuhui Du and Yanshu Kong (duyuhui@sxu.edu.cn).
%   Copyright (C) 2021
%   All rights reserved.
%   Intelligent Analysis of Medical Image Laboratory
%   ShanXi University,
%   ShanXi, China.

    
 %%
 flag=0;
    outputpath=reslice.outputpath;
    currentPath=reslice.currentPath;
    workdirpath=reslice.workdirpath;
    subDirList=reslice.subDirList;
    ICNID=reslice.ICNID;
    compimage=reslice.compimage;
    
     Reslice_outpath=strcat(outputpath,filesep,'Reslice_Output');
    if ~exist(Reslice_outpath,'dir')
        mkdir(Reslice_outpath);
    end
    ICNUM=size(ICNID,1);   % Number of independent components used in network template
    if isempty(compimage)%use our template
         ICnum=100; % Total number of independent components in network template
         v=spm_vol(strcat(currentPath,'template\NeuroMark100IC.nii'));%4D 53*63*52*100    
    else
        v=spm_vol(compimage);
        ICnum=size(v,1);
    end
    
   %% if need reslice
    
    subFolder=deblank(subDirList(1,:));
    subpath=strcat(workdirpath,filesep,subFolder);
    subFile=dir(strcat(subpath,filesep,'*.nii'));
    v1=spm_vol(strcat(subFile.folder,filesep,subFile.name));%dimesion of subject
     %% Loading the network templates.
    %100 ICs from template
    TemplatesData=spm_read_vols(v);
     Predimension=v(1).dim;
    for j=1:ICnum
      ICVec=reshape(TemplatesData(:,:,:,j),1,[]);
      ICMatr(j,:) = ICVec;
    end
    GICsN2=zeros(ICNUM,size(ICMatr,2));
    for i=1:ICNUM
        GICsN2(i,:)=ICMatr(ICNID(i,:),:);
    end
    ID_new=ICNID;
    
    GIC_outpath=strcat(outputpath,filesep,'Template');
    if ~exist(GIC_outpath,'dir')
        mkdir(GIC_outpath);
    end
    %% extract template mask(dimension)

    ICtemp=TemplatesData(:,:,:,1);
    ICoutpath=strcat(Reslice_outpath,filesep,'IC_MASK.nii');
    v(1).fname=ICoutpath;
    spm_write_vol(v(1),ICtemp);
    v0=spm_vol(ICoutpath);
   
    for i=1:size(GICsN2,1)%53
        File_path = strcat(Reslice_outpath, filesep,'Template Component',32,num2str(ID_new(i,:)),'.nii');
        v0.fname = File_path ;% v0 is mask
        template_3D=reshape(GICsN2(i,:),Predimension(1),Predimension(2),Predimension(3));
        v0.dt=[16,0];
        spm_write_vol(v0,template_3D);
    end
    %% need reslice
     if ~isequal(v1(1).dim,v(1).dim)
        
        for i=1:size(GICsN2,1)%53
            InputFile=strcat(Reslice_outpath,filesep,'Template Component',32,num2str(ID_new(i,:)),'.nii'); 
            OutputFile=strcat(Reslice_outpath,filesep,'rTemplate Component',32,num2str(ID_new(i,:)),'.nii');
%             subVox=abs(diag(v1(1).private.mat))';
%             NewVoxSize=[subVox(1),subVox(2),subVox(3)];
            hld=0;
            TargetSpace=strcat(subFile.folder,filesep,subFile.name);
            fprintf('\n\tReslice the %s IC from template...\n',num2str(ID_new(i,:)));
            neuromark_resliceImage(InputFile,OutputFile,hld, TargetSpace);
            flag=1;
            copyfile(File_path,GIC_outpath);
       end    
     end