function [mask_final,use_final_idx, Dimension]=neuromark_MaskGeneration(neuromark,DataVec)
sublist=neuromark.subDirList;
workpath=neuromark.workdirpath;
outpath=neuromark.outputpath;
mask=neuromark.mask;
subnum=size(sublist,1);

maskpath=fullfile(outpath,'BrainMask');


if ~exist(maskpath,'dir')
    mkdir(maskpath);
end
currentPath=neuromark.currentPath;
mini_corr_top=str2num(neuromark.mini_corr_top);
mini_corr_all=str2num(neuromark.mini_corr_all);
mini_corr_but=str2num(neuromark.mini_corr_but);
%% parameters
perc_thres=0.9; % for group mask, > perc_thres of subjects with 1 then set to 1, otherwise set to 0   
multiplier=0.9;% for individual mask, > multiplier x mean is set to 1, otherwise set to 0
top_slice = [43:52];  % examine the top x slice
but_slice = [6:15];   % examine the buttom x slice
if isempty(mini_corr_all) ||isempty(mini_corr_top)||isempty(mini_corr_but)
    mini_corr_all = 0.8;  % if the individual mask with smaller correlation < mini_corr_all with the compared mask, discard this subject
    mini_corr_top = 0.75;  % if the individual mask with smaller correlation < mini_corr_top with the compared mask, discard this subject
    mini_corr_but = 0.55;  % if the individual mask with smaller correlation < mini_corr_but with the compared mask, discard this subject

end


%read mask
if ~isempty(mask)
    v0=spm_vol(mask);
    MaskData=spm_read_vols(v0);
    MaskData=round(MaskData);
    Mask_Vec=reshape(MaskData,1,[]);
    mask_final=Mask_Vec;
    VoxNum=size(find(Mask_Vec~=0),2);
    use_final_idx=1:size(sublist,1);
end 
if isempty(mask)
    for i=1:subnum
        fprintf('\n\tstart reading the subject''s : %s NFITI image ...\n',sublist(i,:));
        subFolder=deblank(sublist(i,:));
        subpath=strcat(workpath,filesep,subFolder);
        subFile=dir([subpath,filesep,'*.nii']);
        v=spm_vol(strcat(subFile.folder,filesep,subFile.name));
        mask_hdr=v(1);
        Dimension=v.dim;% 
        dat=spm_read_vols(v); 
        timepoints=size(v,1); 
        FmriMatr=[];
        for j=1:timepoints
            FmriVec=reshape(dat(:,:,:,j),1,[]);
            FmriMatr(j,:) = FmriVec;
        end
        firstFmriVec=reshape(dat(:,:,:,1),1,[]);  
       %generate individual mask
         temp_thres = mean(firstFmriVec) .* multiplier;
         SubMask_Vec = (firstFmriVec(:)>= temp_thres);
         allSubMask(i,:) = SubMask_Vec;
    end
   
end
 
%% group mask
% calculate common mask
if isempty(mask)
    mask_comm_temp = zeros(Dimension(1)*Dimension(2)*Dimension(3),1);
    for i = 1:size(allSubMask,2)
        if (sum(allSubMask(:,i))/subnum) >= perc_thres
            mask_comm_temp(i) = 1;
        end
    end
    mask_comm_temp = reshape(mask_comm_temp,Dimension(1),Dimension(2),Dimension(3));
    [corr_mask_all] = GIG_corr_with_mask(mask_comm_temp, reshape(allSubMask, subnum,Dimension(1),Dimension(2),Dimension(3)) , 1:Dimension(3));
    [corr_mask_but] = GIG_corr_with_mask(mask_comm_temp, reshape(allSubMask, subnum, Dimension(1),Dimension(2),Dimension(3)), but_slice);
    [corr_mask_top] = GIG_corr_with_mask(mask_comm_temp, reshape(allSubMask, subnum, Dimension(1),Dimension(2),Dimension(3)), top_slice);


    % choose subject larger than thres
    use_all_idx     = find(corr_mask_all >= mini_corr_all);
    use_top_idx     = find(corr_mask_top >= mini_corr_top);
    use_but_idx     = find(corr_mask_but >= mini_corr_but);


    % overlap idx
    use_final_idx     = intersect(use_top_idx, use_but_idx);
    use_final_idx     = intersect(use_final_idx, use_all_idx);
    % use_discard_idx   = setdiff([1:length(corr_mask_all)], use_final_idx);

    % calculate final mask
    mask_comm_final = zeros(Dimension(1)*Dimension(2)*Dimension(3),1);
    for i = 1:size(allSubMask,2)
        if (sum(allSubMask(use_final_idx,i))/(length(use_final_idx))) >= perc_thres
            mask_comm_final(i) = 1;
        end
    end
end  



%% Generating templates mask
TemMask_Vec=zeros(1,size(DataVec,2));
for j=1:size(DataVec,2)
    if DataVec(1,j)~=0
        TemMask_Vec(j)=1;
    end
end

%% overlap group mask and template 
if isempty(mask)
%     spm_TemMask_Vec=spm_TemMask_Vec';
    mask_overlap=zeros(length(mask_comm_final),1);
    for i=1:length(mask_comm_final)
        if mask_comm_final(i)==1&&TemMask_Vec(i)==1
            mask_overlap(i)=1;
        else
            mask_overlap(i)=0;
        end
    end
    mask_final  = reshape(mask_overlap,  Dimension(1), Dimension(2), Dimension(3));
    hdr_final = mask_hdr;
    maskpath=fullfile(outpath,'BrainMask');

    if ~exist(maskpath,'dir')
        mkdir(maskpath);
    end

    hdr_final.fname= fullfile(maskpath,'comm_mask.nii');
    spm_write_vol(hdr_final, mask_final);

    VoxNum=size(find(mask_final==1),1);
end

%% Write qualified subjects
fid=fopen(strcat(maskpath,filesep,'SubjectInfo.txt'),'a');
if isempty(mask)
   fprintf(fid,'You use brain mask generated by the toolbox...\n');
%    fprintf(fid,'------Below are the subjects retained according to the thresholds------\n');
   fprintf(fid,'The following includes the subject IDs after the subject selection according to the setting.');
   fprintf(fid,'Thresholds are %.2f for whole brain,%.2f for the top slices,and %.2f for the bottom slices\n',mini_corr_all,mini_corr_top,mini_corr_but);
   
else
     fprintf(fid,'You use brain mask provided by yourself...\n');
     fprintf(fid,'The following includes the subject IDs you use to estimate whose brain functional network and time series\n');
end
 
 
for i=1:length(use_final_idx)
    fprintf(fid,'%s\n',sublist(use_final_idx(i),:));   
end