function neuromark_MainFunction(neuromark)
% NeuroMark automatically estimates features adaptable to each individual subject  
% by taking advantage of the reliable brain network templates extracted from 1828 healthy controls as guidance.

% Spm12 are required for this procedure.
% Spm12 a can be downloaded from the following address.
% https://www.fil.ion.ucl.ac.uk/spm/software/download/

%Input:
%     neuromark.workdirpath: The work directory path to store subject files
%     neuromark.mask: The mask path  (can be empty)
%     neuromark.outputpath:The output path to save results
%     neuromark.subDirList:The subject lists which will be estimated ICs and related measures
%     neuromark.currentPath:The path where the toolbox resides
%     neuromark.ICNID:The component IDs used as a guide component of the template

%Output:
      %All output results are stored in the results directory 
      %Neuromark_Output contains the NIFTI images of networks (i.e. ICs) and .mat data of time series for each individual subject.
     
%-------------------------------------------------------------------------%
%   Written by Yuhui Du and Yanshu Kong (duyuhui@sxu.edu.cn).
%   Copyright (C) 2021
%   All rights reserved.
%   Intelligent Analysis of Medical Image Laboratory
%   ShanXi University,
%   ShanXi, China.



% clear;
%% load parameters
workpath=neuromark.workdirpath;
maskImage=neuromark.mask;
outputpath=neuromark.outputpath;
subDirList=neuromark.subDirList;
currentPath=neuromark.currentPath;
ICNID=neuromark.ICNID;
flag=neuromark.flag;


if ~isempty(maskImage)
    v0=spm_vol(mask);
    MaskData=spm_read_vols(v0);
    MaskData=round(MaskData);
    Mask_Vec=reshape(MaskData,1,[]);
    mask_final=Mask_Vec;
    VoxNum=size(find(Mask_Vec~=0),2);
    use_final_idx=1:size(subDirList,1);
end





ICNUM=size(ICNID,1);
ID_new=ICNID;
%% Number of independent components used in network template
% subnum=size(subDirList,1);

%% save template image
GIC_outpath=strcat(outputpath,filesep,'Template');
if ~exist(GIC_outpath,'dir')
    mkdir(GIC_outpath);
end
for i=1:ICNUM
%      resliceTemp=strcat(outputpath,filesep,'Reslice_Output','\rtemplate_IC_',num2str(ICNID(i,:)),'.nii');
      resliceTemp=strcat(outputpath,filesep,'Reslice_Output',filesep,'rTemplate Component',32,num2str(ID_new(i,:)),'.nii');
 
    if exist(resliceTemp,'file')&& flag==1
        File_path=resliceTemp;
    else
        originalTemp=strcat(outputpath,filesep,'Reslice_Output',filesep,'Template Component',32,num2str(ID_new(i,:)),'.nii');
         File_path=originalTemp;
    end
    
  
    v1=spm_vol(File_path);
    data=spm_read_vols(v1);
    TemplateComponent=data;
    DataVec(i,:)=data(:);
   
    structFile = strcat(currentPath,'template',filesep,'ch2better_aligned2EPI.nii');
    image_values='positive and negative';
     [dd, FileName, extn] = fileparts(deblank(File_path));
     fig_title=FileName;
    load coldhot coldhot ;
    cmap = coldhot(1:4:end, :);
    gH = neuromark_plot_orth(File_path, 'structfile', structFile, 'image_values', image_values, 'convert_to_zscores', 'yes', 'threshold', 3, 'set_to_max_voxel', 1, ...
        'labels', '', 'fig_title', fig_title, 'cmap', cmap);
     h0=gH;
     cd(GIC_outpath);
     saveas(h0,strcat('Template Component',32,num2str(ID_new(i,:)),'.tif'));
     close gcf;
     %save as matrix
     File_ICname=strcat(GIC_outpath,filesep,'Template Component',32,num2str(ID_new(i,:)),'.mat');
     save(File_ICname,'TemplateComponent');
end
if isempty(maskImage)
   [mask_final,use_final_idx, Dimension]=neuromark_MaskGeneration(neuromark,DataVec);
end
   

%% 
VoxNum=size(find(mask_final==1),1);
%  Dimension=v.dim;%
 for  i=1:length(use_final_idx)
       fprintf('\n\tstart reading the subject''s : %s NFITI image ...\n',subDirList(use_final_idx(i),:));
         subFolder=deblank(subDirList(use_final_idx(i),:));
        subpath=strcat(workpath,filesep,subFolder);
        subFile=dir([subpath,filesep,'*.nii']);
        v=spm_vol(strcat(subFile.folder,filesep,subFile.name));
        dat=spm_read_vols(v);
        timepoints=size(v,1);
        FmriMatr=[];%all timepoints msg of  one sub 
        for j=1:timepoints
            FmriVec=reshape(dat(:,:,:,j),1,[]);
            FmriMatr(j,:) = FmriVec;
        end
    
        
        h=1;
        FmriMatMask=[];
        for k=1:Dimension(1)*Dimension(2)*Dimension(3)
            if mask_final(k)~=0
                FmriMatMask(:,h)=FmriMatr(:,k);
                h=h+1;
            end
        end
 
        GICsN2=zeros(ICNUM,VoxNum);
        for j=1:ICNUM
            h=1;
            for K=1:Dimension(1)*Dimension(2)*Dimension(3)
                if mask_final(K)~=0
                    GICsN2(j,h)=DataVec(j,K);
                    h=h+1;
                end
            end
        end
        
    
    % Calling the main functions 
    fprintf('\n\tStart estimating ICs and time series for subject %s...\n',subDirList(i,:));
    [GIGICMat1,GIGTCMatB1]=neuromark_GIGICA(FmriMatMask,GICsN2);

    % Reshaping the estimated ICs 
    GIGICMatPlMask=zeros(size(GIGICMat1,1),Dimension(1)*Dimension(2)*Dimension(3));
    h=1;
    for K=1:Dimension(1)*Dimension(2)*Dimension(3)
        if mask_final(K)==0
            GIGICMatPlMask(:,K)=0;
        else
            GIGICMatPlMask(:,K)=GIGICMat1(:,h);
            h=h+1;
        end
    end
    
    neuromark_outputpath=strcat(outputpath,filesep,'Neuromark_Output');
    outpath_corr= strcat(neuromark_outputpath,filesep,subDirList(i,:));
%     out_path_3D = strcat(neuromark_outputpath,filesep,subDirList(i,:),filesep,'3D');%estimate component NIFTI image
    out_path_fig_IC = strcat(neuromark_outputpath,filesep,subDirList(i,:),filesep,'IC');%.tif image and matrix
    out_path_fig_TC = strcat(neuromark_outputpath,filesep,subDirList(i,:),filesep,'TC');%time series image and matrix
    if ~exist(outpath_corr,'dir')
        mkdir(outpath_corr);
    end
%     if ~exist(out_path_3D,'dir')
%         mkdir(out_path_3D);
%     end
    if ~exist(out_path_fig_IC,'dir')
        mkdir(out_path_fig_IC);
    end
    if ~exist(out_path_fig_TC,'dir')
        mkdir(out_path_fig_TC);
    end
    % calculate correlation
    corrMatrix=corr(GIGICMat1',GICsN2');
    coeff_Vec=diag(corrMatrix) ;
    fid=fopen(strcat(outpath_corr,filesep,'coefficient.txt'),'a');
    for jj=1:length(coeff_Vec)
        fprintf(fid,'%d %.4f\r\n',ID_new(jj,:),coeff_Vec(jj,:));   
    end
    % .nii files were generated according to the estimated independent components and mask
    for t=1:size(GIGICMatPlMask,1)
        
        File_path = strcat(out_path_fig_IC,filesep,subDirList(i,:),'_IC_',num2str(ID_new(t,:)),'.nii');
        
        GIGICMatPlMask_3D=reshape(GIGICMatPlMask(t,:),Dimension(1),Dimension(2),[]);
        if ~isempty(maskImage)
            %user input mask
            v0.fname = File_path; % v0 is mask
            v0.dt=[16,0];
            spm_write_vol(v0,GIGICMatPlMask_3D);
        else
            v1.fname = File_path; % v0 is mask
            spm_write_vol(v1,GIGICMatPlMask_3D); %save component
        end
%         v0.dt=[16,0];

        % Generate component image
        fprintf('\n\tGenerating component image %d...\n',ID_new(t,:));
        
        structFile = strcat(currentPath,'template',filesep,'ch2better_aligned2EPI.nii');
        image_values='positive and negative';
         [dd, FileName, extn] = fileparts(deblank(File_path));
         fig_title=FileName;
        load coldhot coldhot ;
        cmap = coldhot(1:4:end, :);
        gH = neuromark_plot_orth(File_path, 'structfile', structFile, 'image_values', image_values, 'convert_to_zscores', 'yes', 'threshold', 3, 'set_to_max_voxel', 1, ...
            'labels', '', 'fig_title', fig_title, 'cmap', cmap);
  
%         fnames = interp2struct(File_path, 1, structFile, out_path_3D);
%         [slices, FH] = makeimage(fnames, structFile,1,'threshold_low',3); % Generating and saving of 3D images
        h0=gH;
        cd(out_path_fig_IC);
        saveas(h0,[subDirList(i,:),'_IC_',num2str(ID_new(t,:)),'.tif']);
        close gcf;
        %save as matrix
        File_ICname=strcat(out_path_fig_IC,filesep,subDirList(i,:),'_IC_',num2str(ID_new(t,:)),'.mat');
        save(File_ICname,'GIGICMatPlMask_3D');
    end

    % Generating and saving TC ;
    fprintf('\n\tGenerating and saving TCs...\n')
    for t=1:size(GIGTCMatB1,2)
        h1=figure;
        x=1:timepoints;
        a=GIGTCMatB1(:,t);
        plot(x,a');
%         legend('Time Course');
        title('Time Course','fontsize',24,'fontweight','bold');
        xlabel('Time Point','fontsize',18,'fontweight','bold');

        ylabel(' Magnitude','fontsize',18,'fontweight','bold');
        grid on;
        cd(out_path_fig_TC);
        saveas(h1,[subDirList(i,:),'_TC_',num2str(ID_new(t,:)),'.jpg']);
        File_TCname=strcat( out_path_fig_TC,filesep,subDirList(i,:),'_TC_',num2str(ID_new(t,:)),'.mat');
        
        save(File_TCname,'a');
        close gcf;
    end
      
end
fclose all;
cd(currentPath);
 
