function varargout = NEUROMARK(varargin)
% NEUROMARK MATLAB code for NEUROMARK.fig
%      NEUROMARK, by itself, creates a new NEUROMARK or raises the existing
%      singleton*.
%
%      H = NEUROMARK returns the handle to a new NEUROMARK or the handle to
%      the existing singleton*.
%
%      NEUROMARK('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in NEUROMARK.M with the given input arguments.
%
%      NEUROMARK('Property','Value',...) creates a new NEUROMARK or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before NEUROMARK_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to NEUROMARK_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help NEUROMARK

% Last Modified by GUIDE v2.5 27-Sep-2022 18:12:32

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
warning off;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @NEUROMARK_OpeningFcn, ...
                   'gui_OutputFcn',  @NEUROMARK_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before NEUROMARK is made visible.
function NEUROMARK_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to NEUROMARK (see VARARGIN)

% Choose default command line output for NEUROMARK
handles.output = hObject;
 
set(handles.maskpath,'enable','off');
set(handles.maskpath,'string','');
set(handles.maskbtn,'visible','off');
set(handles.selectmask,'userdata','1');

set(handles.threshold,'visible','off');


set(hObject,'name','NeuroMark');
if(nargin==5)&&(strcmp(varargin{1},'newstring'))
    
    %Checks for input ID normality
    inputString=varargin{2};
    inputString=strtrim(inputString);%Remove leading and trailing Spaces
    inputString=strrep(inputString,' ',',');

    set(handles.displaySelection,'string',inputString,'value',1);
    setappdata(handles.selection,'compid',inputString);
elseif length(varargin)==0
    
    if isequal(get(handles.ourTemp,'value'),get(handles.ourTemp,'max'))
        set(handles.selectpanel,'visible','off');
        set(handles.defaultComp,'visible','on');
        set(handles.comptext,'visible','on');
    else
        set(handles.selectpanel,'visible','on');
         set(handles.defaultComp,'visible','off');
         set(handles.comptext,'visible','off');
    end
%     setappdata(handles.figure_neuromark,'workdirpath',pwd);
   
%     setappdata(handles.figure_neuromark,'outputpath',pwd);
    
    handles.currentPath=strrep(which(mfilename),strcat(mfilename,'.m'),'');
    guidata(hObject, handles);
    init(handles);
    
end
% Update handles structure
guidata(hObject, handles);
 
   

% --- Outputs from this function are returned to the command line.
function varargout = NEUROMARK_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



function workdirpath_Callback(hObject, eventdata, handles)
% hObject    handle to workdirpath (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of workdirpath as text
%        str2double(get(hObject,'String')) returns contents of workdirpath as a double


% --- Executes during object creation, after setting all properties.
function workdirpath_CreateFcn(hObject, eventdata, handles)
% hObject    handle to workdirpath (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in workdirbutton.
function workdirbutton_Callback(hObject, eventdata, handles)
% hObject    handle to workdirbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% theDir =getappdata(handles.figure_neuromark,'workdirpath');
theDir =get(handles.workdirpath,'string');
theDir =uigetdir(theDir, 'Please select the working directory: ');
    if ~isequal(theDir, 0)
         SetWorkingDir(hObject,handles,theDir);
         set(handles.sublist,'string','','value','default');
         initList(handles);
         h=findall(handles.list_menu,'type','uimenu');
         delete(h);
         uimenu(handles.list_menu,'label','remove all participants','position',1,...
                'callback',{@rmall_Callback,handles});
         uimenu(handles.list_menu,'label','remove selected participant','position',2,...
                'callback',{@reselect_Callback,handles});
    else
         h=warndlg('Please select workingDir file','Warning Dialog');
%          setappdata(handles.figure_neuromark,'workdirpath','');
         set(handles.workdirpath,'string','');
%          initList(handles);
    end	

function maskpath_Callback(hObject, eventdata, handles)
% hObject    handle to maskpath (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of maskpath as text
%        str2double(get(hObject,'String')) returns contents of maskpath as a double


% --- Executes during object creation, after setting all properties.
function maskpath_CreateFcn(hObject, eventdata, handles)
% hObject    handle to maskpath (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in maskbtn.
function maskbtn_Callback(hObject, eventdata, handles)
% hObject    handle to maskbtn (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
    [maskname,maskpath,index]=uigetfile('*.nii','Please select brain mask');
    if 0~=index
        mask=fullfile(maskpath,maskname);
        set(handles.maskpath,'string',mask);
%         setappdata(handles.figure_neuromark,'maskpath',mask);
    else
        warndlg('Please select brain mask file','Warning Dialog');
    end


function outputpath_Callback(hObject, eventdata, handles)
% hObject    handle to outputpath (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of outputpath as text
%        str2double(get(hObject,'String')) returns contents of outputpath as a double


% --- Executes during object creation, after setting all properties.
function outputpath_CreateFcn(hObject, eventdata, handles)
% hObject    handle to outputpath (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in outputbutton.
function outputbutton_Callback(hObject, eventdata, handles)
% hObject    handle to outputbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%     theDir =getappdata(handles.figure_neuromark,'workdirpath');
    theDir =get(handles.outputpath,'string');
    theDir =uigetdir(theDir, 'Please select the output directory: ');
    if ~isequal(theDir, 0)
        set(handles.outputpath,'string',theDir);
%         setappdata(handles.figure_neuromark,'outputpath',theDir);
    else
         h=warndlg('Please select output path','Warning Dialog');
%          setappdata(handles.figure_neuromark,'outputpath','');
         set(handles.outputpath,'string','');
    end
% --- Executes on button press in help.
function help_Callback(hObject, eventdata, handles)
% hObject    handle to help (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
 a=msgbox({'Estimate brain functional network measures from fMRI data.';...
      '...';...
     'About working directory'
     'All the input image files should be arranged in the working directory.';...
     'You need to arrange each subject''s fMRI NFITI data in one directory, and then put all directories under the working directory. i.e.,';...
     '{Working Directory}\{Subject001}\xxx.nii';...
     '{Working Directory}\{Subject002}\xxx.nii';...
     '...';...
     'About brain mask';...
     'If you choose to use your own brain mask, please ensure the mask has the same dimension with your fMRI volume.';...
     'Otherwise, we will generate a brain mask for you automatically.';...
     '...';...
     'About components that are taken as network templates';...
      'If you use your own network templates, please input 4D NIFTI images of the components and the related IDs.';...
      'If you use our network templates, we will use the default NeuroMark network templates and the network IDs.';...
      'We will reslice the templates so as to coincide with your data. You also can select the template IDs by yourself.';...
      '...';...
      'About Output';...
      'There are two output directories:';...
      'Reslice_Output contains the results including original templates and resliced templates with the prefix ''r''.';...
      'Neuromark_Output contains the NIFTI images of networks (i.e. ICs) and .mat data of time series for each individual subject.';...
       '...';...
      'About Viewer';...
      'After calculating component and time series of each individual subject,users can click viewer button to view the NIFTI images of networks ';...
      'and related time series.';...
      '...';...
      'Please cite the NeuroMark paper if you use the toolbox.';...
      '(NeuroMark: An automated and adaptive ICA based pipeline to identify reproducible fMRI markers of brain disorders)';....
      
     
 },'Help');
set(a.Children(1),'string','OK');
 

% --- Executes on button press in run.
function run_Callback(hObject, eventdata, handles)
% hObject    handle to run (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% maskEnableState=get(handles.maskpath,'enable');
switch (get(handles.selectmask,'userdata'))
    case '1'
         error('Please select brain mask!');
         exit;
    case '2'
         mask=get(handles.maskpath,'string');
%          copyfile()
    case '3'
         mask='';
end 


%     maskEnableState=get(handles.maskpath,'enable');
    compSelectState=get(handles.ourTemp,'value');%template state(our or users)
    
    
    if isequal(compSelectState,1)
        %if the template is supported by us
        compimage='';
        compid=get(handles.defaultComp,'string');
        
        
    else
        %if the template is users'
        compimage=getappdata(handles.selection,'compimage');
        compid=getappdata(handles.selection,'compid');
    end
    %split the string
     remain=strtrim(compid);
     num=0;
     ICNID=[];
     while remain
        [token,remain]=strtok(remain,',');
        ICNID(num+1,:)=str2num(token);
        num=num+1;
     end
     
     flag=1;% ensure component id is correct
     if isequal(compSelectState,1)
        flag=1;
        originName=get(handles.figure_neuromark,'userdata');
        for i=1:length(ICNID)
            if ~ismember(ICNID(i),originName)
                flag=0;
                warndlg('There are noises of the Component ID,please check!');
            end
        end
     end
     
     if compSelectState==0
         if  isempty(compimage)
             error('Please input component template!');
             exit;
         end
     end
     
    
    

    outputpath=get(handles.outputpath,'string');
    workdirpath=get(handles.workdirpath,'string');
    subDirList=get(handles.sublist,'string');

    %reslice parameter
    reslice.outputpath=outputpath;
    reslice.currentPath=handles.currentPath;
    reslice.workdirpath=workdirpath;
    reslice.subDirList=subDirList;
    reslice.ICNID=ICNID;
    reslice.compimage=compimage;
 
    %neuromark parameter
    neuromark.workdirpath=workdirpath;
    neuromark.mask=mask;
    neuromark.outputpath=outputpath;
    neuromark.subDirList=subDirList;
    neuromark.currentPath=handles.currentPath;
    neuromark.ICNID=ICNID;
    neuromark.compimage=compimage;
    
    neuromark.mini_corr_top=get(handles.top,'string');
    neuromark.mini_corr_all=get(handles.brain,'string');
    neuromark.mini_corr_but=get(handles.bottom,'string');
    if ~isempty(outputpath)&&~isempty(workdirpath)&&~isempty(subDirList)&&(flag==1)&&~isempty(ICNID)
%     disp('calculate IC...........');
        if ~isempty(mask)
            maskpath=fullfile(outpath,'BrainMask');
            if ~exist(maskpath,'dir')
                mkdir(maskpath);
            end
               copyfile(mask,maskpath);
        end
%     GIG_calculateIC(calcuIC);
       disp('Start reslice image to make template and your data consistent--------------');
        flag=neuromark_ResliceFunction(reslice);
        disp('Start NeuroMark --------------------------------');
        neuromark.flag=flag;
        neuromark_MainFunction(neuromark);
        disp('Complete all process!')
   
    elseif isempty(workdirpath)
        error('Please select working directory!');
        exit; 
    elseif isempty(subDirList)
        error('Please ensure there exists subjects!');
        exit;
     elseif isempty(outputpath)
        error('Please select output path!');
        exit; 
     elseif isempty(ICNID)
        error('Please input component ID!');
        exit; 
            
    end
function init(handles)
%     set(handles.workdirpath ,'String', getappdata(handles.figure_neuromark,'workdirpath'));
    set(handles.workdirpath ,'String',pwd);
%     set(handles.maskpath,'enable','off');
%     set(handles.maskbtn,'visible','off');
%     set(handles.selectmask,'value',1);
     set(handles.maskpath,'enable','off');
     set(handles.maskpath,'string','');
     set(handles.maskbtn,'visible','off');
     set(handles.selectmask,'userdata','1');

    set(handles.threshold,'visible','off');

%     set(handles.outputpath ,'String', getappdata(handles.figure_neuromark,'workdirpath'));
    set(handles.outputpath ,'String', pwd);
    set(handles.sublist,'string','','value','default');
    ID_new=neuromark_defaultComp(handles.defaultComp,handles.currentPath);
    set(handles.figure_neuromark,'userdata',ID_new);
function SetWorkingDir(hObject, handles, ADir)
    if 7==exist(ADir,'dir')
        setappdata(handles.figure_neuromark,'workdirpath',ADir);
%         set(handles.workdirpath,'String', getappdata(handles.figure_neuromark,'workdirpath'));
    set(handles.workdirpath,'String',ADir);
    end
    



% --- Executes on selection change in sublist.
function sublist_Callback(hObject, eventdata, handles)
% hObject    handle to sublist (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns sublist contents as cell array
%        contents{get(hObject,'Value')} returns selected item from sublist


% --- Executes during object creation, after setting all properties.
function sublist_CreateFcn(hObject, eventdata, handles)
% hObject    handle to sublist (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

 
    
  
function initList(handles)
%     dirpath=getappdata(handles.figure_neuromark,'workdirpath');
   dirpath=get(handles.workdirpath,'string');
    subDir=dir(dirpath);
    subDir(1:2)=[]; 
    subDirCell=struct2cell(subDir);
    if ~isempty(subDir)%Load folder only
        n = find(cell2mat(subDirCell(5,:))==0);%Delete the file
         if ~isempty(n)
            subDirCell(:,n)=[];
        end
    end
    for i =1:size(subDirCell,2)%the number of the folder
         index=get(handles.sublist,'value');
         set(handles.sublist,'String',strvcat(get(handles.sublist,'string'),subDirCell{1,i}),'Value',max(index,1))
    end
        setappdata(handles.figure_neuromark,'subDirList',get(handles.sublist,'String'));%Store the subject folder name in the list for later removal
       

    
    


% --------------------------------------------------------------------
function rm_Callback(hObject, eventdata, handles)
% hObject    handle to rm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function list_menu_Callback(hObject, eventdata, handles)
% hObject    handle to list_menu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
 


% --------------------------------------------------------------------
function rmall_Callback(hObject, eventdata, handles)
% hObject    handle to rmall (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
subDirlist=getappdata(handles.figure_neuromark,'subDirList');
if ~isempty(subDirlist)
    setappdata(handles.figure_neuromark,'subDirList','');
    updateList(handles);
end
function updateList(handles)
    set(handles.sublist,'string',getappdata(handles.figure_neuromark,'subDirList'));

% --------------------------------------------------------------------
function reselect_Callback(hObject, eventdata, handles)
% hObject    handle to reselect (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
subDirlist=getappdata(handles.figure_neuromark,'subDirList');

if ~isempty(subDirlist)
    index=get(handles.sublist,'value');
    strs=get(handles.sublist,'string');%character array
    strs(index,:)='';
    set(handles.sublist,'string',strs,'Value',max(1,index-1));%You have to set the value here
    setappdata(handles.figure_neuromark,'subDirList',get(handles.sublist,'string'));
    updateList(handles);
end


% --- Executes on selection change in selectmask.
function selectmask_Callback(hObject, eventdata, handles)
% hObject    handle to selectmask (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns selectmask contents as cell array
%        contents{get(hObject,'Value')} returns selected item from selectmask
%     sel=get(hObject,'value');
%     switch sel
%         case 1
%             set(handles.maskpath,'enable','off');
%             set(handles.maskbtn,'visible','off');
%         case 2
%             %use your mask
%             set(handles.maskpath,'enable','on');
%             set(handles.maskbtn,'visible','on');
%         case 3
%             set(handles.maskpath,'enable','off');
%             set(handles.maskbtn,'visible','off')
%             
%     end
sel=get(hObject,'value');
    switch sel
        case 1
            set(handles.maskpath,'enable','off');
            set(handles.maskpath,'string','');
            set(handles.maskbtn,'visible','off');
            set(handles.selectmask,'userdata','1');
            
           set(handles.threshold,'visible','off');
        case 2
            %use your mask
            set(handles.maskpath,'enable','on');
            set(handles.maskbtn,'visible','on');
           set(handles.selectmask,'userdata','2');
           
           set(handles.threshold,'visible','off');
        case 3
            set(handles.maskpath,'enable','off');
            set(handles.maskbtn,'visible','off');
%             set(handles.maskpath,'string','');
            
           set(handles.selectmask,'userdata','3');
           set(handles.threshold,'visible','on');
            
    end


% --- Executes during object creation, after setting all properties.
function selectmask_CreateFcn(hObject, eventdata, handles)
% hObject    handle to selectmask (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over workdirpath.
function workdirpath_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to workdirpath (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%     setappdata(handles.figure_neuromark,'workdirpath',get(hObject,'String'));
% set(handles.workdirpath,'string',)
% initList(handles);

% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over maskpath.
function maskpath_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to maskpath (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% setappdata(handles.figure_neuromark,'maskpath',get(hObject,'String'));


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over outputpath.
function outputpath_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to outputpath (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% setappdata(handles.figure_neuromark,'outputpath',get(hObject,'String'));



function comppath_Callback(hObject, eventdata, handles)
% hObject    handle to comppath (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of comppath as text
%        str2double(get(hObject,'String')) returns contents of comppath as a double


% --- Executes during object creation, after setting all properties.
function comppath_CreateFcn(hObject, eventdata, handles)
% hObject    handle to comppath (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in comppathbutton.

function edit7_Callback(hObject, eventdata, handles)
% hObject    handle to edit7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit7 as text
%        str2double(get(hObject,'String')) returns contents of edit7 as a double


% --- Executes during object creation, after setting all properties.
function edit7_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in listbox2.
function listbox2_Callback(hObject, eventdata, handles)
% hObject    handle to listbox2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns listbox2 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from listbox2


% --- Executes during object creation, after setting all properties.
function listbox2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to listbox2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function compid_Callback(hObject, eventdata, handles)
% hObject    handle to compid (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of compid as text
%        str2double(get(hObject,'String')) returns contents of compid as a double


% --- Executes during object creation, after setting all properties.
function compid_CreateFcn(hObject, eventdata, handles)
% hObject    handle to compid (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in userTemp.
function userTemp_Callback(hObject, eventdata, handles)
% hObject    handle to userTemp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of userTemp
set(handles.ourTemp,'value',get(handles.ourTemp,'min'));
set(hObject,'value',get(hObject,'max'));
set(handles.selectpanel,'visible','on');
set(handles.defaultComp,'visible','off');
set(handles.comptext,'visible','off');
% --- Executes on button press in ourTemp.
function ourTemp_Callback(hObject, eventdata, handles)
% hObject    handle to ourTemp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of ourTemp
set(handles.userTemp,'value',get(handles.userTemp,'min'));
set(hObject,'value',get(hObject,'max'));
% set(handles.selection,'enable','off');
set(handles.selectpanel,'visible','off');
set(handles.defaultComp,'visible','on');
set(handles.comptext,'visible','on');
 


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over compid.
function compid_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to compid (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% if isequal(get(hObject,'enable'),'on')
%     string=get(hObject,'string');
%     disp(string)
%     h=componentid('oldstring',string);
%     set(h,'visible','on');
% end


% --- Executes on selection change in selection.
function selection_Callback(hObject, eventdata, handles)
% hObject    handle to selection (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns selection contents as cell array
%        contents{get(hObject,'Value')} returns selected item from selection

if isequal(get(handles.figure_neuromark,'selectiontype'),'open')
    index=get(hObject,'value');
    if index==1
        [compname,comppath,flag]=uigetfile('*.nii','Please select template');
        if 0~=flag
            comp=fullfile(comppath,compname);
            setappdata(hObject,'compimage',comp);
            set(handles.displaySelection,'string',comp,'value',1);
        else
            warndlg('Please select component file','Warning Dialog');
        end
    elseif index==2
            string=getappdata(hObject,'compid');
            h=componentid('oldstring',string);
            set(h,'visible','on');
    end
end
if isequal(get(handles.figure_neuromark,'selectiontype'),'normal')
     index=get(hObject,'value');
     if index==1
           set(handles.displaySelection,'string',getappdata(hObject,'compimage'),'value',1);
     elseif index==2
          set(handles.displaySelection,'string',getappdata(hObject,'compid'),'value',1);
     end
end

% --- Executes during object creation, after setting all properties.
function selection_CreateFcn(hObject, eventdata, handles)
% hObject    handle to selection (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in displaySelection.
function displaySelection_Callback(hObject, eventdata, handles)
% hObject    handle to displaySelection (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns displaySelection contents as cell array
%        contents{get(hObject,'Value')} returns selected item from displaySelection


% --- Executes during object creation, after setting all properties.
function displaySelection_CreateFcn(hObject, eventdata, handles)
% hObject    handle to displaySelection (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function defaultComp_Callback(hObject, eventdata, handles)
% hObject    handle to defaultComp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of defaultComp as text
%        str2double(get(hObject,'String')) returns contents of defaultComp as a double
setappdata(hObject,'updateCompId',get(hObject,'string'));


% --- Executes during object creation, after setting all properties.
function defaultComp_CreateFcn(hObject, eventdata, handles)
% hObject    handle to defaultComp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over defaultComp.
function defaultComp_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to defaultComp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in viewer.
function viewer_Callback(hObject, eventdata, handles)
% hObject    handle to viewer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
 

selectSubject;
 


function spatialmap_Callback(hObject, eventdata, handles)
viewtemp;


% --- Executes on button press in pushbutton10.
function pushbutton10_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton10 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)



function brain_Callback(hObject, eventdata, handles)
% hObject    handle to brain (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of brain as text
%        str2double(get(hObject,'String')) returns contents of brain as a double


% --- Executes during object creation, after setting all properties.
function brain_CreateFcn(hObject, eventdata, handles)
% hObject    handle to brain (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function bottom_Callback(hObject, eventdata, handles)
% hObject    handle to bottom (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of bottom as text
%        str2double(get(hObject,'String')) returns contents of bottom as a double


% --- Executes during object creation, after setting all properties.
function bottom_CreateFcn(hObject, eventdata, handles)
% hObject    handle to bottom (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in help.
function pushbutton11_Callback(hObject, eventdata, handles)
% hObject    handle to help (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)



function top_Callback(hObject, eventdata, handles)
% hObject    handle to top (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of top as text
%        str2double(get(hObject,'String')) returns contents of top as a double


% --- Executes during object creation, after setting all properties.
function top_CreateFcn(hObject, eventdata, handles)
% hObject    handle to top (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
